/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Cache;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.JoinTable;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreTableStruct;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.TransformResultSet;
import org.teasoft.honey.osql.name.NameUtil;

public class SqlLib
implements BeeSql {
    private Cache cache = BeeFactory.getHoneyFactory().getCache();
    private int cacheWorkResultSetSize;
    private static boolean showSQL = HoneyConfig.getHoneyConfig().showSQL;
    private static final String index1 = "_SYS[index";
    private static final String index2 = "]_End ";
    private static final String index3 = "]";

    public SqlLib() {
        this.cacheWorkResultSetSize = HoneyConfig.getHoneyConfig().cache_workResultSetSize;
    }

    private Connection getConn() throws SQLException {
        return HoneyContext.getConn();
    }

    public <T> List<T> select(String sql, T entity) {
        return this.selectSomeField(sql, entity);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> selectSomeField(String sql, T entity) {
        if (sql == null || "".equals(sql.trim())) {
            return Collections.emptyList();
        }
        boolean isReg = this.updateInfoInCache(sql, "List<T>", SuidType.SELECT);
        if (isReg) {
            Object cacheObj = this.cache.get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                List list = (List)cacheObj;
                this.logSelectRows(list.size());
                return list;
            }
            this.initRoute(SuidType.SELECT, entity.getClass(), sql);
        }
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        Object targetObj = null;
        ArrayList<Object> rsList = null;
        Hashtable<String, Field> map = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            ResultSetMetaData rmeta = rs.getMetaData();
            int columnCount = rmeta.getColumnCount();
            rsList = new ArrayList<Object>();
            map = new Hashtable<String, Field>();
            Field field = null;
            String name = null;
            boolean isFirst = true;
            while (true) {
                if (rs.next()) {
                    targetObj = entity.getClass().newInstance();
                } else {
                    this.addInCache(sql, rsList, "List<T>", SuidType.SELECT, rsList.size());
                    this.clearContext(sql);
                    if (hasException) {
                        this.checkClose(rs, pst, null);
                        this.closeConn(conn);
                    } else {
                        this.checkClose(rs, pst, conn);
                    }
                    entity = null;
                    targetObj = null;
                    map = null;
                    this.logSelectRows(rsList.size());
                    return rsList;
                }
                for (int i = 0; i < columnCount; ++i) {
                    block24: {
                        try {
                            name = SqlLib._toFieldName(rmeta.getColumnName(i + 1));
                            if (isFirst) {
                                field = entity.getClass().getDeclaredField(name);
                                map.put(name, field);
                                break block24;
                            } else {
                                field = (Field)map.get(name);
                                if (field == null) {
                                }
                            }
                        }
                        catch (NoSuchFieldException e) {}
                        continue;
                    }
                    field.setAccessible(true);
                    try {
                        field.set(targetObj, rs.getObject(i + 1));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        field.set(targetObj, this._getObjectByindex(rs, field, i + 1));
                    }
                }
                rsList.add(targetObj);
                isFirst = false;
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    hasException = true;
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    hasException = true;
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                this.clearContext(sql);
                if (hasException) {
                    this.checkClose(rs, pst, null);
                    this.closeConn(conn);
                } else {
                    this.checkClose(rs, pst, conn);
                }
                entity = null;
                targetObj = null;
                map = null;
                throw throwable;
            }
        }
    }

    public String selectFun(String sql) {
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "String", SuidType.SELECT);
        if (isReg) {
            Object cacheObj = this.cache.get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                return (String)cacheObj;
            }
            this.initRoute(SuidType.SELECT, null, sql);
        }
        String result = null;
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            if (rs.next()) {
                result = rs.getObject(1) == null ? "" : rs.getObject(1).toString();
            }
            boolean hasMore = false;
            if (rs.next()) {
                hasMore = true;
            }
            if (hasMore) {
                throw new ObjSQLException("ObjSQLException:The size of ResultSet more than 1.");
            }
            this.addInCache(sql, result, "String", SuidType.SELECT, 1);
            this.clearContext(sql);
            if (hasException) {
                this.checkClose(rs, pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(rs, pst, conn);
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.clearContext(sql);
                if (hasException) {
                    this.checkClose(rs, pst, null);
                    this.closeConn(conn);
                } else {
                    this.checkClose(rs, pst, conn);
                }
                throw throwable;
            }
        }
        return result;
    }

    public List<String[]> select(String sql) {
        if (sql == null || "".equals(sql.trim())) {
            return Collections.emptyList();
        }
        boolean isReg = this.updateInfoInCache(sql, "List<String[]>", SuidType.SELECT);
        if (isReg) {
            Object cacheObj = this.cache.get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                List list = (List)cacheObj;
                this.logSelectRows(list.size());
                return list;
            }
            this.initRoute(SuidType.SELECT, null, sql);
        }
        List<Object> list = new ArrayList();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            list = TransformResultSet.toStringsList(rs);
            this.logSelectRows(list.size());
            this.addInCache(sql, list, "List<String[]>", SuidType.SELECT, list.size());
            this.clearContext(sql);
            if (hasException) {
                this.checkClose(rs, pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(rs, pst, conn);
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.clearContext(sql);
                if (hasException) {
                    this.checkClose(rs, pst, null);
                    this.closeConn(conn);
                } else {
                    this.checkClose(rs, pst, conn);
                }
                throw throwable;
            }
        }
        return list;
    }

    public List<Map<String, Object>> selectMapList(String sql) {
        if (sql == null || "".equals(sql.trim())) {
            return Collections.emptyList();
        }
        boolean isReg = this.updateInfoInCache(sql, "List<Map<String,Object>>", SuidType.SELECT);
        if (isReg) {
            Object cacheObj = this.cache.get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                List list = (List)cacheObj;
                this.logSelectRows(list.size());
                return list;
            }
            this.initRoute(SuidType.SELECT, null, sql);
        }
        List<Object> list = new ArrayList();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            list = TransformResultSet.toMapList(rs);
            this.logSelectRows(list.size());
            this.addInCache(sql, list, "List<Map<String,Object>>", SuidType.SELECT, list.size());
            this.clearContext(sql);
            if (hasException) {
                this.checkClose(rs, pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(rs, pst, conn);
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.clearContext(sql);
                if (hasException) {
                    this.checkClose(rs, pst, null);
                    this.closeConn(conn);
                } else {
                    this.checkClose(rs, pst, conn);
                }
                throw throwable;
            }
        }
        return list;
    }

    public int modify(String sql) {
        if (sql == null || "".equals(sql)) {
            return -2;
        }
        this.initRoute(SuidType.MODIFY, null, sql);
        int num = 0;
        Connection conn = null;
        PreparedStatement pst = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            num = pst.executeUpdate();
        }
        catch (SQLException e) {
            hasException = true;
            throw ExceptionHelper.convert(e);
        }
        finally {
            this.clearInCache(sql, "int", SuidType.MODIFY, num);
            if (hasException) {
                this.checkClose(pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(pst, conn);
            }
        }
        Logger.logSQL(" | <--  Affected rows: ", num + "");
        return num;
    }

    public long insertAndReturnId(String sql) {
        if (sql == null || "".equals(sql)) {
            return -2L;
        }
        this.initRoute(SuidType.INSERT, null, sql);
        int num = 0;
        long returnId = -1L;
        Connection conn = null;
        PreparedStatement pst = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql, new String[]{"id"});
            this.setPreparedValues(pst, sql);
            num = pst.executeUpdate();
            ResultSet rsKey = pst.getGeneratedKeys();
            rsKey.next();
            returnId = rsKey.getLong(1);
            this.clearInCache(sql, "int", SuidType.INSERT, num);
            if (hasException) {
                this.checkClose(pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(pst, conn);
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.clearInCache(sql, "int", SuidType.INSERT, num);
                if (hasException) {
                    this.checkClose(pst, null);
                    this.closeConn(conn);
                } else {
                    this.checkClose(pst, conn);
                }
                throw throwable;
            }
        }
        Logger.logSQL(" | <--  Affected rows: ", num + "");
        return returnId;
    }

    public String selectJson(String sql) {
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "StringJson", SuidType.SELECT);
        if (isReg) {
            Object cacheObj = this.cache.get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                return (String)cacheObj;
            }
            this.initRoute(SuidType.SELECT, null, sql);
        }
        StringBuffer json = new StringBuffer("");
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            json = TransformResultSet.toJson(rs);
            this.addInCache(sql, json.toString(), "StringJson", SuidType.SELECT, -1);
            this.clearContext(sql);
            if (hasException) {
                this.checkClose(rs, pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(rs, pst, conn);
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.clearContext(sql);
                if (hasException) {
                    this.checkClose(rs, pst, null);
                    this.closeConn(conn);
                } else {
                    this.checkClose(rs, pst, conn);
                }
                throw throwable;
            }
        }
        return json.toString();
    }

    public int batch(String[] sql) {
        if (sql == null) {
            return -1;
        }
        int batchSize = HoneyConfig.getHoneyConfig().insertBatchSize;
        return this.batch(sql, batchSize);
    }

    /*
     * Loose catch block
     */
    public int batch(String[] sql, int batchSize) {
        int total;
        block26: {
            boolean hasException;
            boolean oldAutoCommit;
            PreparedStatement pst;
            Connection conn;
            int len;
            block24: {
                if (sql == null || sql.length < 1) {
                    return -1;
                }
                if (HoneyUtil.isMysql()) {
                    return this.batchForMysql(sql, batchSize);
                }
                this.initRoute(SuidType.INSERT, null, sql[0]);
                len = sql.length;
                total = 0;
                int temp = 0;
                conn = null;
                pst = null;
                oldAutoCommit = false;
                hasException = false;
                conn = this.getConn();
                oldAutoCommit = conn.getAutoCommit();
                conn.setAutoCommit(false);
                String exe_sql = HoneyUtil.deleteLastSemicolon(sql[0]);
                pst = conn.prepareStatement(exe_sql);
                if (len <= batchSize) {
                    total = this.batch(sql[0], 0, len, conn, pst);
                    break block24;
                }
                for (int i = 0; i < len / batchSize; ++i) {
                    temp = this.batch(sql[0], i * batchSize, (i + 1) * batchSize, conn, pst);
                    total += temp;
                    pst.clearBatch();
                    pst.clearParameters();
                }
                if (len % batchSize == 0) break block24;
                temp = this.batch(sql[0], len - len % batchSize, len, conn, pst);
                total += temp;
            }
            try {
                if (conn != null) {
                    conn.setAutoCommit(oldAutoCommit);
                }
            }
            catch (Exception e3) {
                Logger.debug(e3.getMessage());
            }
            if (hasException) {
                this.checkClose(pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(pst, conn);
            }
            break block26;
            catch (SQLException e) {
                block25: {
                    int n;
                    try {
                        hasException = true;
                        this.clearContext(sql[0], batchSize, len);
                        if (!this.isConstraint(e)) break block25;
                        Logger.warn(e.getMessage());
                        Logger.error(e.getMessage());
                        n = total;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (conn != null) {
                                conn.setAutoCommit(oldAutoCommit);
                            }
                        }
                        catch (Exception e3) {
                            Logger.debug(e3.getMessage());
                        }
                        if (hasException) {
                            this.checkClose(pst, null);
                            this.closeConn(conn);
                        } else {
                            this.checkClose(pst, conn);
                        }
                        this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
                        throw throwable;
                    }
                    try {
                        if (conn != null) {
                            conn.setAutoCommit(oldAutoCommit);
                        }
                    }
                    catch (Exception e3) {
                        Logger.debug(e3.getMessage());
                    }
                    if (hasException) {
                        this.checkClose(pst, null);
                        this.closeConn(conn);
                    } else {
                        this.checkClose(pst, conn);
                    }
                    this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
                    return n;
                }
                Logger.warn(e.getMessage());
                throw ExceptionHelper.convert(e);
            }
        }
        this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
        return total;
    }

    private int batch(String sql, int start, int end, Connection conn, PreparedStatement pst) throws SQLException {
        int a = 0;
        for (int i = start; i < end; ++i) {
            if (showSQL) {
                if (i == 0) {
                    Logger.logSQL(" insert[] SQL : ", sql);
                }
                OneTimeParameter.setAttribute("_SYS_Bee_BatchInsert", i + "");
                String sql_i = index1 + i + index2 + sql;
                Logger.logSQL(" insert[] SQL : ", sql_i);
            }
            this.setAndClearPreparedValues(pst, index1 + i + index2 + sql);
            pst.addBatch();
        }
        int[] array = pst.executeBatch();
        a = HoneyUtil.isOracle() ? pst.getUpdateCount() : this.countFromArray(array);
        conn.commit();
        Logger.logSQL(" | <-- index[" + start + "~" + (end - 1) + index3 + " Affected rows: ", a + "");
        return a;
    }

    private int countFromArray(int[] array) {
        int a = 0;
        if (array == null) {
            return a;
        }
        for (int i = 0; i < array.length; ++i) {
            a += array[i];
        }
        return a;
    }

    /*
     * Loose catch block
     */
    private int batchForMysql(String[] sql, int batchSize) {
        int total;
        block25: {
            boolean hasException;
            boolean oldAutoCommit;
            PreparedStatement pst;
            Connection conn;
            int len;
            block23: {
                if (sql == null || sql.length < 1) {
                    return -1;
                }
                this.initRoute(SuidType.INSERT, null, sql[0]);
                len = sql.length;
                total = 0;
                int temp = 0;
                String placeholderValue = (String)OneTimeParameter.getAttribute("_SYS_Bee_PlaceholderValue");
                conn = null;
                pst = null;
                oldAutoCommit = false;
                hasException = false;
                conn = this.getConn();
                oldAutoCommit = conn.getAutoCommit();
                conn.setAutoCommit(false);
                String exe_sql = HoneyUtil.deleteLastSemicolon(sql[0]);
                if (len <= batchSize) {
                    String[] batchExeSql = this.getBatchExeSql(exe_sql, len, placeholderValue);
                    pst = conn.prepareStatement(batchExeSql[0]);
                    total = this._batchForMysql(sql[0], 0, len, conn, pst, batchSize, batchExeSql[1]);
                    break block23;
                }
                String[] batchExeSql = this.getBatchExeSql(exe_sql, batchSize, placeholderValue);
                pst = conn.prepareStatement(batchExeSql[0]);
                for (int i = 0; i < len / batchSize; ++i) {
                    temp = this._batchForMysql(sql[0], i * batchSize, (i + 1) * batchSize, conn, pst, batchSize, batchExeSql[1]);
                    total += temp;
                }
                if (len % batchSize == 0) break block23;
                batchExeSql = this.getBatchExeSql(exe_sql, len % batchSize, placeholderValue);
                pst = conn.prepareStatement(batchExeSql[0]);
                temp = this._batchForMysql(sql[0], len - len % batchSize, len, conn, pst, batchSize, batchExeSql[1]);
                total += temp;
            }
            try {
                if (conn != null) {
                    conn.setAutoCommit(oldAutoCommit);
                }
            }
            catch (Exception e2) {
                Logger.debug(e2.getMessage());
            }
            if (hasException) {
                this.checkClose(pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(pst, conn);
            }
            break block25;
            catch (SQLException e) {
                block24: {
                    int n;
                    try {
                        hasException = true;
                        this.clearContextForMysql(sql[0], batchSize, len);
                        if (!this.isConstraint(e)) break block24;
                        Logger.warn(e.getMessage());
                        n = total;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (conn != null) {
                                conn.setAutoCommit(oldAutoCommit);
                            }
                        }
                        catch (Exception e2) {
                            Logger.debug(e2.getMessage());
                        }
                        if (hasException) {
                            this.checkClose(pst, null);
                            this.closeConn(conn);
                        } else {
                            this.checkClose(pst, conn);
                        }
                        this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
                        throw throwable;
                    }
                    try {
                        if (conn != null) {
                            conn.setAutoCommit(oldAutoCommit);
                        }
                    }
                    catch (Exception e2) {
                        Logger.debug(e2.getMessage());
                    }
                    if (hasException) {
                        this.checkClose(pst, null);
                        this.closeConn(conn);
                    } else {
                        this.checkClose(pst, conn);
                    }
                    this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
                    return n;
                }
                Logger.warn(e.getMessage());
                throw ExceptionHelper.convert(e);
            }
        }
        this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
        return total;
    }

    private void clearContext(String sql_0, int batchSize, int len) {
        for (int i = 0; i < len; ++i) {
            String sql_i = index1 + i + index2 + sql_0;
            this.clearContext(sql_i);
        }
    }

    private void clearContextForMysql(String sql_0, int batchSize, int len) {
        this.clearContext(sql_0, batchSize, len);
        int num = (len - 1) / batchSize;
        for (int k = 0; k <= num; ++k) {
            String sqlForGetValue = sql_0 + "  [Batch:" + k + index3;
            this.clearContext(sqlForGetValue);
        }
    }

    private boolean isConstraint(SQLException e) {
        String className = e.getClass().getSimpleName();
        String fullClassName = e.getClass().getName();
        return "MySQLIntegrityConstraintViolationException".equals(className) || e.getMessage().startsWith("Duplicate entry ") || e instanceof SQLIntegrityConstraintViolationException || e.getMessage().contains("ORA-00001:") || e instanceof BatchUpdateException || e.getMessage().contains("duplicate key") || e.getMessage().contains("DUPLICATE KEY") || e.getMessage().contains("primary key violation") || "org.h2.jdbc.JdbcBatchUpdateException".equals(fullClassName) || e.getMessage().contains("SQLITE_CONSTRAINT_PRIMARYKEY") || e.getMessage().contains("PRIMARY KEY constraint") || e.getMessage().contains("Duplicate entry") || e.getMessage().contains("Duplicate Entry") || e.getMessage().contains("Duplicate key") || e.getMessage().contains("Duplicate Key");
    }

    private int _batchForMysql(String sql, int start, int end, Connection conn, PreparedStatement pst, int batchSize, String batchSqlForPrint) throws SQLException {
        if (showSQL) {
            if (start == 0 || end - start != batchSize) {
                Logger.logSQL(" insert[] SQL : ", batchSqlForPrint);
            }
            for (int i = start; i < end; ++i) {
                OneTimeParameter.setAttribute("_SYS_Bee_BatchInsert", i + "");
                String sql_i = index1 + i + index2 + sql;
                Logger.logSQL(" insert[] SQL : ", sql_i);
            }
        }
        int a = 0;
        String sqlForGetValue = sql + "  [Batch:" + start / batchSize + index3;
        this.setAndClearPreparedValues(pst, sqlForGetValue);
        a = pst.executeUpdate();
        conn.commit();
        Logger.logSQL(" | <-- [Batch:" + start / batchSize + index3 + " Affected rows: ", a + "");
        return a;
    }

    private String[] getBatchExeSql(String sql0, int size, String placeholderValue) {
        StringBuffer batchSql = new StringBuffer(sql0);
        StringBuffer batchSql_forPrint = new StringBuffer(sql0);
        String[] batchExeSql = new String[2];
        for (int i = 0; i < size - 1; ++i) {
            batchSql.append(",");
            batchSql.append(placeholderValue);
            if (size > 10 && i == 1) {
                batchSql_forPrint.append(",......,");
                continue;
            }
            if (size > 10 && i == size - 2) {
                batchSql_forPrint.append(placeholderValue);
                batchSql_forPrint.append("      ");
                batchSql_forPrint.append("Total of records : ");
                batchSql_forPrint.append(size);
                continue;
            }
            if (size > 10 && i > 1) continue;
            batchSql_forPrint.append(",");
            batchSql_forPrint.append(placeholderValue);
        }
        batchExeSql[0] = batchSql.toString();
        batchExeSql[1] = batchSql_forPrint.toString();
        return batchExeSql;
    }

    protected void checkClose(Statement stmt, Connection conn) {
        HoneyContext.checkClose(stmt, conn);
    }

    protected void checkClose(ResultSet rs, Statement stmt, Connection conn) {
        HoneyContext.checkClose(rs, stmt, conn);
    }

    protected void closeConn(Connection conn) {
        HoneyContext.closeConn(conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> moreTableSelect(String sql, T entity) {
        if (sql == null) return Collections.emptyList();
        if ("".equals(sql.trim())) {
            return Collections.emptyList();
        }
        boolean isReg = this.updateInfoInCache(sql, "List<T>", SuidType.SELECT);
        if (isReg) {
            Object cacheObj = this.cache.get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                List list = (List)cacheObj;
                this.logSelectRows(list.size());
                return list;
            }
            this.initRoute(SuidType.SELECT, entity.getClass(), sql);
        }
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        Object targetObj = null;
        ArrayList rsList = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            rsList = new ArrayList();
            Field[] field = entity.getClass().getDeclaredFields();
            int columnCount = field.length;
            MoreTableStruct[] moreTableStruct = HoneyUtil.getMoreTableStructAndCheckBefore(entity);
            Field[] subField = new Field[2];
            String[] subUseTable = new String[2];
            String[] variableName = new String[2];
            Class[] subEntityFieldClass = new Class[2];
            for (int i = 1; i <= 2; ++i) {
                if (moreTableStruct[i] == null) continue;
                subField[i - 1] = moreTableStruct[i].subEntityField;
                variableName[i - 1] = subField[i - 1].getName();
                subEntityFieldClass[i - 1] = subField[i - 1].getType();
                subUseTable[i - 1] = moreTableStruct[i].useSubTableName;
            }
            Field[] fields1 = subEntityFieldClass[0].getDeclaredFields();
            Field[] fields2 = null;
            if (subField[1] != null) {
                fields2 = subEntityFieldClass[1].getDeclaredFields();
            }
            Map<String, String> dulSubFieldMap = moreTableStruct[0].subDulFieldMap;
            String tableName = moreTableStruct[0].tableName;
            while (true) {
                String columnName;
                String dulField;
                boolean isDul;
                Object subObj1;
                if (rs.next()) {
                    subObj1 = subEntityFieldClass[0].newInstance();
                    isDul = false;
                    dulField = "";
                } else {
                    this.addInCache(sql, rsList, "List<T>", SuidType.SELECT, rsList.size());
                    this.clearContext(sql);
                    if (hasException) {
                        this.checkClose(rs, pst, null);
                        this.closeConn(conn);
                    } else {
                        this.checkClose(rs, pst, conn);
                    }
                    entity = null;
                    targetObj = null;
                    this.logSelectRows(rsList.size());
                    return rsList;
                }
                for (int i = 0; i < fields1.length; ++i) {
                    if (HoneyUtil.isSkipField(fields1[i])) continue;
                    fields1[i].setAccessible(true);
                    isDul = false;
                    dulField = "";
                    try {
                        columnName = SqlLib._toColumnName(fields1[i].getName());
                        if (this.isConfuseDuplicateFieldDB()) {
                            dulField = dulSubFieldMap.get(subUseTable[0] + "." + columnName);
                            if (dulField != null) {
                                isDul = true;
                                fields1[i].set(subObj1, rs.getObject(dulField));
                                continue;
                            }
                            fields1[i].set(subObj1, rs.getObject(columnName));
                            continue;
                        }
                        fields1[i].set(subObj1, rs.getObject(subUseTable[0] + "." + columnName));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        if (this.isConfuseDuplicateFieldDB()) {
                            fields1[i].set(subObj1, this._getObjectForMoreTable_ConfuseField(rs, fields1[i], isDul, dulField));
                            continue;
                        }
                        fields1[i].set(subObj1, this._getObjectForMoreTable(rs, subUseTable[0], fields1[i]));
                        continue;
                    }
                    catch (SQLException e) {
                        fields1[i].set(subObj1, null);
                    }
                }
                Object subObj2 = null;
                if (subField[1] != null) {
                    subObj2 = subEntityFieldClass[1].newInstance();
                    columnName = "";
                    for (int i = 0; i < fields2.length; ++i) {
                        if (HoneyUtil.isSkipField(fields2[i])) continue;
                        fields2[i].setAccessible(true);
                        isDul = false;
                        dulField = "";
                        try {
                            columnName = SqlLib._toColumnName(fields2[i].getName());
                            if (this.isConfuseDuplicateFieldDB()) {
                                dulField = dulSubFieldMap.get(subUseTable[1] + "." + columnName);
                                if (dulField != null) {
                                    isDul = true;
                                    fields2[i].set(subObj2, rs.getObject(dulField));
                                    continue;
                                }
                                fields2[i].set(subObj2, rs.getObject(columnName));
                                continue;
                            }
                            fields2[i].set(subObj2, rs.getObject(subUseTable[1] + "." + columnName));
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            if (this.isConfuseDuplicateFieldDB()) {
                                fields2[i].set(subObj2, this._getObjectForMoreTable_ConfuseField(rs, fields2[i], isDul, dulField));
                                continue;
                            }
                            fields2[i].set(subObj2, this._getObjectForMoreTable(rs, subUseTable[1], fields2[i]));
                            continue;
                        }
                        catch (SQLException e) {
                            fields2[i].set(subObj2, null);
                        }
                    }
                }
                targetObj = entity.getClass().newInstance();
                for (int i = 0; i < columnCount; ++i) {
                    if (HoneyUtil.isSkipFieldForMoreTable(field[i])) continue;
                    if (field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) {
                        field[i].setAccessible(true);
                        if (field[i].getName().equals(variableName[0])) {
                            field[i].set(targetObj, subObj1);
                            continue;
                        }
                        if (subField[1] == null || !field[i].getName().equals(variableName[1])) continue;
                        field[i].set(targetObj, subObj2);
                        continue;
                    }
                    field[i].setAccessible(true);
                    try {
                        if (this.isConfuseDuplicateFieldDB()) {
                            field[i].set(targetObj, rs.getObject(SqlLib._toColumnName(field[i].getName())));
                            continue;
                        }
                        field[i].set(targetObj, rs.getObject(tableName + "." + SqlLib._toColumnName(field[i].getName())));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        field[i].set(targetObj, this._getObjectForMoreTable(rs, tableName, field[i]));
                        continue;
                    }
                    catch (SQLException e) {
                        field[i].set(targetObj, null);
                    }
                }
                rsList.add(targetObj);
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    hasException = true;
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    hasException = true;
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                this.clearContext(sql);
                if (hasException) {
                    this.checkClose(rs, pst, null);
                    this.closeConn(conn);
                    throw throwable;
                }
                this.checkClose(rs, pst, conn);
                throw throwable;
            }
        }
    }

    private void setPreparedValues(PreparedStatement pst, String sql) throws SQLException {
        List<PreparedValue> list = HoneyContext.justGetPreparedValue(sql);
        if (null != list && list.size() > 0) {
            this._setPreparedValues(pst, list);
        }
    }

    private void setAndClearPreparedValues(PreparedStatement pst, String sql) throws SQLException {
        List<PreparedValue> list = HoneyContext.getAndClearPreparedValue(sql);
        if (null != list && list.size() > 0) {
            this._setPreparedValues(pst, list);
        }
    }

    private void _setPreparedValues(PreparedStatement pst, List<PreparedValue> list) throws SQLException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            int k = HoneyUtil.getJavaTypeIndex(list.get(i).getType());
            HoneyUtil.setPreparedValues(pst, k, i, list.get(i).getValue());
        }
    }

    private Object _getObjectForMoreTable(ResultSet rs, String tableName, Field field) throws SQLException {
        if (this.isConfuseDuplicateFieldDB()) {
            return HoneyUtil.getResultObject(rs, field.getType().getName(), SqlLib._toColumnName(field.getName()));
        }
        return HoneyUtil.getResultObject(rs, field.getType().getName(), tableName + "." + SqlLib._toColumnName(field.getName()));
    }

    private Object _getObjectForMoreTable_ConfuseField(ResultSet rs, Field field, boolean isDul, String otherName) throws SQLException {
        if (isDul) {
            return HoneyUtil.getResultObject(rs, field.getType().getName(), otherName);
        }
        return HoneyUtil.getResultObject(rs, field.getType().getName(), SqlLib._toColumnName(field.getName()));
    }

    private Object _getObjectByindex(ResultSet rs, Field field, int index) throws SQLException {
        return HoneyUtil.getResultObjectByIndex(rs, field.getType().getName(), index);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static String _toFieldName(String columnName) {
        return NameTranslateHandle.toFieldName(columnName);
    }

    private void addInCache(String sql, Object rs, String returnType, SuidType suidType, int resultSetSize) {
        if (resultSetSize > this.cacheWorkResultSetSize) {
            HoneyContext.deleteCacheInfo(sql);
            return;
        }
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            this.cache.add(sql, rs);
        }
    }

    private boolean updateInfoInCache(String sql, String returnType, SuidType suidType) {
        return HoneyContext.updateInfoInCache(sql, returnType, suidType);
    }

    private void clearInCache(String sql, String returnType, SuidType suidType, int affectRow) {
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            struct.setReturnType(returnType);
            struct.setSuidType(suidType.getType());
            HoneyContext.setCacheInfo(sql, struct);
        }
        this.clearContext(sql);
        if (affectRow > 0) {
            this.cache.clear(sql);
        }
    }

    private void clearContext(String sql) {
        HoneyContext.clearPreparedValue(sql);
        if (HoneyContext.isNeedRealTimeDb() && HoneyContext.isAlreadySetRoute()) {
            HoneyContext.removeCurrentRoute();
        }
    }

    private void initRoute(SuidType suidType, Class clazz, String sql) {
        boolean enableMultiDs = HoneyConfig.getHoneyConfig().multiDS_enable;
        if (!enableMultiDs) {
            return;
        }
        if (HoneyContext.isNeedRealTimeDb() && HoneyContext.isAlreadySetRoute()) {
            return;
        }
        HoneyContext.initRoute(suidType, clazz, sql);
    }

    private boolean isConfuseDuplicateFieldDB() {
        return HoneyUtil.isConfuseDuplicateFieldDB();
    }

    private void logSelectRows(int size) {
        Logger.logSQL(" | <--  select rows: ", size + "");
    }
}

