/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.JoinType;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.ConditionHelper;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreTableStruct;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.util.StringUtils;

public class _MoreObjectToSQLHelper {
    private static final String COMMA = ",";
    private static final String ONE_SPACE = " ";
    private static final String DOT = ".";

    private static DbFeature getDbFeature() {
        return BeeFactory.getHoneyFactory().getDbFeature();
    }

    static <T> String _toSelectSQL(T entity) {
        return _MoreObjectToSQLHelper._toSelectSQL(entity, -1, null, -1, -1);
    }

    static <T> String _toSelectSQL(T entity, int start, int size) {
        return _MoreObjectToSQLHelper._toSelectSQL(entity, -1, null, start, size);
    }

    static <T> String _toSelectSQL(T entity, Condition condition) {
        int includeType = condition == null || condition.getIncludeType() == null ? -1 : condition.getIncludeType().getValue();
        return _MoreObjectToSQLHelper._toSelectSQL(entity, includeType, condition, -1, -1);
    }

    private static <T> String _toSelectSQL(T entity, int includeType, Condition condition, int start, int size) {
        _MoreObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        Set whereFields = null;
        if (condition != null) {
            whereFields = condition.getWhereFields();
        }
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer sqlBuffer2 = new StringBuffer();
        try {
            MoreTableStruct[] moreTableStruct;
            Field[] fields = entity.getClass().getDeclaredFields();
            String tableName = _MoreObjectToSQLHelper._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_MoreStruct_to_SqlLib");
            if (HoneyContext.isNeedRealTimeDb()) {
                HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
                OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
            }
            if ((moreTableStruct = HoneyUtil.getMoreTableStructAndCheckBefore(entity))[1] == null) {
                throw new BeeErrorGrammarException("MoreObject select on " + entity.getClass().getName() + " must own at least one JoinTable annotation!");
            }
            boolean twoTablesWithJoinOnStyle = HoneyConfig.getHoneyConfig().moreTable_twoTablesWithJoinOnStyle;
            boolean moreTable_columnListWithStar = HoneyConfig.getHoneyConfig().moreTable_columnListWithStar;
            String columnNames = moreTableStruct[0].columnsFull;
            if (condition != null) {
                condition.setSuidType(SuidType.SELECT);
                String selectField = ConditionHelper.processSelectField(columnNames, condition, moreTableStruct[0].subDulFieldMap);
                String fun = ConditionHelper.processFunction(columnNames, condition);
                if (selectField != null && StringUtils.isEmpty(fun)) {
                    columnNames = selectField;
                } else if (selectField != null && StringUtils.isNotEmpty(fun)) {
                    columnNames = selectField + COMMA + fun;
                } else if (selectField == null && StringUtils.isNotEmpty(fun)) {
                    columnNames = fun;
                } else if (moreTable_columnListWithStar) {
                    columnNames = "*";
                }
            } else if (moreTable_columnListWithStar) {
                columnNames = "*";
            }
            String tableNamesForCache = tableName;
            sqlBuffer.append(K.select).append(ONE_SPACE).append(columnNames).append(ONE_SPACE).append(K.from).append(ONE_SPACE);
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            String[] useSubTableNames = new String[2];
            if (moreTableStruct[0].joinTableNum > 1 && twoTablesWithJoinOnStyle && moreTableStruct[1].joinType == JoinType.JOIN) {
                Logger.warn("SQL grammar type will use 'where ... =' replace 'join .. on' !");
            }
            if ((moreTableStruct[1].joinType != JoinType.JOIN || twoTablesWithJoinOnStyle && moreTableStruct[0].joinTableNum == 1) && moreTableStruct[1].joinExpression != null && !"".equals(moreTableStruct[1].joinExpression)) {
                if (moreTableStruct[1].joinType == JoinType.FULL_JOIN) {
                    Logger.warn("Pleae confirm the Database supports 'full join' type!");
                }
                if (HoneyUtil.isSqlKeyWordUpper()) {
                    sqlBuffer.append(moreTableStruct[1].joinType.getType().toUpperCase());
                } else {
                    sqlBuffer.append(moreTableStruct[1].joinType.getType());
                }
                sqlBuffer.append(moreTableStruct[1].tableName);
                tableNamesForCache = tableNamesForCache + "##" + moreTableStruct[1].tableName;
                if (moreTableStruct[1].hasSubAlias) {
                    sqlBuffer.append(ONE_SPACE);
                    sqlBuffer.append(moreTableStruct[1].subAlias);
                }
                sqlBuffer.append(ONE_SPACE);
                sqlBuffer.append(K.on);
                sqlBuffer.append(ONE_SPACE);
                sqlBuffer.append(moreTableStruct[1].joinExpression);
            } else {
                for (int s = 1; s <= 2; ++s) {
                    if (moreTableStruct[s] == null) continue;
                    useSubTableNames[s - 1] = moreTableStruct[s].useSubTableName;
                    sqlBuffer.append(COMMA);
                    sqlBuffer.append(moreTableStruct[s].tableName);
                    tableNamesForCache = tableNamesForCache + "##" + moreTableStruct[s].tableName;
                    if (moreTableStruct[s].hasSubAlias) {
                        sqlBuffer.append(ONE_SPACE);
                        sqlBuffer.append(moreTableStruct[s].subAlias);
                    }
                    if (moreTableStruct[s].joinExpression == null || "".equals(moreTableStruct[s].joinExpression)) continue;
                    if (firstWhere) {
                        sqlBuffer2.append(ONE_SPACE).append(K.where).append(ONE_SPACE);
                        firstWhere = false;
                    } else {
                        sqlBuffer2.append(ONE_SPACE).append(K.and).append(ONE_SPACE);
                    }
                    sqlBuffer2.append(moreTableStruct[s].joinExpression);
                }
            }
            int len = fields.length;
            int k = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName())) continue;
                if (firstWhere) {
                    sqlBuffer2.append(ONE_SPACE).append(K.where).append(ONE_SPACE);
                    firstWhere = false;
                } else {
                    sqlBuffer2.append(ONE_SPACE).append(K.and).append(ONE_SPACE);
                }
                sqlBuffer2.append(tableName);
                sqlBuffer2.append(DOT);
                sqlBuffer2.append(_MoreObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer2.append(ONE_SPACE).append(K.isNull);
                    continue;
                }
                sqlBuffer2.append("=");
                sqlBuffer2.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
            }
            sqlBuffer.append(sqlBuffer2);
            for (int index = 1; index <= 2; ++index) {
                if (moreTableStruct[index] == null) continue;
                firstWhere = _MoreObjectToSQLHelper.parseSubObject(sqlBuffer, list, whereFields, firstWhere, includeType, moreTableStruct, index);
            }
            if (HoneyContext.isNeedRealTimeDb()) {
                HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
                OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
            }
            if (condition != null) {
                condition.setSuidType(SuidType.SELECT);
                ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere, useSubTableNames);
            }
            if (start != -1 && size != -1) {
                HoneyUtil.regPagePlaceholder();
                sql = _MoreObjectToSQLHelper.getDbFeature().toPageSql(sqlBuffer.toString(), start, size);
                HoneyUtil.setPageNum(list);
            } else {
                sql = sqlBuffer.toString();
            }
            HoneyContext.setPreparedValue(sql, list);
            _MoreObjectToSQLHelper.addInContextForCache(sql, tableNamesForCache);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    private static boolean parseSubObject(StringBuffer sqlBuffer2, List<PreparedValue> list, Set<String> conditionFieldSet, boolean firstWhere, int includeType, MoreTableStruct[] moreTableStruct, int index) {
        Object entity = moreTableStruct[index].subObject;
        if (entity == null) {
            return firstWhere;
        }
        PreparedValue preparedValue = null;
        String useSubTableName = moreTableStruct[index].useSubTableName;
        Field[] fields = moreTableStruct[index].subEntityField.getType().getDeclaredFields();
        int len = fields.length;
        try {
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName())) continue;
                if (firstWhere) {
                    sqlBuffer2.append(ONE_SPACE).append(K.where).append(ONE_SPACE);
                    firstWhere = false;
                } else {
                    sqlBuffer2.append(ONE_SPACE).append(K.and).append(ONE_SPACE);
                }
                sqlBuffer2.append(useSubTableName);
                sqlBuffer2.append(DOT);
                sqlBuffer2.append(_MoreObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer2.append(ONE_SPACE).append(K.isNull);
                    continue;
                }
                sqlBuffer2.append("=");
                sqlBuffer2.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(preparedValue);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return firstWhere;
    }

    static void addInContextForCache(String sql, String tableName) {
        CacheSuidStruct struct = new CacheSuidStruct();
        struct.setSql(sql);
        struct.setTableNames(tableName);
        HoneyContext.setCacheInfo(sql, struct);
    }

    private static <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }
}

