/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.util.ObjectCreatorFactory;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.StringUtils;

public class SuidHelper {
    public static String parseFirstColumn(List<String[]> list) {
        if (list == null) {
            return "";
        }
        String str = "";
        for (int i = 0; i < list.size(); ++i) {
            str = str + list.get(i)[0];
            if (i == list.size() - 1) continue;
            str = str + ",";
        }
        return str;
    }

    public static <T> List<T> parseToEntity(List<String[]> list, int startRow, String fieldNames, T entity) {
        if (StringUtils.isBlank(fieldNames)) {
            return Collections.emptyList();
        }
        String[] fieldName = fieldNames.split(",");
        return SuidHelper.parseToEntity(list, startRow, fieldName, entity);
    }

    public static <T> List<T> parseToEntity(List<String[]> list, int startRow, int endRow, String fieldNames, T entity) {
        if (StringUtils.isBlank(fieldNames)) {
            return Collections.emptyList();
        }
        String[] fieldName = fieldNames.split(",");
        return SuidHelper.parseToEntity(list, startRow, endRow, fieldName, entity);
    }

    public static <T> List<T> parseToEntity(List<String[]> list, int startRow, String[] fieldName, T entity) {
        if (ObjectUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return SuidHelper.parseToEntity(list, startRow, list.size() - 1, fieldName, entity);
    }

    public static <T> List<T> parseToEntity(List<String[]> list, int startRow, int endRow, String[] fieldName, T entity) {
        Object targetObj = null;
        ArrayList<Object> rsList = null;
        Field field = null;
        String[] col = null;
        if (ObjectUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        rsList = new ArrayList<Object>();
        if (startRow < 0) {
            startRow = 0;
        }
        if (endRow > list.size() - 1) {
            endRow = list.size() - 1;
        }
        try {
            for (int i = startRow; i <= endRow; ++i) {
                col = list.get(i);
                if (col == null || col.length == 1 && fieldName.length != 1) continue;
                targetObj = entity.getClass().newInstance();
                for (int j = 0; j < fieldName.length; ++j) {
                    if (StringUtils.isBlank(fieldName[j])) continue;
                    try {
                        field = entity.getClass().getDeclaredField(fieldName[j]);
                    }
                    catch (NoSuchFieldException e) {
                        if (i != startRow) continue;
                        Logger.warn("Can not find the field name : " + fieldName[j]);
                        continue;
                    }
                    field.setAccessible(true);
                    try {
                        field.set(targetObj, ObjectCreatorFactory.create(col[j], field.getType()));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Logger.error(e.getMessage());
                    }
                }
                rsList.add(targetObj);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        catch (InstantiationException e) {
            throw ExceptionHelper.convert(e);
        }
        finally {
            entity = null;
            targetObj = null;
        }
        return rsList;
    }
}

