/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.chain;

import org.teasoft.bee.osql.FunctionType;
import org.teasoft.honey.osql.core.FunAndOrderTypeMap;
import org.teasoft.honey.osql.util.NameCheckUtil;

public class Aggregate {
    private static String L_PARENTHESES = "(";
    private static String R_PARENTHESES = ")";

    public static String selectWithFun(FunctionType functionType, String fieldForFun) {
        Aggregate.checkField(fieldForFun);
        return FunAndOrderTypeMap.transfer(functionType.getName()) + L_PARENTHESES + fieldForFun + R_PARENTHESES;
    }

    public static String max(String field) {
        return Aggregate.selectWithFun(FunctionType.MAX, field);
    }

    public static String min(String field) {
        return Aggregate.selectWithFun(FunctionType.MIN, field);
    }

    public static String sum(String field) {
        return Aggregate.selectWithFun(FunctionType.SUM, field);
    }

    public static String avg(String field) {
        return Aggregate.selectWithFun(FunctionType.AVG, field);
    }

    public static String count(String field) {
        return Aggregate.selectWithFun(FunctionType.COUNT, field);
    }

    private static void checkField(String field) {
        NameCheckUtil.checkName(field);
    }
}

