/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import org.teasoft.honey.osql.core.HoneyConfig;

public class CacheArrayIndex {
    private int low;
    private int high;
    private int know;
    private static int size;
    private static int startDeleteCacheRate;
    private static int fullUsedRate;
    private static int fullClearCacheSize;

    public synchronized int getLow() {
        return this.low;
    }

    public synchronized void setLow(int low) {
        this.low = low;
    }

    public int getHigh() {
        return this.high;
    }

    public int getKnow() {
        return this.know;
    }

    public int getUsedSize() {
        int t = this.getHigh() - this.getLow();
        if (t >= 0) {
            return t;
        }
        return t + size;
    }

    public int getEmptySize() {
        return size - this.getUsedSize();
    }

    public int getUsedRate() {
        return this.getUsedSize() * 100 / size;
    }

    public synchronized int getNext() {
        if (this.high >= size) {
            this.high = 1;
            return 0;
        }
        return this.high++;
    }

    public boolean isFull() {
        return this.getEmptySize() == 0;
    }

    public boolean isWouldbeFull() {
        return this.getUsedRate() > fullUsedRate;
    }

    public int getDeleteCacheIndex() {
        return (this.getLow() + fullClearCacheSize) % size;
    }

    public boolean isStartDelete() {
        return this.getUsedRate() > startDeleteCacheRate;
    }

    static {
        startDeleteCacheRate = (int)(HoneyConfig.getHoneyConfig().cache_startDeleteRate * 100.0);
        fullUsedRate = (int)(HoneyConfig.getHoneyConfig().cache_fullUsedRate * 100.0);
        size = HoneyConfig.getHoneyConfig().cache_mapSize;
        fullClearCacheSize = (int)(HoneyConfig.getHoneyConfig().cache_fullClearRate * (double)size);
    }
}

