/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Cache;
import org.teasoft.bee.osql.CallableSql;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.MapSql;
import org.teasoft.bee.osql.MapSuid;
import org.teasoft.bee.osql.MoreObjToSQL;
import org.teasoft.bee.osql.MoreTable;
import org.teasoft.bee.osql.NameTranslate;
import org.teasoft.bee.osql.ObjToSQL;
import org.teasoft.bee.osql.ObjToSQLRich;
import org.teasoft.bee.osql.PreparedSql;
import org.teasoft.bee.osql.Suid;
import org.teasoft.bee.osql.SuidRich;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.NoConfigException;
import org.teasoft.honey.osql.core.CallableSqlLib;
import org.teasoft.honey.osql.core.ConditionImpl;
import org.teasoft.honey.osql.core.DefaultCache;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.MapSqlImpl;
import org.teasoft.honey.osql.core.MapSuidImpl;
import org.teasoft.honey.osql.core.MoreObjSQL;
import org.teasoft.honey.osql.core.MoreObjectToSQL;
import org.teasoft.honey.osql.core.NoCache;
import org.teasoft.honey.osql.core.ObjSQL;
import org.teasoft.honey.osql.core.ObjSQLRich;
import org.teasoft.honey.osql.core.ObjectToSQL;
import org.teasoft.honey.osql.core.ObjectToSQLRich;
import org.teasoft.honey.osql.core.PreparedSqlLib;
import org.teasoft.honey.osql.core.SqlLib;
import org.teasoft.honey.osql.dialect.LimitOffsetPaging;
import org.teasoft.honey.osql.dialect.NoPagingSupported;
import org.teasoft.honey.osql.dialect.mysql.MySqlFeature;
import org.teasoft.honey.osql.dialect.oracle.OracleFeature;
import org.teasoft.honey.osql.dialect.sqlserver.SqlServerFeature;
import org.teasoft.honey.osql.name.OriginalName;
import org.teasoft.honey.osql.name.UnderScoreAndCamelName;
import org.teasoft.honey.osql.name.UpperCaseUnderScoreAndCamelName;

public class HoneyFactory {
    private Suid suid;
    private SuidRich suidRich;
    private BeeSql beeSql;
    private ObjToSQL objToSQL;
    private ObjToSQLRich objToSQLRich;
    private PreparedSql preparedSql;
    private CallableSql callableSql;
    private Condition condition;
    private MoreTable moreTable;
    private MoreObjToSQL moreObjToSQL;
    private MapSql mapSql;
    private MapSuid mapSuid;
    private DbFeature dbFeature;
    private NameTranslate nameTranslate;
    private static Cache cache;

    public Suid getSuid() {
        if (this.suid == null) {
            return new ObjSQL();
        }
        return this.suid;
    }

    public void setSuid(Suid suid) {
        this.suid = suid;
    }

    public SuidRich getSuidRich() {
        if (this.suidRich == null) {
            return new ObjSQLRich();
        }
        return this.suidRich;
    }

    public void setSuidRich(SuidRich suidRich) {
        this.suidRich = suidRich;
    }

    public MoreTable getMoreTable() {
        if (this.moreTable == null) {
            return new MoreObjSQL();
        }
        return this.moreTable;
    }

    public void setMoreTable(MoreTable moreTable) {
        this.moreTable = moreTable;
    }

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            return new SqlLib();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public ObjToSQL getObjToSQL() {
        if (this.objToSQL == null) {
            return new ObjectToSQL();
        }
        return this.objToSQL;
    }

    public void setObjToSQL(ObjToSQL objToSQL) {
        this.objToSQL = objToSQL;
    }

    public ObjToSQLRich getObjToSQLRich() {
        if (this.objToSQLRich == null) {
            return new ObjectToSQLRich();
        }
        return this.objToSQLRich;
    }

    public void setObjToSQLRich(ObjToSQLRich objToSQLRich) {
        this.objToSQLRich = objToSQLRich;
    }

    public MoreObjToSQL getMoreObjToSQL() {
        if (this.moreObjToSQL == null) {
            return new MoreObjectToSQL();
        }
        return this.moreObjToSQL;
    }

    public void setMoreObjToSQL(MoreObjToSQL moreObjToSQL) {
        this.moreObjToSQL = moreObjToSQL;
    }

    public PreparedSql getPreparedSql() {
        if (this.preparedSql == null) {
            return new PreparedSqlLib();
        }
        return this.preparedSql;
    }

    public void setPreparedSql(PreparedSql preparedSql) {
        this.preparedSql = preparedSql;
    }

    public CallableSql getCallableSql() {
        if (this.callableSql == null) {
            return new CallableSqlLib();
        }
        return this.callableSql;
    }

    public void setCallableSql(CallableSql callableSql) {
        this.callableSql = callableSql;
    }

    public Condition getCondition() {
        if (this.condition == null) {
            return new ConditionImpl();
        }
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public MapSql getMapSql() {
        if (this.mapSql == null) {
            return new MapSqlImpl();
        }
        return this.mapSql;
    }

    public void setMapSql(MapSql mapSql) {
        this.mapSql = mapSql;
    }

    public MapSuid getMapSuid() {
        if (this.mapSuid == null) {
            return new MapSuidImpl();
        }
        return this.mapSuid;
    }

    public void setMapSuid(MapSuid mapSuid) {
        this.mapSuid = mapSuid;
    }

    public Cache getCache() {
        if (cache == null) {
            boolean nocache = HoneyConfig.getHoneyConfig().cache_nocache;
            if (nocache) {
                return new NoCache();
            }
            return new DefaultCache();
        }
        return cache;
    }

    public DbFeature getDbFeature() {
        String dbName = HoneyContext.getRealTimeDbName();
        if (dbName != null) {
            return this._getDbDialectFeature(dbName);
        }
        if (this.dbFeature != null) {
            return this.dbFeature;
        }
        return this._getDbDialectFeature();
    }

    public void setDbFeature(DbFeature dbFeature) {
        this.dbFeature = dbFeature;
    }

    NameTranslate getInitNameTranslate() {
        if (this.nameTranslate == null) {
            int translateType = HoneyConfig.getHoneyConfig().naming_translateType;
            this.nameTranslate = translateType == 1 ? new UnderScoreAndCamelName() : (translateType == 2 ? new UpperCaseUnderScoreAndCamelName() : (translateType == 3 ? new OriginalName() : new UnderScoreAndCamelName()));
            return this.nameTranslate;
        }
        return this.nameTranslate;
    }

    DbFeature _getDbDialectFeature() {
        return this._getDbDialectFeature(HoneyContext.getDbDialect());
    }

    private DbFeature _getDbDialectFeature(String dbName) {
        if ("MySQL".equalsIgnoreCase(dbName) || "MariaDB".equalsIgnoreCase(dbName)) {
            return new MySqlFeature();
        }
        if ("Oracle".equalsIgnoreCase(dbName)) {
            return new OracleFeature();
        }
        if ("Microsoft SQL Server".equalsIgnoreCase(dbName)) {
            return new SqlServerFeature();
        }
        if (this._isLimitOffsetDB()) {
            return new LimitOffsetPaging();
        }
        if (dbName != null) {
            return new NoPagingSupported();
        }
        throw new NoConfigException("Error: Do not set the DbFeature implements class or do not set the database name. ");
    }

    private boolean _isLimitOffsetDB() {
        return "H2".equalsIgnoreCase(HoneyContext.getDbDialect()) || "SQLite".equalsIgnoreCase(HoneyContext.getDbDialect()) || "PostgreSQL".equalsIgnoreCase(HoneyContext.getDbDialect());
    }

    static {
        boolean nocache = HoneyConfig.getHoneyConfig().cache_nocache;
        cache = nocache ? new NoCache() : new DefaultCache();
    }
}

