/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.IncludeType;
import org.teasoft.bee.osql.MapSql;
import org.teasoft.bee.osql.MapSqlKey;
import org.teasoft.bee.osql.MapSqlSetting;
import org.teasoft.bee.osql.MapSuid;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.ObjToSQLRich;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.SuidRich;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.BeeFactoryHelper;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.ObjSQL;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.util.SuidHelper;

public class ObjSQLRich
extends ObjSQL
implements SuidRich {
    private ObjToSQLRich objToSQLRich;

    public ObjToSQLRich getObjToSQLRich() {
        if (this.objToSQLRich == null) {
            this.objToSQLRich = BeeFactory.getHoneyFactory().getObjToSQLRich();
        }
        return this.objToSQLRich;
    }

    public void setObjToSQLRich(ObjToSQLRich objToSQLRich) {
        this.objToSQLRich = objToSQLRich;
    }

    public <T> List<T> select(T entity, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, size);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> select(T entity, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, start, size);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> select(T entity, String selectField) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectField);
        list = this.getBeeSql().selectSomeField(sql, entity);
        return list;
    }

    public <T> List<T> select(T entity, String selectFields, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectFields, start, size);
        list = this.getBeeSql().selectSomeField(sql, entity);
        return list;
    }

    public <T> List<T> selectOrderBy(T entity, String orderFields) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.getObjToSQLRich().toSelectOrderBySQL(entity, orderFields);
        Logger.logSQL("selectOrderBy SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        return list;
    }

    public <T> List<T> selectOrderBy(T entity, String orderFields, OrderType[] orderTypes) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.getObjToSQLRich().toSelectOrderBySQL(entity, orderFields, orderTypes);
        Logger.logSQL("selectOrderBy SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        return list;
    }

    public <T> int insert(T[] entity) {
        if (entity == null || entity.length < 1) {
            return -1;
        }
        this.checkNull(entity);
        String[] insertSql = this.getObjToSQLRich().toInsertSQL((Object[])entity);
        this._regEntityClass1(entity[0]);
        HoneyUtil.revertId(entity);
        return this.getBeeSql().batch(insertSql);
    }

    private <T> void checkNull(T[] entity) {
        for (int i = 0; i < entity.length; ++i) {
            if (entity[i] != null) continue;
            throw new ObjSQLException("entity[] have null element, index: " + i);
        }
    }

    public <T> int insert(T[] entity, String excludeFields) {
        if (entity == null || entity.length < 1) {
            return -1;
        }
        this.checkNull(entity);
        String[] insertSql = this.getObjToSQLRich().toInsertSQL((Object[])entity, excludeFields);
        this._regEntityClass1(entity[0]);
        HoneyUtil.revertId(entity);
        return this.getBeeSql().batch(insertSql);
    }

    public <T> int insert(T[] entity, int batchSize) {
        return this.insert(entity, batchSize, "");
    }

    public <T> int insert(T[] entity, int batchSize, String excludeFields) {
        if (entity == null || entity.length < 1) {
            return -1;
        }
        this.checkNull(entity);
        if (batchSize <= 0) {
            batchSize = 10;
        }
        String[] insertSql = this.getObjToSQLRich().toInsertSQL((Object[])entity, batchSize, excludeFields);
        this._regEntityClass1(entity[0]);
        HoneyUtil.revertId(entity);
        return this.getBeeSql().batch(insertSql, batchSize);
    }

    public <T> int update(T entity, String updateFields) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, updateFields);
        Logger.logSQL("update SQL(updateFields) :", sql);
        this._regEntityClass1(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> T selectOne(T entity) {
        if (entity == null) {
            return null;
        }
        List<T> list = this.select(entity);
        if (list == null || list.size() != 1) {
            return null;
        }
        return list.get(0);
    }

    public <T> String selectWithFun(T entity, FunctionType functionType, String fieldForFun) {
        return this.selectWithFun(entity, functionType, fieldForFun, null);
    }

    public <T> String selectWithFun(T entity, FunctionType functionType, String fieldForFun, Condition condition) {
        if (entity == null) {
            return null;
        }
        String s = null;
        String sql = this.getObjToSQLRich().toSelectFunSQL(entity, functionType, fieldForFun, condition);
        this._regEntityClass1(entity);
        s = this.getBeeSql().selectFun(sql);
        return s;
    }

    public <T> int count(T entity) {
        return this.count(entity, null);
    }

    public <T> int count(T entity, Condition condition) {
        String total = this.selectWithFun(entity, FunctionType.COUNT, "*", condition);
        return total == null ? 0 : Integer.parseInt(total);
    }

    public <T> int update(T entity, String updateFields, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, updateFields, includeType);
        Logger.logSQL("update SQL(updateFields) :", sql);
        this._regEntityClass1(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> List<T> select(T entity, IncludeType includeType) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType);
        Logger.logSQL("select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> int update(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, includeType);
        Logger.logSQL("update SQL: ", sql);
        this._regEntityClass1(entity);
        return this.getBeeSql().modify(sql);
    }

    public <T> int insert(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        String sql = this.getObjToSQLRich().toInsertSQL(entity, includeType);
        Logger.logSQL("insert SQL: ", sql);
        this._regEntityClass1(entity);
        return this.getBeeSql().modify(sql);
    }

    public <T> int delete(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        String sql = this.getObjToSQLRich().toDeleteSQL(entity, includeType);
        Logger.logSQL("delete SQL: ", sql);
        this._regEntityClass1(entity);
        return this.getBeeSql().modify(sql);
    }

    public <T> List<String[]> selectString(T entity) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity);
        Logger.logSQL("List<String[]> select SQL: ", sql);
        this._regEntityClass1(entity);
        list = this.getBeeSql().select(sql);
        return list;
    }

    public <T> List<String[]> selectString(T entity, String selectFields) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectFields);
        this._regEntityClass1(entity);
        list = this.getBeeSql().select(sql);
        return list;
    }

    public <T> List<String[]> selectString(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, condition.getIncludeType(), condition);
        Logger.logSQL("select SQL: ", sql);
        this._regEntityClass1(entity);
        return this.getBeeSql().select(sql);
    }

    public <T> String selectJson(T entity) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity);
        Logger.logSQL("selectJson SQL: ", sql);
        this._regEntityClass1(entity);
        return this.getBeeSql().selectJson(sql);
    }

    public <T> String selectJson(T entity, IncludeType includeType) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType);
        Logger.logSQL("selectJson SQL: ", sql);
        this._regEntityClass1(entity);
        return this.getBeeSql().selectJson(sql);
    }

    public <T> String selectJson(T entity, String selectField) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectField);
        Logger.logSQL("selectJson(T entity, String selectField) SQL: ", sql);
        this._regEntityClass1(entity);
        return this.getBeeSql().selectJson(sql);
    }

    public <T> String selectJson(T entity, String selectFields, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectFields, start, size);
        Logger.logSQL("selectJson(T entity, String selectField, int start, int size) SQL: ", sql);
        this._regEntityClass1(entity);
        return this.getBeeSql().selectJson(sql);
    }

    public <T> T selectById(T entity, Integer id) {
        if (entity == null) {
            return null;
        }
        if (id == null) {
            Logger.warn("in method selectById,id is null! ");
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entity, id);
        Logger.logSQL("selectById SQL: ", sql);
        List list = this.getBeeSql().select(sql, entity);
        return this.getIdEntity(list);
    }

    public <T> T selectById(T entity, Long id) {
        if (entity == null) {
            return null;
        }
        if (id == null) {
            Logger.warn("in method selectById,id is null! ");
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entity, id);
        Logger.logSQL("selectById SQL: ", sql);
        List list = this.getBeeSql().select(sql, entity);
        return this.getIdEntity(list);
    }

    public <T> T selectById(T entity, String id) {
        if (entity == null) {
            return null;
        }
        if (id == null) {
            Logger.warn("in method selectById,id is null! ");
            return null;
        }
        if (id.contains(",")) {
            throw new BeeIllegalParameterException("The parameter 'id' of method selectById does not allow to contain comma!");
        }
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entity, id);
        Logger.logSQL("selectById SQL: ", sql);
        List list = this.getBeeSql().select(sql, entity);
        return this.getIdEntity(list);
    }

    public <T> List<T> selectByIds(T entity, String ids) {
        if (entity == null) {
            return null;
        }
        if (ids == null) {
            Logger.warn("in method selectByIds,ids is null! ");
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entity, ids);
        Logger.logSQL("selectByIds SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    private <T> T getIdEntity(List<T> list) {
        if (list == null || list.size() < 1) {
            return null;
        }
        return list.get(0);
    }

    public int deleteById(Class c, Integer id) {
        if (id == null) {
            Logger.warn("in method deleteById,id is null! ");
        }
        if (c == null || id == null) {
            return 0;
        }
        String sql = this.getObjToSQLRich().toDeleteByIdSQL(c, id);
        Logger.logSQL("deleteById SQL: ", sql);
        this._regEntityClass2(c);
        return this.getBeeSql().modify(sql);
    }

    public int deleteById(Class c, Long id) {
        if (id == null) {
            Logger.warn("in method deleteById,id is null! ");
        }
        if (c == null || id == null) {
            return 0;
        }
        String sql = this.getObjToSQLRich().toDeleteByIdSQL(c, id);
        Logger.logSQL("deleteById SQL: ", sql);
        this._regEntityClass2(c);
        return this.getBeeSql().modify(sql);
    }

    public int deleteById(Class c, String ids) {
        if (ids == null) {
            Logger.warn("in method deleteById,ids is null! ");
        }
        if (c == null || ids == null) {
            return 0;
        }
        String sql = this.getObjToSQLRich().toDeleteByIdSQL(c, ids);
        Logger.logSQL("deleteById SQL: ", sql);
        this._regEntityClass2(c);
        return this.getBeeSql().modify(sql);
    }

    @Deprecated
    public <T> List<T> select(T entity, IncludeType includeType, Condition condition) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType, condition);
        Logger.logSQL("select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> String selectJson(T entity, IncludeType includeType, Condition condition) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType, condition);
        Logger.logSQL("selectJson SQL: ", sql);
        this._regEntityClass1(entity);
        return this.getBeeSql().selectJson(sql);
    }

    public <T> String selectJson(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, condition.getIncludeType(), condition);
        Logger.logSQL("selectJson SQL: ", sql);
        this._regEntityClass1(entity);
        return this.getBeeSql().selectJson(sql);
    }

    public <T> int updateBy(T entity, String whereFields) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateBySQL(entity, whereFields);
        Logger.logSQL("update SQL(whereFields) :", sql);
        this._regEntityClass1(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> int updateBy(T entity, String whereFields, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateBySQL(entity, whereFields, includeType);
        Logger.logSQL("update SQL(whereFields) :", sql);
        this._regEntityClass1(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> int updateBy(T entity, String whereFields, Condition condition) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateBySQL(entity, whereFields, condition);
        Logger.logSQL("update SQL(whereFields) :", sql);
        this._regEntityClass1(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> int updateById(T entity, Condition condition) {
        return this.updateBy(entity, "id", condition);
    }

    public <T> int update(T entity, String updateFields, Condition condition) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, updateFields, condition);
        Logger.logSQL("update SQL(updateFields) :", sql);
        this._regEntityClass1(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> int update(T entity, Condition condition) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, "", condition);
        Logger.logSQL("update SQL(condition) :", sql);
        this._regEntityClass1(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> int insert(List<T> entityList) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity);
    }

    public <T> int insert(List<T> entityList, int batchSize) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity, batchSize);
    }

    public <T> int insert(List<T> entityList, String excludeFields) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity, excludeFields);
    }

    public <T> int insert(List<T> entityList, int batchSize, String excludeFields) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity, batchSize, excludeFields);
    }

    private <T> void _regEntityClass1(T entity) {
        if (entity == null) {
            return;
        }
        HoneyContext.regEntityClass(entity.getClass());
    }

    private void _regEntityClass2(Class clazz) {
        HoneyContext.regEntityClass(clazz);
    }

    private <T> T[] toEntityArray(List<T> entityList) {
        int len = entityList.size();
        Object[] entity = new Object[len];
        for (int i = 0; i < len; ++i) {
            entity[i] = entityList.get(i);
        }
        return entity;
    }

    public SuidRich setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    public <T> boolean exist(T entity) {
        int r = this.count(entity);
        return r > 0;
    }

    public <T> int update(T oldEntity, T newEntity) {
        String newEntityFullName;
        if (oldEntity == null || newEntity == null) {
            return -1;
        }
        String oldEntityFullName = oldEntity.getClass().getName();
        if (!oldEntityFullName.equals(newEntityFullName = newEntity.getClass().getName())) {
            throw new BeeErrorGrammarException("BeeErrorGrammarException: the oldEntity and newEntity must be same type!");
        }
        Map<String, Object> oldMap = SuidHelper.entityToMap(oldEntity);
        Map<String, Object> newMap = SuidHelper.entityToMap(newEntity);
        MapSql updateMapSql = BeeFactoryHelper.getMapSql();
        updateMapSql.put(MapSqlKey.Table, ObjSQLRich._toTableName(oldEntity));
        updateMapSql.put(MapSqlSetting.IsNamingTransfer, true);
        updateMapSql.put(oldMap);
        updateMapSql.putNew(newMap);
        Logger.logSQL("update(T oldEntity, T newEntity) with MapSuid, ", "");
        MapSuid mapSuid = BeeFactoryHelper.getMapSuid();
        return mapSuid.update(updateMapSql);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    public <T> int save(T entity) {
        Object id = HoneyUtil.getIdValue(entity);
        if (id == null) {
            return this.insert(entity);
        }
        T one = this.selectById(entity, id.toString());
        if (one != null) {
            return this.update(entity);
        }
        return this.insert(entity);
    }
}

