/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.IncludeType;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.ObjSQLIllegalSQLStringException;
import org.teasoft.bee.osql.ObjToSQLRich;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.BeeIllegalEntityException;
import org.teasoft.honey.distribution.GenIdFactory;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ConditionHelper;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.FunAndOrderTypeMap;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.ObjectToSQL;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SqlStrFilter;
import org.teasoft.honey.osql.core.SqlValueWrap;
import org.teasoft.honey.osql.core._ObjectToSQLHelper;
import org.teasoft.honey.osql.name.NameUtil;

public class ObjectToSQLRich
extends ObjectToSQL
implements ObjToSQLRich {
    private static final String ASC = K.asc;
    private int batchSize;
    private static final String index1 = "_SYS[index";
    private static final String index2 = "]_End ";
    private static final String index3 = "]";

    public ObjectToSQLRich() {
        this.batchSize = HoneyConfig.getHoneyConfig().insertBatchSize;
    }

    private DbFeature getDbFeature() {
        return BeeFactory.getHoneyFactory().getDbFeature();
    }

    public <T> String toSelectSQL(T entity, int size) {
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = this._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        this.regPagePlaceholder();
        sql = this.getDbFeature().toPageSql(sql, size);
        HoneyUtil.setPageNum(wrap.getList());
        if (this.isNeedRealTimeDb()) {
            ObjectToSQLRich.setContext(sql, wrap.getList(), tableName);
        } else {
            ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        }
        Logger.logSQL("select SQL(entity,size): ", sql);
        return sql;
    }

    private void regPagePlaceholder() {
        HoneyUtil.regPagePlaceholder();
    }

    public <T> String toSelectSQL(T entity, int start, int size) {
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = this._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        this.regPagePlaceholder();
        sql = this.getDbFeature().toPageSql(sql, start, size);
        HoneyUtil.setPageNum(wrap.getList());
        if (this.isNeedRealTimeDb()) {
            ObjectToSQLRich.setContext(sql, wrap.getList(), tableName);
        } else {
            ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        }
        Logger.logSQL("select(entity,start,size) SQL: ", sql);
        return sql;
    }

    public <T> String toSelectSQL(T entity, String selectFields, int start, int size) {
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = this._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        SqlValueWrap wrap = this.toSelectSQL_0(entity, selectFields);
        String sql = wrap.getSql();
        this.regPagePlaceholder();
        sql = this.getDbFeature().toPageSql(sql, start, size);
        HoneyUtil.setPageNum(wrap.getList());
        if (this.isNeedRealTimeDb()) {
            ObjectToSQLRich.setContext(sql, wrap.getList(), tableName);
        } else {
            ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        }
        Logger.logSQL("select(entity,selectFields,start,size) SQL: ", sql);
        return sql;
    }

    public <T> String toSelectSQL(T entity, String fields) {
        String newSelectFields = HoneyUtil.checkAndProcessSelectField(entity, fields);
        String sql = _ObjectToSQLHelper._toSelectSQL(entity, newSelectFields);
        Logger.logSQL("select SQL(selectFields) : ", sql);
        return sql;
    }

    public <T> String toSelectOrderBySQL(T entity, String orderFieldList) {
        String[] orderFields = orderFieldList.split(",");
        int lenA = orderFields.length;
        String orderBy = "";
        for (int i = 0; i < lenA; ++i) {
            orderBy = orderBy + ObjectToSQLRich._toColumnName(orderFields[i]) + " " + ASC;
            if (i >= lenA - 1) continue;
            orderBy = orderBy + ",";
        }
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        sql = sql + " " + K.orderBy + " " + orderBy;
        ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        return sql;
    }

    public <T> String toSelectOrderBySQL(T entity, String orderFieldList, OrderType[] orderTypes) {
        String[] orderFields = orderFieldList.split(",");
        int lenA = orderFields.length;
        if (lenA != orderTypes.length) {
            throw new ObjSQLException("ObjSQLException :The lenth of orderField is not equal orderTypes'.");
        }
        String orderBy = "";
        for (int i = 0; i < lenA; ++i) {
            orderBy = orderBy + ObjectToSQLRich._toColumnName(orderFields[i]) + " " + orderTypes[i].getName();
            if (i >= lenA - 1) continue;
            orderBy = orderBy + ",";
        }
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        sql = sql + " " + K.orderBy + " " + orderBy;
        ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        return sql;
    }

    public <T> String toUpdateSQL(T entity, String updateFieldList) {
        if (updateFieldList == null) {
            return null;
        }
        String sql = "";
        String[] updateFields = updateFieldList.split(",");
        if (updateFields.length == 0 || "".equals(updateFieldList.trim())) {
            throw new ObjSQLException("ObjSQLException:updateFieldList at least include one field.");
        }
        sql = _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, -1);
        return sql;
    }

    public <T> String toUpdateSQL(T entity, String updateFieldList, IncludeType includeType) {
        if (updateFieldList == null) {
            return null;
        }
        String sql = "";
        String[] updateFields = updateFieldList.split(",");
        if (updateFields.length == 0 || "".equals(updateFieldList.trim())) {
            throw new ObjSQLException("ObjSQLException:updateFieldList at least include one field.");
        }
        sql = _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, includeType.getValue());
        return sql;
    }

    public <T> String toSelectFunSQL(T entity, FunctionType functionType, String fieldForFun, Condition condition) {
        return this._toSelectFunSQL(entity, functionType.getName(), fieldForFun, condition);
    }

    private <T> String _toSelectFunSQL(T entity, String funType, String fieldForFun, Condition condition) {
        ObjectToSQLRich.checkPackage(entity);
        if (fieldForFun == null || funType == null) {
            return null;
        }
        boolean isContainField = false;
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = null;
        try {
            String tableName = this._toTableName(entity);
            funType = FunAndOrderTypeMap.transfer(funType);
            String selectAndFun = "count".equalsIgnoreCase(funType) && "*".equals(fieldForFun) ? K.select + " " + K.count + "(*) " + K.from + " " : K.select + " " + funType + "(" + ObjectToSQLRich._toColumnName(fieldForFun) + ") " + K.from + " ";
            sqlBuffer.append(selectAndFun);
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            Field[] fields = entity.getClass().getDeclaredFields();
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            boolean k = false;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (fields[i].getName().equals(fieldForFun) || "count".equalsIgnoreCase(funType) && "*".equals(fieldForFun)) {
                    isContainField = true;
                }
                if (HoneyUtil.isContinue(-1, fields[i].get(entity), fields[i])) continue;
                if (fields[i].getName().equals(fieldForFun)) {
                    isContainField = true;
                }
                if (firstWhere) {
                    sqlBuffer.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" ").append(K.and).append(" ");
                }
                sqlBuffer.append(ObjectToSQLRich._toColumnName(fields[i].getName()));
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(preparedValue);
            }
            if (condition != null) {
                condition.setSuidType(SuidType.SELECT);
                OneTimeParameter.setTrueForKey("_SYS_Bee_Select_Fun");
                ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere);
            }
            sql = sqlBuffer.toString();
            ObjectToSQLRich.setContext(sql, list, tableName);
            if (SqlStrFilter.checkFunSql(sql, funType)) {
                throw new ObjSQLIllegalSQLStringException("ObjSQLIllegalSQLStringException:sql statement with function is illegal. " + sql);
            }
            Logger.logSQL("select fun SQL : ", sql);
            if (!isContainField) {
                throw new ObjSQLException("ObjSQLException:Miss The Field! The entity(" + tableName + ") don't contain the field:" + fieldForFun);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public <T> String toSelectSQL(T entity, IncludeType includeType) {
        return _ObjectToSQLHelper._toSelectSQL(entity, includeType.getValue());
    }

    public <T> String toDeleteSQL(T entity, IncludeType includeType) {
        return _ObjectToSQLHelper._toDeleteSQL(entity, includeType.getValue());
    }

    public <T> String toInsertSQL(T entity, IncludeType includeType) {
        String sql = null;
        try {
            _ObjectToSQLHelper.setInitIdByAuto(entity);
            sql = _ObjectToSQLHelper._toInsertSQL0(entity, includeType.getValue(), "");
            HoneyUtil.revertId(entity);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public <T> String toUpdateSQL(T entity, IncludeType includeType) {
        String sql = "";
        sql = _ObjectToSQLHelper._toUpdateSQL(entity, includeType.getValue());
        return sql;
    }

    public <T> String[] toInsertSQL(T[] entity) {
        return this.toInsertSQL(entity, "");
    }

    public <T> String[] toInsertSQL(T[] entity, String excludeFieldList) {
        return this.toInsertSQL(entity, this.batchSize, excludeFieldList);
    }

    public <T> String[] toInsertSQL(T[] entity, int batchSize, String excludeFieldList) {
        if (HoneyUtil.isMysql()) {
            return this.toInsertSQLForMysql(entity, batchSize, excludeFieldList);
        }
        String[] sql = null;
        try {
            int len = entity.length;
            this.setInitArrayIdByAuto(entity);
            sql = new String[len];
            String t_sql = "";
            sql[0] = t_sql = _ObjectToSQLHelper._toInsertSQL0(entity[0], 2, excludeFieldList);
            for (int i = 0; i < len; ++i) {
                String sql_i = index1 + i + index2 + sql[0];
                if (i == 0) {
                    HoneyContext.setPreparedValue(sql_i, HoneyContext.getAndClearPreparedValue(sql[0]));
                    HoneyContext.deleteCacheInfo(sql[0]);
                    continue;
                }
                _ObjectToSQLHelper._toInsertSQL_for_ValueList(sql_i, entity[i], excludeFieldList);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    private <T> String[] toInsertSQLForMysql(T[] entity, int batchSize, String excludeFieldList) {
        String[] sql = null;
        try {
            int len = entity.length;
            this.setInitArrayIdByAuto(entity);
            sql = new String[len];
            String t_sql = "";
            OneTimeParameter.setTrueForKey("_SYS_Bee_Return_PlaceholderValue");
            sql[0] = t_sql = _ObjectToSQLHelper._toInsertSQL0(entity[0], 2, excludeFieldList);
            ArrayList<PreparedValue> preparedValueList = new ArrayList<PreparedValue>();
            for (int i = 0; i < len; ++i) {
                List<PreparedValue> oneRecoreList;
                String sql_i = index1 + i + index2 + sql[0];
                if (i == 0) {
                    oneRecoreList = HoneyContext.getAndClearPreparedValue(sql[0]);
                    HoneyContext.setPreparedValue(sql_i, oneRecoreList);
                    HoneyContext.deleteCacheInfo(sql[0]);
                } else {
                    oneRecoreList = _ObjectToSQLHelper._toInsertSQL_for_ValueList(sql_i, entity[i], excludeFieldList);
                }
                preparedValueList.addAll(oneRecoreList);
                if ((i + 1) % batchSize == 0) {
                    HoneyContext.setPreparedValue(t_sql + "  [Batch:" + i / batchSize + index3, preparedValueList);
                    preparedValueList = new ArrayList();
                    continue;
                }
                if (i != len - 1) continue;
                HoneyContext.setPreparedValue(t_sql + "  [Batch:" + i / batchSize + index3, preparedValueList);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public String toDeleteByIdSQL(Class c, Integer id) {
        if (id == null) {
            return null;
        }
        ObjectToSQLRich.checkPackageByClass(c);
        SqlValueWrap sqlBuffer = this.toDeleteByIdSQL0(c);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Integer");
    }

    public String toDeleteByIdSQL(Class c, Long id) {
        if (id == null) {
            return null;
        }
        ObjectToSQLRich.checkPackageByClass(c);
        SqlValueWrap sqlBuffer = this.toDeleteByIdSQL0(c);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Long");
    }

    public String toDeleteByIdSQL(Class c, String ids) {
        if (ids == null || "".equals(ids.trim())) {
            return null;
        }
        ObjectToSQLRich.checkPackageByClass(c);
        SqlValueWrap sqlBuffer = this.toDeleteByIdSQL0(c);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, ids, this.getIdTypeByClass(c));
    }

    private SqlValueWrap toDeleteByIdSQL0(Class c) {
        StringBuffer sqlBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        String tableName = this._toTableNameByClass(c);
        sqlBuffer.append(K.delete).append(" ").append(K.from).append(" ").append(tableName).append(" ").append(K.where).append(" ");
        wrap.setValueBuffer(sqlBuffer);
        wrap.setTableNames(tableName);
        return wrap;
    }

    public <T> String toSelectByIdSQL(T entity, Integer id) {
        SqlValueWrap sqlBuffer = this.toSelectByIdSQL0(entity);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Integer");
    }

    public <T> String toSelectByIdSQL(T entity, Long id) {
        SqlValueWrap sqlBuffer = this.toSelectByIdSQL0(entity);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Long");
    }

    public <T> String toSelectByIdSQL(T entity, String ids) {
        if (ids == null || "".equals(ids.trim())) {
            return null;
        }
        SqlValueWrap sqlBuffer = this.toSelectByIdSQL0(entity);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, ids, this.getIdType(entity));
    }

    private <T> String getIdType(T entity) {
        Field field = null;
        String type = null;
        try {
            field = entity.getClass().getDeclaredField("id");
            type = field.getType().getSimpleName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    private <T> String getIdTypeByClass(Class c) {
        Field field = null;
        String type = null;
        try {
            field = c.getDeclaredField("id");
            type = field.getType().getSimpleName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    public <T> String toSelectSQL(T entity, IncludeType includeType, Condition condition) {
        if (includeType == null) {
            return _ObjectToSQLHelper._toSelectSQL(entity, -1, condition);
        }
        return _ObjectToSQLHelper._toSelectSQL(entity, includeType.getValue(), condition);
    }

    private <T> String _toUpdateBySQL(T entity, String whereFieldList, int includeType) {
        if (whereFieldList == null) {
            return null;
        }
        String sql = "";
        String[] whereFields = whereFieldList.split(",");
        if (whereFields.length == 0 || "".equals(whereFieldList.trim())) {
            throw new ObjSQLException("ObjSQLException:whereFieldList at least include one field.");
        }
        sql = _ObjectToSQLHelper._toUpdateBySQL(entity, whereFields, includeType);
        return sql;
    }

    public <T> String toUpdateBySQL(T entity, String whereFieldList) {
        return this._toUpdateBySQL(entity, whereFieldList, -1);
    }

    public <T> String toUpdateBySQL(T entity, String whereFieldList, IncludeType includeType) {
        return this._toUpdateBySQL(entity, whereFieldList, includeType.getValue());
    }

    public <T> String toUpdateBySQL(T entity, String whereFieldList, Condition condition) {
        String[] whereFields = whereFieldList.split(",");
        if (whereFields.length == 0 || "".equals(whereFieldList.trim())) {
            throw new ObjSQLException("ObjSQLException:whereFieldList at least include one field.");
        }
        if (condition == null || condition.getIncludeType() == null) {
            return _ObjectToSQLHelper._toUpdateBySQL(entity, whereFields, -1, condition);
        }
        return _ObjectToSQLHelper._toUpdateBySQL(entity, whereFields, condition.getIncludeType().getValue(), condition);
    }

    public <T> String toUpdateSQL(T entity, String updateFieldList, Condition condition) {
        if (updateFieldList == null) {
            updateFieldList = "";
        }
        String[] updateFields = updateFieldList.split(",");
        if (condition == null || condition.getIncludeType() == null) {
            return _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, -1, condition);
        }
        return _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, condition.getIncludeType().getValue(), condition);
    }

    private <T> String _toSelectAndDeleteByIdSQL(SqlValueWrap wrap, Number id, String numType) {
        if (id == null) {
            return null;
        }
        StringBuffer sqlBuffer = wrap.getValueBuffer();
        sqlBuffer.append(ObjectToSQLRich._id() + "=").append("?");
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        preparedValue = new PreparedValue();
        preparedValue.setType(numType);
        preparedValue.setValue(id);
        list.add(preparedValue);
        ObjectToSQLRich.setContext(sqlBuffer.toString(), list, wrap.getTableNames());
        return sqlBuffer.toString();
    }

    private <T> String _toSelectAndDeleteByIdSQL(SqlValueWrap wrap, String ids, String idType) {
        StringBuffer sqlBuffer = wrap.getValueBuffer();
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        String[] idArray = ids.split(",");
        String t_ids = ObjectToSQLRich._id() + "=?";
        preparedValue = new PreparedValue();
        if (idType != null) {
            preparedValue.setType(idType);
            if ("Long".equals(idType) || "long".equals(idType)) {
                preparedValue.setValue(Long.parseLong(idArray[0]));
            } else if ("Integer".equals(idType) || "int".equals(idType)) {
                preparedValue.setValue(Integer.parseInt(idArray[0]));
            } else if ("Short".equals(idType) || "short".equals(idType)) {
                preparedValue.setValue(Short.parseShort(idArray[0]));
            } else {
                preparedValue.setValue(idArray[0]);
            }
        } else {
            preparedValue.setValue(idArray[0]);
        }
        list.add(preparedValue);
        for (int i = 1; i < idArray.length; ++i) {
            preparedValue = new PreparedValue();
            t_ids = t_ids + " " + K.or + " " + ObjectToSQLRich._id() + "=?";
            if (idType != null) {
                preparedValue.setType(idType);
                if ("Long".equals(idType) || "long".equals(idType)) {
                    preparedValue.setValue(Long.parseLong(idArray[i]));
                } else if ("Integer".equals(idType) || "int".equals(idType)) {
                    preparedValue.setValue(Integer.parseInt(idArray[i]));
                } else if ("Short".equals(idType) || "short".equals(idType)) {
                    preparedValue.setValue(Short.parseShort(idArray[0]));
                } else {
                    preparedValue.setValue(idArray[i]);
                }
            } else {
                preparedValue.setValue(idArray[i]);
            }
            list.add(preparedValue);
        }
        sqlBuffer.append(t_ids);
        ObjectToSQLRich.setContext(sqlBuffer.toString(), list, wrap.getTableNames());
        return sqlBuffer.toString();
    }

    private <T> SqlValueWrap toSelectByIdSQL0(T entity) {
        StringBuffer sqlBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        String tableName = this._toTableName(entity);
        String packageAndClassName = entity.getClass().getName();
        String columnNames = HoneyContext.getBeanField(packageAndClassName);
        if (columnNames == null) {
            Field[] fields = entity.getClass().getDeclaredFields();
            columnNames = HoneyUtil.getBeanField(fields);
            HoneyContext.addBeanField(packageAndClassName, columnNames);
        }
        sqlBuffer.append(K.select).append(" ").append(columnNames).append(" ").append(K.from).append(" ");
        sqlBuffer.append(tableName).append(" ").append(K.where).append(" ");
        wrap.setValueBuffer(sqlBuffer);
        wrap.setTableNames(tableName);
        return wrap;
    }

    private <T> SqlValueWrap toSelectSQL_0(T entity) {
        return this.toSelectSQL_0(entity, null);
    }

    private <T> SqlValueWrap toSelectSQL_0(T entity, String selectField) {
        StringBuffer sqlBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        try {
            String tableName = "";
            if (this.isNeedRealTimeDb()) {
                tableName = (String)OneTimeParameter.getAttribute("_SYS_Bee_TableName");
                if (tableName == null) {
                    tableName = this._toTableName(entity);
                }
            } else {
                tableName = this._toTableName(entity);
            }
            Field[] fields = entity.getClass().getDeclaredFields();
            String fieldNames = "";
            if (selectField != null && !"".equals(selectField.trim())) {
                fieldNames = HoneyUtil.checkAndProcessSelectField(entity, selectField);
            } else {
                String packageAndClassName = entity.getClass().getName();
                fieldNames = HoneyContext.getBeanField(packageAndClassName);
                if (fieldNames == null) {
                    fieldNames = HoneyUtil.getBeanField(fields);
                    HoneyContext.addBeanField(packageAndClassName, fieldNames);
                }
            }
            sqlBuffer.append(K.select).append(" ").append(fieldNames).append(" ").append(K.from).append(" ");
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            boolean k = false;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(-1, fields[i].get(entity), fields[i])) continue;
                if (firstWhere) {
                    sqlBuffer.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" ").append(K.and).append(" ");
                }
                sqlBuffer.append(ObjectToSQLRich._toColumnName(fields[i].getName()));
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(preparedValue);
            }
            wrap.setTableNames(tableName);
            wrap.setSql(sqlBuffer.toString());
            wrap.setList(list);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return wrap;
    }

    private static void setContext(String sql, List<PreparedValue> list, String tableName) {
        HoneyContext.setContext(sql, list, tableName);
    }

    private static <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    public static void checkPackageByClass(Class c) {
        if (c == null) {
            return;
        }
        String classFullName = c.getName();
        if (classFullName.startsWith("java.") || classFullName.startsWith("javax.")) {
            throw new BeeIllegalEntityException("BeeIllegalEntityException: Illegal Entity, " + c.getName());
        }
    }

    private String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private String _toTableNameByClass(Class c) {
        return NameTranslateHandle.toTableName(c.getName());
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static String _id() {
        return NameTranslateHandle.toColumnName("id");
    }

    private <T> void setInitArrayIdByAuto(T[] entity) {
        if (entity == null || entity.length < 1) {
            return;
        }
        boolean needGenId = HoneyContext.isNeedGenId(entity[0].getClass());
        if (!needGenId) {
            return;
        }
        boolean hasValue = false;
        Long v = null;
        Field field0 = null;
        try {
            field0 = entity[0].getClass().getDeclaredField("id");
            if (field0 == null) {
                return;
            }
            if (!field0.getType().equals(Long.class)) {
                Logger.warn("The id field's " + field0.getType() + " is not Long, can not generate the Long id automatically!");
                return;
            }
            boolean replaceOldValue = HoneyConfig.getHoneyConfig().genid_replaceOldId;
            int len = entity.length;
            String tableKey = this._toTableName(entity[0]);
            long[] ids = GenIdFactory.getRangeId(tableKey, len);
            long id = ids[0];
            Field field = null;
            for (int i = 0; i < len; ++i) {
                if (entity[i] != null) {
                    hasValue = false;
                    v = null;
                    field = entity[i].getClass().getDeclaredField("id");
                    field.setAccessible(true);
                    Object obj = field.get(entity[i]);
                    if (obj != null) {
                        if (!replaceOldValue) {
                            return;
                        }
                        hasValue = true;
                        v = (Long)obj;
                    }
                    OneTimeParameter.setTrueForKey("_SYS_Bee_OLD_ID_FOR_AUTO_ID_EXIST" + i);
                    OneTimeParameter.setAttribute("_SYS_Bee_OLD_ID_FOR_AUTO_ID" + i, obj);
                    field.setAccessible(true);
                    try {
                        field.set(entity[i], id);
                        if (hasValue) {
                            Logger.warn(" [ID WOULD BE REPLACED] entity[" + i + "] : " + entity.getClass() + " 's id field value is " + v + " would be replace by " + id);
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw ExceptionHelper.convert(e);
                    }
                }
                ++id;
            }
        }
        catch (NoSuchFieldException e) {
            return;
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return;
        }
    }

    private boolean isNeedRealTimeDb() {
        return HoneyContext.isNeedRealTimeDb();
    }
}

