/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.PreparedSql;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.bee.osql.exception.SqlNullException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SqlValueWrap;
import org.teasoft.honey.osql.core.TokenUtil;
import org.teasoft.honey.osql.name.NameUtil;

public class PreparedSqlLib
implements PreparedSql {
    private BeeSql beeSql;

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    private DbFeature getDbFeature() {
        return BeeFactory.getHoneyFactory().getDbFeature();
    }

    public <T> List<T> select(String sql, T entity, Object[] preValues) {
        this.initPreparedValues(sql, preValues, entity);
        Logger.logSQL("PreparedSql select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> select(String sql, T entity, Object[] preValues, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        this.regPagePlaceholder();
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = PreparedSqlLib._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        sql = this.getDbFeature().toPageSql(sql, start, size);
        this.initPreparedValues(sql, preValues, entity);
        Logger.logSQL("PreparedSql select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> select(String sqlStr, T entity, Map<String, Object> map) {
        String sql = this.initPrepareValuesViaMap(sqlStr, map, entity);
        Logger.logSQL("PreparedSql select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> select(String sqlStr, T entity, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        this.regPagePlaceholder();
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = PreparedSqlLib._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        String pageSql = this.getDbFeature().toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map, entity);
        Logger.logSQL("PreparedSql select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> selectSomeField(String sql, T entity, Object[] preValues) {
        this.initPreparedValues(sql, preValues, entity);
        Logger.logSQL("PreparedSql selectSomeField SQL: ", sql);
        return this.getBeeSql().selectSomeField(sql, entity);
    }

    public <T> List<T> selectSomeField(String sql, T entity, Object[] preValues, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        this.regPagePlaceholder();
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = PreparedSqlLib._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        sql = this.getDbFeature().toPageSql(sql, start, size);
        this.initPreparedValues(sql, preValues, entity);
        Logger.logSQL("PreparedSql selectSomeField SQL: ", sql);
        return this.getBeeSql().selectSomeField(sql, entity);
    }

    public <T> List<T> selectSomeField(String sqlStr, T entity, Map<String, Object> map) {
        String sql = this.initPrepareValuesViaMap(sqlStr, map, entity);
        Logger.logSQL("PreparedSql selectSomeField SQL: ", sql);
        return this.getBeeSql().selectSomeField(sql, entity);
    }

    public <T> List<T> selectSomeField(String sqlStr, T entity, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        this.regPagePlaceholder();
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = PreparedSqlLib._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        String pageSql = this.getDbFeature().toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map, entity);
        Logger.logSQL("PreparedSql selectSomeField SQL: ", sql);
        return this.getBeeSql().selectSomeField(sql, entity);
    }

    public String selectFun(String sql, Object[] preValues) {
        this.initPreparedValues(sql, preValues);
        Logger.logSQL("PreparedSql selectFun SQL: ", sql);
        return this.getBeeSql().selectFun(sql);
    }

    public String selectFun(String sqlStr, Map<String, Object> map) {
        String sql = this.initPrepareValuesViaMap(sqlStr, map);
        Logger.logSQL("PreparedSql selectFun SQL: ", sql);
        return this.getBeeSql().selectFun(sql);
    }

    public List<String[]> select(String sql, Object[] preValues) {
        this.initPreparedValues(sql, preValues);
        Logger.logSQL("PreparedSql select SQL: ", sql);
        return this.getBeeSql().select(sql);
    }

    public List<String[]> select(String sql, Object[] preValues, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        this.regPagePlaceholder();
        sql = this.getDbFeature().toPageSql(sql, start, size);
        this.initPreparedValues(sql, preValues);
        Logger.logSQL("PreparedSql select SQL: ", sql);
        return this.getBeeSql().select(sql);
    }

    public List<String[]> select(String sqlStr, Map<String, Object> map) {
        String sql = this.initPrepareValuesViaMap(sqlStr, map);
        Logger.logSQL("PreparedSql select SQL: ", sql);
        return this.getBeeSql().select(sql);
    }

    public List<String[]> select(String sqlStr, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        this.regPagePlaceholder();
        String pageSql = this.getDbFeature().toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map);
        Logger.logSQL("PreparedSql select SQL: ", sql);
        return this.getBeeSql().select(sql);
    }

    @Deprecated
    public int modify(String sql, Object[] preValues) {
        this.initPreparedValues(sql, preValues);
        Logger.logSQL("PreparedSql modify SQL: ", sql);
        return this.getBeeSql().modify(sql);
    }

    @Deprecated
    public int modify(String sqlStr, Map<String, Object> map) {
        String sql = this.initPrepareValuesViaMap(sqlStr, map);
        Logger.logSQL("PreparedSql modify SQL: ", sql);
        return this.getBeeSql().modify(sql);
    }

    @Deprecated
    public int modify(String sql) {
        Object[] preValues = null;
        return this.modify(sql, preValues);
    }

    public String selectJson(String sql, Object[] preValues) {
        this.initPreparedValues(sql, preValues);
        Logger.logSQL("PreparedSql selectJson SQL: ", sql);
        return this.getBeeSql().selectJson(sql);
    }

    public String selectJson(String sql, Object[] preValues, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        this.regPagePlaceholder();
        sql = this.getDbFeature().toPageSql(sql, start, size);
        this.initPreparedValues(sql, preValues);
        Logger.logSQL("PreparedSql selectJson SQL: ", sql);
        return this.getBeeSql().selectJson(sql);
    }

    public String selectJson(String sqlStr, Map<String, Object> map) {
        String sql = this.initPrepareValuesViaMap(sqlStr, map);
        Logger.logSQL("PreparedSql selectJson SQL: ", sql);
        return this.getBeeSql().selectJson(sql);
    }

    public String selectJson(String sqlStr, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        this.regPagePlaceholder();
        String pageSql = this.getDbFeature().toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map);
        Logger.logSQL("PreparedSql selectJson SQL: ", sql);
        return this.getBeeSql().selectJson(sql);
    }

    public String selectJson(String sqlStr) {
        Object[] preValues = null;
        return this.selectJson(sqlStr, preValues);
    }

    public List<String[]> select(String sql) {
        Object[] preValues = null;
        return this.select(sql, preValues);
    }

    public String selectFun(String sql) {
        Object[] preValues = null;
        return this.selectFun(sql, preValues);
    }

    private <T> void initPreparedValues(String sql, Object[] preValues, T entity) {
        List list = this._initPreparedValues(sql, preValues);
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = (String)OneTimeParameter.getAttribute("_SYS_Bee_TableName");
            if (tableName == null) {
                tableName = PreparedSqlLib._toTableName(entity);
            }
        } else {
            tableName = PreparedSqlLib._toTableName(entity);
        }
        HoneyUtil.setPageNum(list);
        HoneyContext.setContext(sql, list, tableName);
    }

    private void initPreparedValues(String sql, Object[] preValues) {
        List list = this._initPreparedValues(sql, preValues);
        HoneyUtil.setPageNum(list);
        HoneyContext.setPreparedValue(sql, list);
    }

    private List _initPreparedValues(String sql, Object[] preValues) {
        if (sql == null || "".equals(sql.trim())) {
            throw new SqlNullException("sql statement string is Null !");
        }
        PreparedValue preparedValue = null;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        for (int i = 0; preValues != null && i < preValues.length; ++i) {
            preparedValue = new PreparedValue();
            preparedValue.setType(preValues[i].getClass().getName());
            preparedValue.setValue(preValues[i]);
            list.add(preparedValue);
        }
        return list;
    }

    private <T> Map<String, Object> mergeMap(Map<String, Object> prameterMap, T entity) {
        Map<String, Object> columnMap = HoneyUtil.getColumnMapByEntity(entity);
        columnMap.putAll(prameterMap);
        return columnMap;
    }

    private <T> String initPrepareValuesViaMap(String sqlStr, Map<String, Object> parameterMap, T entity) {
        String reSql;
        if (sqlStr == null || "".equals(sqlStr.trim())) {
            throw new SqlNullException("sql statement string is Null !");
        }
        parameterMap = this.mergeMap(parameterMap, entity);
        SqlValueWrap wrap = this.processSql(sqlStr);
        List<PreparedValue> list = null;
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = (String)OneTimeParameter.getAttribute("_SYS_Bee_TableName");
            if (tableName == null) {
                tableName = PreparedSqlLib._toTableName(entity);
            }
        } else {
            tableName = PreparedSqlLib._toTableName(entity);
        }
        if (wrap == null) {
            reSql = sqlStr;
            list = new ArrayList<PreparedValue>();
        } else {
            String sql = wrap.getSql();
            String mapKeys = wrap.getValueBuffer().toString();
            list = this._initPreparedValues(mapKeys, parameterMap);
            reSql = sql;
        }
        HoneyUtil.setPageNum(list);
        HoneyContext.setContext(reSql, list, tableName);
        return reSql;
    }

    private String initPrepareValuesViaMap(String sqlStr, Map<String, Object> map) {
        if (sqlStr == null || "".equals(sqlStr.trim())) {
            throw new SqlNullException("sql statement string is Null !");
        }
        SqlValueWrap wrap = this.processSql(sqlStr);
        if (wrap == null) {
            return sqlStr;
        }
        String sql = wrap.getSql();
        String mapKeys = wrap.getValueBuffer().toString();
        List list = this._initPreparedValues(mapKeys, map);
        HoneyUtil.setPageNum(list);
        HoneyContext.setPreparedValue(sql, list);
        return sql;
    }

    private List _initPreparedValues(String mapKeys, Map<String, Object> map) {
        PreparedValue preparedValue = null;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        String[] keys = mapKeys.split(",");
        for (int i = 0; i < keys.length; ++i) {
            preparedValue = new PreparedValue();
            Object value = null;
            int len = keys[i].length();
            if (keys[i].startsWith("%")) {
                if (keys[i].endsWith("%")) {
                    keys[i] = keys[i].substring(1, len - 1);
                    value = "%" + map.get(keys[i]) + "%";
                    preparedValue.setValue(value);
                } else {
                    keys[i] = keys[i].substring(1, len);
                    value = "%" + map.get(keys[i]);
                    preparedValue.setValue(value);
                }
            } else if (keys[i].endsWith("%")) {
                keys[i] = keys[i].substring(0, len - 1);
                value = map.get(keys[i]) + "%";
                preparedValue.setValue(value);
            } else {
                value = map.get(keys[i]);
                preparedValue.setValue(value);
            }
            preparedValue.setType(map.get(keys[i]).getClass().getName());
            list.add(preparedValue);
        }
        return list;
    }

    private SqlValueWrap processSql(String sql) {
        return TokenUtil.process(sql, "#{", "}", "?");
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private void regPagePlaceholder() {
        HoneyUtil.regPagePlaceholder();
    }

    private boolean isNeedRealTimeDb() {
        return HoneyContext.isNeedRealTimeDb();
    }

    public List<Map<String, Object>> selectMapList(String sql) {
        Logger.logSQL("PreparedSql selectMapList SQL: ", sql);
        return this.getBeeSql().selectMapList(sql);
    }

    public List<Map<String, Object>> selectMapList(String sql, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        sql = this.getDbFeature().toPageSql(sql, start, size);
        Logger.logSQL("PreparedSql selectMapList SQL: ", sql);
        return this.getBeeSql().selectMapList(sql);
    }
}

