/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.BeeIllegalBusinessException;
import org.teasoft.honey.distribution.GenIdFactory;
import org.teasoft.honey.osql.core.ConditionHelper;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.StringUtils;

final class _ObjectToSQLHelper {
    private static final String INSERT_INTO = K.insert + K.space + K.into + K.space;
    private static boolean showSQL = HoneyConfig.getHoneyConfig().showSQL;

    private _ObjectToSQLHelper() {
    }

    static <T> String _toSelectSQL(T entity, String fieldNameList) {
        _ObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        try {
            String tableName = _ObjectToSQLHelper._toTableName(entity);
            Field[] fields = entity.getClass().getDeclaredFields();
            sqlBuffer.append(K.select).append(" ").append(fieldNameList).append(" ").append(K.from).append(" ");
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(-1, fields[i].get(entity), fields[i])) continue;
                if (firstWhere) {
                    sqlBuffer.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" ").append(K.and).append(" ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(preparedValue);
            }
            sql = sqlBuffer.toString();
            _ObjectToSQLHelper.setContext(sql, list, tableName);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    static <T> String _toSelectSQL(T entity, int includeType, Condition condition) {
        return _ObjectToSQLHelper._toSelectSQL(entity, includeType, condition, false);
    }

    static <T> String _toSelectSQL(T entity, int includeType, Condition condition, boolean isCheckOneFunction) {
        _ObjectToSQLHelper.checkPackage(entity);
        StringBuffer sqlBuffer = new StringBuffer();
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        boolean firstWhere = true;
        boolean isFun = false;
        try {
            Field[] fields = entity.getClass().getDeclaredFields();
            String packageAndClassName = entity.getClass().getName();
            String columnNames = HoneyContext.getBeanField(packageAndClassName);
            if (columnNames == null) {
                columnNames = HoneyUtil.getBeanField(fields);
                HoneyContext.addBeanField(packageAndClassName, columnNames);
            }
            if (condition != null) {
                condition.setSuidType(SuidType.SELECT);
                String fun = ConditionHelper.processFunction(columnNames, condition);
                if (isCheckOneFunction) {
                    if (fun.contains(",")) {
                        throw new BeeErrorGrammarException("The method just support use one Function!");
                    }
                    if ("".equals(fun)) {
                        throw new BeeErrorGrammarException("The method need set the Function with Condition selectFun!");
                    }
                }
                String selectField = ConditionHelper.processSelectField(columnNames, condition);
                if (isCheckOneFunction) {
                    columnNames = fun;
                } else if (selectField != null && StringUtils.isEmpty(fun)) {
                    columnNames = selectField;
                } else if (selectField != null && StringUtils.isNotEmpty(fun)) {
                    columnNames = selectField + "," + fun;
                } else if (selectField == null && StringUtils.isNotEmpty(fun)) {
                    columnNames = fun;
                }
            }
            sqlBuffer.append(K.select).append(" ").append(columnNames).append(" ").append(K.from).append(" ");
            sqlBuffer.append(tableName);
            int len = fields.length;
            PreparedValue preparedValue = null;
            boolean k = false;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName())) continue;
                if (firstWhere) {
                    sqlBuffer.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" ").append(K.and).append(" ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer.append(" ").append(K.isNull);
                    continue;
                }
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(preparedValue);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        if (condition != null) {
            condition.setSuidType(SuidType.SELECT);
            if (isFun) {
                OneTimeParameter.setTrueForKey("_SYS_Bee_Select_Fun");
            } else if (HoneyContext.isNeedRealTimeDb()) {
                HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
                OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
            }
            ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere);
        }
        _ObjectToSQLHelper.setContext(sqlBuffer.toString(), list, tableName);
        return sqlBuffer.toString();
    }

    static <T> String _toSelectSQL(T entity, int includeType) {
        return _ObjectToSQLHelper._toSelectSQL(entity, includeType, null);
    }

    static <T> String _toUpdateSQL(T entity, int includeType) {
        _ObjectToSQLHelper.checkPackage(entity);
        Field field = null;
        try {
            field = entity.getClass().getDeclaredField("id");
        }
        catch (NoSuchFieldException e) {
            throw new ObjSQLException("ObjSQLException: in the update(T entity) or update(T entity,IncludeType includeType), the id field is default key field !");
        }
        field.setAccessible(true);
        try {
            if (field.get(entity) == null) {
                throw new ObjSQLException("ObjSQLException: in the update(T entity) or update(T entity,IncludeType includeType), the id field of entity must not be null !");
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return _ObjectToSQLHelper._toUpdateBySQL(entity, new String[]{"id"}, includeType);
    }

    static <T> String _toUpdateSQL(T entity, String[] setColmn, int includeType) {
        return _ObjectToSQLHelper._toUpdateSQL(entity, setColmn, includeType, null);
    }

    static <T> String _toUpdateSQL(T entity, String[] setColmns, int includeType, Condition condition) {
        boolean notUpdateWholeRecords;
        _ObjectToSQLHelper.checkPackage(entity);
        Set updatefieldSet = null;
        if (condition != null) {
            updatefieldSet = condition.getUpdatefields();
        }
        if ((setColmns == null || setColmns.length == 1 && "".equals(setColmns[0].trim())) && ObjectUtils.isEmpty(updatefieldSet)) {
            throw new ObjSQLException("ObjSQLException: in SQL update set at least include one field.");
        }
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        boolean firstSet = true;
        boolean firstWhere = true;
        boolean isExistWhere = false;
        StringBuffer whereStament = new StringBuffer();
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        try {
            sqlBuffer.append(K.update).append(" ");
            sqlBuffer.append(tableName);
            sqlBuffer.append(" ").append(K.set).append(" ");
            if (condition != null) {
                condition.setSuidType(SuidType.UPDATE);
                firstSet = ConditionHelper.processConditionForUpdateSet(sqlBuffer, list, condition);
            }
            Field[] fields = entity.getClass().getDeclaredFields();
            int len = fields.length;
            ArrayList<PreparedValue> whereList = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (_ObjectToSQLHelper.isContainField(setColmns, fields[i].getName()) && (updatefieldSet == null || !updatefieldSet.contains(fields[i].getName()))) {
                    if (firstSet) {
                        firstSet = false;
                    } else {
                        sqlBuffer.append(", ");
                    }
                    sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                    if (fields[i].get(entity) == null) {
                        sqlBuffer.append("=").append(K.Null);
                        continue;
                    }
                    sqlBuffer.append("=");
                    sqlBuffer.append("?");
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    list.add(preparedValue);
                    continue;
                }
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName())) continue;
                if (firstWhere) {
                    whereStament.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    whereStament.append(" ").append(K.and).append(" ");
                }
                whereStament.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    whereStament.append(" ").append(K.isNull);
                } else {
                    whereStament.append("=");
                    whereStament.append("?");
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    whereList.add(preparedValue);
                }
                isExistWhere = true;
            }
            sqlBuffer.append(whereStament);
            list.addAll(whereList);
            if (firstSet) {
                Logger.logSQL("update SQL(updateFields) : ", sqlBuffer.toString());
                throw new BeeErrorGrammarException("BeeErrorGrammarException: the SQL update set part is empty!");
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        if (condition != null) {
            condition.setSuidType(SuidType.UPDATE);
            firstWhere = ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere);
        }
        sql = sqlBuffer.toString();
        _ObjectToSQLHelper.setContext(sql, list, tableName);
        if (firstWhere && (notUpdateWholeRecords = HoneyConfig.getHoneyConfig().notUpdateWholeRecords)) {
            Logger.logSQL("update SQL: ", sql);
            throw new BeeIllegalBusinessException("BeeIllegalBusinessException: It is not allowed update whole records in one table.");
        }
        return sql;
    }

    static <T> String _toUpdateBySQL(T entity, String[] whereColumns, int includeType) {
        return _ObjectToSQLHelper._toUpdateBySQL(entity, whereColumns, includeType, null);
    }

    static <T> String _toUpdateBySQL(T entity, String[] whereColumns, int includeType, Condition condition) {
        boolean notUpdateWholeRecords;
        _ObjectToSQLHelper.checkPackage(entity);
        Set conditionFieldSet = null;
        if (condition != null) {
            conditionFieldSet = condition.getWhereFields();
        }
        Set updatefieldSet = null;
        if (condition != null) {
            updatefieldSet = condition.getUpdatefields();
        }
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        boolean firstSet = true;
        boolean firstWhere = true;
        boolean isExistWhere = false;
        StringBuffer whereStament = new StringBuffer();
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        try {
            sqlBuffer.append(K.update).append(" ");
            sqlBuffer.append(tableName);
            sqlBuffer.append(" ").append(K.set).append(" ");
            if (condition != null) {
                condition.setSuidType(SuidType.UPDATE);
                firstSet = ConditionHelper.processConditionForUpdateSet(sqlBuffer, list, condition);
            }
            Field[] fields = entity.getClass().getDeclaredFields();
            int len = fields.length;
            ArrayList<PreparedValue> whereList = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (!_ObjectToSQLHelper.isContainField(whereColumns, fields[i].getName())) {
                    if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName())) continue;
                    if (updatefieldSet != null && updatefieldSet.contains(fields[i].getName())) {
                        Logger.warn("The field [" + fields[i].getName() + "] which value is '" + fields[i].get(entity) + "', already set in condition! It will be ignored!");
                        continue;
                    }
                    if (firstSet) {
                        firstSet = false;
                    } else {
                        sqlBuffer.append(" , ");
                    }
                    sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                    if (fields[i].get(entity) == null) {
                        sqlBuffer.append(" =").append(K.Null);
                        continue;
                    }
                    sqlBuffer.append("=");
                    sqlBuffer.append("?");
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    list.add(preparedValue);
                    continue;
                }
                if (conditionFieldSet != null && conditionFieldSet.contains(fields[i].getName()) && HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName())) continue;
                if (firstWhere) {
                    whereStament.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    whereStament.append(" ").append(K.and).append(" ");
                }
                whereStament.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    whereStament.append(" ").append(K.isNull);
                } else {
                    whereStament.append("=");
                    whereStament.append("?");
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    whereList.add(preparedValue);
                }
                isExistWhere = true;
            }
            sqlBuffer.append(whereStament);
            list.addAll(whereList);
            if (firstSet) {
                Logger.logSQL("update SQL(updateFields) : ", sqlBuffer.toString());
                throw new BeeErrorGrammarException("BeeErrorGrammarException: the SQL update set part is empty!");
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        if (condition != null) {
            condition.setSuidType(SuidType.UPDATE);
            firstWhere = ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere);
        }
        sql = sqlBuffer.toString();
        _ObjectToSQLHelper.setContext(sql, list, tableName);
        if (firstWhere && (notUpdateWholeRecords = HoneyConfig.getHoneyConfig().notUpdateWholeRecords)) {
            Logger.logSQL("update SQL: ", sql);
            throw new BeeIllegalBusinessException("BeeIllegalBusinessException: It is not allowed update whole records in one table.");
        }
        return sql;
    }

    static <T> String _toInsertSQL0(T entity, int includeType, String excludeFieldList) throws IllegalAccessException {
        _ObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer sqlValue = new StringBuffer(" (");
        boolean isFirst = true;
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        sqlBuffer.append(INSERT_INTO);
        sqlBuffer.append(tableName);
        sqlBuffer.append("(");
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        for (int i = 0; i < len; ++i) {
            fields[i].setAccessible(true);
            if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || !"".equals(excludeFieldList) && _ObjectToSQLHelper.isExcludeField(excludeFieldList, fields[i].getName())) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sqlBuffer.append(",");
                sqlValue.append(",");
            }
            sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
            sqlValue.append("?");
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            list.add(preparedValue);
        }
        sqlValue.append(")");
        sqlBuffer.append(") ").append(K.values);
        sqlBuffer.append(sqlValue);
        sql = sqlBuffer.toString();
        if (OneTimeParameter.isTrue("_SYS_Bee_Return_PlaceholderValue")) {
            OneTimeParameter.setAttribute("_SYS_Bee_PlaceholderValue", sqlValue.toString());
        }
        _ObjectToSQLHelper.setContext(sql, list, tableName);
        return sql;
    }

    static <T> List<PreparedValue> _toInsertSQL_for_ValueList(String sql_i, T entity, String excludeFieldList) throws IllegalAccessException {
        _ObjectToSQLHelper.checkPackage(entity);
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        for (int i = 0; i < len; ++i) {
            fields[i].setAccessible(true);
            if (HoneyUtil.isSkipField(fields[i]) || !"".equals(excludeFieldList) && _ObjectToSQLHelper.isExcludeField(excludeFieldList, fields[i].getName())) continue;
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            list.add(preparedValue);
        }
        if (!HoneyUtil.isMysql() || showSQL) {
            HoneyContext.setPreparedValue(sql_i, list);
        }
        return list;
    }

    static <T> String _toDeleteSQL(T entity, int includeType) {
        return _ObjectToSQLHelper._toDeleteSQL(entity, includeType, null);
    }

    static <T> String _toDeleteSQL(T entity, int includeType, Condition condition) {
        _ObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        boolean firstWhere = true;
        try {
            boolean notDeleteWholeRecords;
            String tableName = _ObjectToSQLHelper._toTableName(entity);
            sqlBuffer.append(K.delete).append(" ").append(K.from).append(" ");
            sqlBuffer.append(tableName);
            Field[] fields = entity.getClass().getDeclaredFields();
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            boolean k = false;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName())) continue;
                if (firstWhere) {
                    sqlBuffer.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" ").append(K.and).append(" ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer.append(" ").append(K.isNull);
                    continue;
                }
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(preparedValue);
            }
            if (condition != null) {
                condition.setSuidType(SuidType.DELETE);
                firstWhere = ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere);
            }
            sql = sqlBuffer.toString();
            _ObjectToSQLHelper.setContext(sql, list, tableName);
            if (firstWhere && (notDeleteWholeRecords = HoneyConfig.getHoneyConfig().notDeleteWholeRecords)) {
                Logger.logSQL("delete SQL: ", sql);
                throw new BeeIllegalBusinessException("BeeIllegalBusinessException: It is not allowed delete whole records in one table.");
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    private static boolean isContainField(String[] checkFields, String fieldName) {
        if (checkFields == null) {
            return false;
        }
        int len = checkFields.length;
        for (int i = 0; i < len; ++i) {
            if (!checkFields[i].equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExcludeField(String excludeFieldList, String checkField) {
        String[] excludeFields;
        for (String f : excludeFields = excludeFieldList.split(",")) {
            if (!f.equals(checkField)) continue;
            return true;
        }
        return false;
    }

    static void setContext(String sql, List<PreparedValue> list, String tableName) {
        HoneyContext.setContext(sql, list, tableName);
    }

    private static <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    static <T> void setInitIdByAuto(T entity) {
        if (entity == null) {
            return;
        }
        boolean needGenId = HoneyContext.isNeedGenId(entity.getClass());
        if (!needGenId) {
            return;
        }
        Field field = null;
        boolean hasValue = false;
        Long v = null;
        try {
            field = entity.getClass().getDeclaredField("id");
            if (field == null) {
                return;
            }
            if (!field.getType().equals(Long.class)) {
                Logger.warn("The id field's " + field.getType() + " is not Long, can not generate the Long id automatically!");
                return;
            }
            boolean replaceOldValue = HoneyConfig.getHoneyConfig().genid_replaceOldId;
            field.setAccessible(true);
            Object obj = field.get(entity);
            if (obj != null) {
                if (!replaceOldValue) {
                    return;
                }
                hasValue = true;
                v = (Long)obj;
            }
            OneTimeParameter.setTrueForKey("_SYS_Bee_OLD_ID_FOR_AUTO_ID_EXIST");
            OneTimeParameter.setAttribute("_SYS_Bee_OLD_ID_FOR_AUTO_ID", obj);
        }
        catch (NoSuchFieldException e) {
            return;
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return;
        }
        String tableKey = _ObjectToSQLHelper._toTableName(entity);
        long id = GenIdFactory.get(tableKey);
        field.setAccessible(true);
        try {
            field.set(entity, id);
            if (hasValue) {
                Logger.warn(" [ID WOULD BE REPLACED] " + entity.getClass() + " 's id field value is " + v + " would be replace by " + id);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
    }
}

