/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.util;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.teasoft.bee.osql.LowerKey;
import org.teasoft.bee.osql.exception.BeeErrorNameException;
import org.teasoft.honey.osql.core.Logger;

public class NameCheckUtil {
    private static Set<String> keywordSet = NameCheckUtil._keywordSet();

    public static Set<String> keywordSet() {
        return keywordSet;
    }

    public static boolean isKeyName(String name) {
        return keywordSet.contains(name);
    }

    private static Set<String> _keywordSet() {
        LowerKey entity = new LowerKey();
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        HashSet<String> set = new HashSet<String>();
        try {
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                set.add(fields[i].get(entity).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return set;
    }

    public static boolean isValidName(String name) {
        String p = "^[0-9a-zA-Z_.]{1,}$";
        Pattern pattern = Pattern.compile(p);
        return pattern.matcher(name).find();
    }

    public static boolean isNotValidName(String name) {
        return !NameCheckUtil.isValidName(name);
    }

    public static void checkName(String name) {
        if (name != null && name.contains(",")) {
            String[] n = name.split(",");
            for (int i = 0; i < n.length; ++i) {
                NameCheckUtil._checkName(n[i]);
            }
        } else {
            NameCheckUtil._checkName(name);
        }
    }

    private static void _checkName(String name) {
        if (name == null) {
            throw new BeeErrorNameException("The name is null !");
        }
        if ("count(*)".equalsIgnoreCase(name)) {
            return;
        }
        if (NameCheckUtil.isKeyName(name)) {
            Logger.warn("The name : '" + name + "' , it is key word name!");
        }
        if (NameCheckUtil.isValidName(name)) {
            return;
        }
        if (NameCheckUtil.isIllegal(name)) {
            throw new BeeErrorNameException("The name: '" + name + "' is illegal!");
        }
        Logger.warn("The name is '" + name + "' , does not conform to naming conventions!");
    }

    public static boolean isIllegal(String fieldName) {
        return fieldName == null || fieldName.contains(" ") || fieldName.contains("-") || fieldName.contains("#") || fieldName.contains("|") || fieldName.contains("+") || fieldName.contains("/*") || fieldName.contains(";");
    }
}

