/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.teasoft.bee.osql.exception.ConfigWrongException;
import org.teasoft.honey.osql.core.Logger;

public class PropertiesReader {
    private Properties prop;

    public PropertiesReader() {
    }

    public PropertiesReader(String fileName) {
        try {
            if (!fileName.trim().startsWith("/")) {
                fileName = "/" + fileName.trim();
            }
            this.prop = new Properties();
            InputStream in = PropertiesReader.class.getResourceAsStream(fileName);
            this.prop.load(in);
        }
        catch (IOException | NullPointerException e) {
            Logger.warn("  In PropertiesReader not found the file :" + fileName + "  .  " + e.getMessage());
        }
    }

    public PropertiesReader(String filePathAndName, boolean custom) {
        try {
            this.prop = new Properties();
            FileInputStream in = new FileInputStream(new File(filePathAndName));
            this.prop.load(in);
        }
        catch (IOException | NullPointerException e) {
            Logger.warn("  In PropertiesReader not found the file :" + filePathAndName + "  .  " + e.getMessage());
            throw new ConfigWrongException("filePathAndName: " + filePathAndName + " config wrong!  " + e.getMessage());
        }
    }

    public String getValue(String key) {
        return this.prop.getProperty(key);
    }

    public String getValueText(String key) {
        return this.prop.getProperty(key, "");
    }

    public String getValue(String key, String defaultValue) {
        return this.prop.getProperty(key, defaultValue);
    }

    public Set<String> getKeys() {
        return this.prop.stringPropertyNames();
    }
}

