/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.teasoft.honey.jdbc.EmptyDataSource;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.SessionFactory;
import org.teasoft.honey.util.StringUtils;

public class SimpleDataSource
extends EmptyDataSource {
    private String url;
    private String username;
    private String password;
    private String driverName;
    private int counter = 0;
    private volatile boolean inited = false;
    private Connection conn = null;

    public SimpleDataSource() {
    }

    public SimpleDataSource(String url, String username, String pwd0) {
        this.url = url;
        this.username = username;
        this.password = pwd0;
        this.init();
    }

    public void init() {
        if (this.inited) {
            return;
        }
        if (this.counter >= 1) {
            this.inited = true;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (!this.inited) {
                Logger.warn("Do not config the connection info!");
            }
            this.conn = SessionFactory.getOriginalConnForIntra(this.getUrl(), this.getUsername(), this.getPassword(), this.getDriverName());
            this.inited = true;
        }
        catch (Exception ex) {
            Logger.warn(ex.getMessage(), ex);
        }
        return this.conn;
    }

    public String getUrl() {
        if (StringUtils.isNotBlank(this.password) && this.url != null && this.url.startsWith("jdbc:ucanaccess:") && !this.url.contains("jackcessOpener=")) {
            this.url = this.url + ";jackcessOpener=org.teasoft.beex.access.BeeAccessCryptOpener";
            return this.url;
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.counter = 1;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }
}

