/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.teasoft.bee.osql.BeeAbstractFactory;
import org.teasoft.honey.distribution.ds.Router;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyFactory;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;

public class BeeFactory
extends BeeAbstractFactory {
    private static BeeFactory instance = new BeeFactory();
    private static HoneyFactory honeyFactory = null;

    public static HoneyFactory getHoneyFactory() {
        if (honeyFactory == null) {
            honeyFactory = new HoneyFactory();
        }
        return honeyFactory;
    }

    private BeeFactory() {
    }

    public static BeeFactory getInstance() {
        return instance;
    }

    public DataSource getDataSource() {
        if (super.getDataSourceMap() == null) {
            return super.getDataSource();
        }
        return this._getDsFromDsMap();
    }

    private DataSource _getDsFromDsMap() {
        String dsName = Router.getDsName();
        Logger.info("[Bee] ========= the current DataSource name is :" + dsName + this.shardingIndex());
        DataSource ds = (DataSource)this.getDataSourceMap().get(dsName);
        if (ds == null) {
            Logger.warn("Can not find the DataSource from DataSource Map with dsName: " + dsName);
        }
        return ds;
    }

    private String shardingIndex() {
        Integer subThreadIndex = HoneyContext.getSqlIndexLocal();
        String index = "";
        if (subThreadIndex != null) {
            index = " (sharding " + subThreadIndex + ")";
        }
        return index;
    }

    protected void parseDbNameByDsMap() {
        Map dsMap = this.getDataSourceMap();
        if (dsMap == null) {
            return;
        }
        int i = 0;
        String dbName = "";
        LinkedHashMap<String, String> dsName2DbName = new LinkedHashMap<String, String>();
        for (Map.Entry entry : dsMap.entrySet()) {
            dsName2DbName.put((String)entry.getKey(), this.getDbName((DataSource)entry.getValue()));
            if (i != 0) continue;
            dbName = (String)dsName2DbName.get(entry.getKey());
            ++i;
        }
        Logger.info("[Bee] Parse DataSourceMap: dataSource name to database name , result: " + dsName2DbName);
        HoneyConfig.getHoneyConfig().setDbName(dbName);
        HoneyContext.setDsName2DbName(dsName2DbName);
        HoneyUtil.refreshSetParaAndResultTypeHandlerRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDbName(DataSource ds) {
        Connection conn = null;
        String dbName = null;
        try {
            conn = ds.getConnection();
            if (conn != null && (dbName = conn.getMetaData().getDatabaseProductName()).contains("Microsoft Access")) {
                Logger.debug("Transform the dbName:'" + dbName + "' to '" + "Microsoft Access" + "'");
                dbName = "Microsoft Access";
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e2) {
                Logger.error(e2.getMessage(), e2);
            }
        }
        return dbName;
    }

    static {
        HoneyContext.initLoad();
    }
}

