/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.io.InputStream;
import java.sql.Connection;
import org.teasoft.bee.osql.annotation.SysValue;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.dialect.DbFeatureRegistry;
import org.teasoft.bee.osql.exception.ConfigWrongException;
import org.teasoft.honey.distribution.ds.Router;
import org.teasoft.honey.logging.LoggerFactory;
import org.teasoft.honey.osql.core.BeeActiveProp;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.BeeProp;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.SessionFactory;
import org.teasoft.honey.osql.core.SysValueProcessor;
import org.teasoft.honey.osql.dialect.LimitOffsetPaging;
import org.teasoft.honey.osql.dialect.sqlserver.SqlServerFeature2012;
import org.teasoft.honey.util.StringUtils;

public final class HoneyConfig {
    private static HoneyConfig honeyConfig = null;
    @SysValue(value="${bee.profiles.type}")
    public int type;
    @SysValue(value="${bee.profiles.active}")
    public String active;
    @SysValue(value="${bee.osql.loggerType}")
    private String loggerType;
    @SysValue(value="${bee.osql.sqlLoggerLevel}")
    public String sqlLoggerLevel;
    @SysValue(value="${bee.osql.systemLoggerLevel}")
    public String systemLoggerLevel = "info";
    @SysValue(value="${bee.osql.logDonotPrintLevel}")
    public boolean logDonotPrintLevel = true;
    @SysValue(value="${bee.osql.dateFormat}")
    public String dateFormat;
    @SysValue(value="${bee.osql.sqlKeyWordCase}")
    public String sqlKeyWordCase;
    @SysValue(value="${bee.osql.notDeleteWholeRecords}")
    public boolean notDeleteWholeRecords = true;
    @SysValue(value="${bee.osql.notUpdateWholeRecords}")
    public boolean notUpdateWholeRecords = true;
    @SysValue(value="${bee.osql.notCatchModifyDuplicateException}")
    public boolean notCatchModifyDuplicateException;
    @SysValue(value="${bee.osql.notShowModifyDuplicateException}")
    public boolean notShowModifyDuplicateException;
    @SysValue(value="${bee.osql.insertBatchSize}")
    int insertBatchSize = 10000;
    @SysValue(value="${bee.osql.lang}")
    public String lang = "CN";
    @SysValue(value="${bee.osql.openDefineColumn}")
    public boolean openDefineColumn;
    @SysValue(value="${bee.osql.openFieldTypeHandler}")
    public boolean openFieldTypeHandler;
    @SysValue(value="${bee.osql.showSQL}")
    public boolean showSQL = false;
    @SysValue(value="${bee.osql.showShardingSQL}")
    public boolean showShardingSQL = false;
    @SysValue(value="${bee.osql.showSql.showType}")
    boolean showSql_showType;
    @SysValue(value="${bee.osql.showSql.showExecutableSql}")
    public boolean showSql_showExecutableSql;
    @SysValue(value="${bee.osql.showSql.donotPrintCurrentDate}")
    public boolean showSql_donotPrintCurrentDate;
    @SysValue(value="${bee.osql.naming.toLowerCaseBefore}")
    public boolean naming_toLowerCaseBefore = true;
    @SysValue(value="${bee.osql.naming.translateType}")
    public int naming_translateType = 1;
    @SysValue(value="${bee.osql.naming.useMoreTranslateType}")
    public boolean naming_useMoreTranslateType;
    @SysValue(value="${bee.osql.naming.entity2tableMappingList}")
    public String naming_entity2tableMappingList;
    @SysValue(value="${bee.osql.moreTable.columnListWithStar}")
    boolean moreTable_columnListWithStar;
    @SysValue(value="${bee.osql.moreTable.twoTablesWithJoinOnStyle}")
    boolean moreTable_twoTablesWithJoinOnStyle;
    @SysValue(value="${bee.osql.selectJson.ignoreNull}")
    public boolean selectJson_ignoreNull = true;
    @SysValue(value="${bee.osql.selectJson.timestampWithMillisecond}")
    public boolean selectJson_timestampWithMillisecond;
    @SysValue(value="${bee.osql.selectJson.dateWithMillisecond}")
    public boolean selectJson_dateWithMillisecond;
    @SysValue(value="${bee.osql.selectJson.timeWithMillisecond}")
    public boolean selectJson_timeWithMillisecond;
    @SysValue(value="${bee.osql.selectJson.longToString}")
    public boolean selectJson_longToString = true;
    @SysValue(value="${bee.osql.returnStringList.nullToEmptyString}")
    public boolean returnStringList_nullToEmptyString;
    private int databaseMajorVersion;
    @SysValue(value="${bee.db.isAndroid}")
    public boolean isAndroid;
    @SysValue(value="${bee.db.androidDbName}")
    public String androidDbName;
    @SysValue(value="${bee.db.androidDbVersion}")
    public int androidDbVersion = 1;
    @SysValue(value="${bee.db.isHarmony}")
    public boolean isHarmony;
    @SysValue(value="${bee.db.harmonyDbName}")
    public String harmonyDbName;
    @SysValue(value="${bee.db.harmonyDbVersion}")
    public int harmonyDbVersion = 1;
    @SysValue(value="${bee.db.harmonyDbReadonly}")
    public boolean harmonyDbReadonly;
    @SysValue(value="${bee.db.dbName}")
    String dbName;
    @SysValue(value="${bee.db.driverName}")
    String driverName;
    @SysValue(value="${bee.db.url}")
    String url;
    @SysValue(value="${bee.db.username}")
    String username;
    @SysValue(value="${bee.db.password}")
    String password;
    @SysValue(value="${bee.db.schemaName}")
    String schemaName;
    @SysValue(value="${bee.db.jndiType}")
    boolean jndiType;
    @SysValue(value="${bee.db.jndiName}")
    String jndiName;
    @SysValue(value="${bee.db.pagingWithLimitOffset}")
    boolean pagingWithLimitOffset;
    @SysValue(value="${bee.osql.cache.timeout}")
    public int cache_timeout = 30000;
    @SysValue(value="${bee.osql.cache.mapSize}")
    int cache_mapSize = 20000;
    @SysValue(value="${bee.osql.cache.startDeleteRate}")
    public Double cache_startDeleteRate = 0.6;
    @SysValue(value="${bee.osql.cache.fullUsedRate}")
    Double cache_fullUsedRate = 0.8;
    @SysValue(value="${bee.osql.cache.fullClearRate}")
    Double cache_fullClearRate = 0.2;
    @SysValue(value="${bee.osql.cache.keyUseMD5}")
    boolean cache_keyUseMD5 = true;
    @SysValue(value="${bee.osql.cache.nocache}")
    boolean cache_nocache;
    @SysValue(value="${bee.osql.cache.workResultSetSize}")
    int cache_workResultSetSize = 300;
    @SysValue(value="${bee.osql.cache.never}")
    String cache_never;
    @SysValue(value="${bee.osql.cache.forever}")
    String cache_forever;
    @SysValue(value="${bee.osql.cache.modifySyn}")
    String cache_modifySyn;
    @SysValue(value="${bee.osql.cache.prototype}")
    public int cache_prototype = 1;
    @SysValue(value="${bee.osql.cache.useLevelTwo}")
    public boolean cache_useLevelTwo;
    @SysValue(value="${bee.osql.cache.levelOneTolevelTwo}")
    public boolean cache_levelOneTolevelTwo;
    @SysValue(value="${bee.osql.cache.levelTwoTimeout}")
    public int cache_levelTwoTimeout = 180;
    @SysValue(value="${bee.osql.cache.levelTwoEntityList}")
    public String cache_levelTwoEntityList;
    @SysValue(value="${bee.osql.cacheRedis.host}")
    public String cacheRedis_host;
    @SysValue(value="${bee.osql.cacheRedis.port}")
    public Integer cacheRedis_port;
    @SysValue(value="${bee.osql.cacheRedis.password}")
    public String cacheRedis_password;
    @SysValue(value="${bee.osql.cacheRedis.connectionTimeout}")
    public Integer cacheRedis_connectionTimeout = 10;
    @SysValue(value="${bee.osql.cacheRedis.soTimeout}")
    public Integer cacheRedis_soTimeout = 10;
    @SysValue(value="${bee.osql.cacheRedis.database}")
    public Integer cacheRedis_database;
    @SysValue(value="${bee.osql.cacheRedis.clientName}")
    public String cacheRedis_clientName;
    @SysValue(value="${bee.osql.cacheRedis.ssl}")
    public boolean cacheRedis_ssl;
    @SysValue(value="${bee.distribution.genid.workerid}")
    public int genid_workerid = 0;
    @SysValue(value="${bee.distribution.genid.generatorType}")
    public int genid_generatorType = 1;
    @SysValue(value="${bee.distribution.genid.forAllTableLongId}")
    public boolean genid_forAllTableLongId;
    @SysValue(value="${bee.distribution.genid.replaceOldId}")
    public boolean genid_replaceOldId = true;
    @SysValue(value="${bee.distribution.genid.includesEntityList}")
    public String genid_includesEntityList;
    @SysValue(value="${bee.distribution.genid.excludesEntityList}")
    public String genid_excludesEntityList;
    @SysValue(value="${bee.distribution.genid.startYear}")
    public int genid_startYear = 0;
    @SysValue(value="${bee.distribution.pearFlowerId.tolerateSecond}")
    public long pearFlowerId_tolerateSecond = 10L;
    @SysValue(value="${bee.distribution.pearFlowerId.useHalfWorkId}")
    public boolean pearFlowerId_useHalfWorkId;
    @SysValue(value="${bee.distribution.pearFlowerId.switchWorkIdTimeThreshold}")
    public long pearFlowerId_switchWorkIdTimeThreshold = 120L;
    @SysValue(value="${bee.distribution.pearFlowerId.randomNumBound}")
    public int pearFlowerId_randomNumBound = 2;
    @SysValue(value="${bee.dosql.multiDS.enable}")
    public boolean multiDS_enable;
    @SysValue(value="${bee.dosql.multiDS.type}")
    public int multiDS_type;
    @SysValue(value="${bee.dosql.multiDS.defalutDS}")
    public String multiDS_defalutDS;
    @SysValue(value="${bee.dosql.multiDS.writeDB}")
    public String multiDS_writeDB;
    @SysValue(value="${bee.dosql.multiDS.readDB}")
    public String multiDS_readDB;
    @SysValue(value="${bee.dosql.multiDS.rDbRouteWay}")
    public int multiDS_rDbRouteWay;
    @SysValue(value="${bee.dosql.multiDS.matchEntityClassPath}")
    public String multiDS_matchEntityClassPath = "";
    @SysValue(value="${bee.dosql.multiDS.matchTable}")
    public String multiDS_matchTable = "";
    @SysValue(value="${bee.dosql.multiDS.differentDbType}")
    public boolean multiDS_differentDbType;
    @SysValue(value="${bee.dosql.multiDS.sharding}")
    public boolean multiDS_sharding;
    @SysValue(value="${bee.dosql.sharding.forkJoinBatchInsert}")
    public boolean sharding_forkJoinBatchInsert;
    @SysValue(value="${bee.dosql.sharding.jdbcStreamSelect}")
    public boolean sharding_jdbcStreamSelect = true;
    @SysValue(value="${bee.dosql.sharding.notSupportUnionQuery}")
    public boolean notSupportUnionQuery;
    private static boolean alreadyPrintDbName;
    private static boolean changeDataSource;

    private HoneyConfig() {
    }

    private static void printVersion() {
        Logger.info("[Bee] -------- Bee    2.0 -------- ");
        Logger.info("[Bee] -------- Honey  2.0 -------- ");
        try {
            Class.forName("org.teasoft.beex.util.BeeExtVersion");
        }
        catch (Exception e) {
            Logger.debug("[Bee] ========= Bee    buildId  2.0.2.14");
            Logger.debug("[Bee] ========= Honey  buildId  2.0.2.14");
        }
    }

    public static HoneyConfig getHoneyConfig() {
        return honeyConfig;
    }

    private void init() {
        SysValueProcessor.process(honeyConfig);
        BeeActiveProp beeActiveProp = null;
        if (this.type == 1 || this.type == 2) {
            if (StringUtils.isBlank(this.active)) {
                String msg = "The value of bee.profiles.active is empty!";
                Logger.error(msg, (Throwable)new ConfigWrongException(msg));
            } else {
                String fileName = "/bee-{active}.properties".replace("{active}", this.active);
                beeActiveProp = new BeeActiveProp(fileName);
                if (this.type == 1) {
                    SysValueProcessor.process(honeyConfig, beeActiveProp);
                } else if (this.type == 2) {
                    HoneyConfig._setHoneyConfig();
                    SysValueProcessor.process(honeyConfig, beeActiveProp);
                }
            }
        }
        if (this.isAndroid || this.isHarmony) {
            this.dbName = "SQLite";
            DbFeatureRegistry.register((String)"SQLite", (DbFeature)new LimitOffsetPaging());
        }
        HoneyContext.initLoad();
    }

    public void resetBeeProperties(String folderPath) {
        try {
            BeeProp.resetBeeProperties(folderPath);
            HoneyConfig._setHoneyConfig();
            honeyConfig.init();
            LoggerFactory.setConfigRefresh(true);
            Logger.warn("[Bee] ========= reset the bee.properties with folderPath:" + folderPath);
        }
        catch (Exception e) {
            Logger.warn(e.getMessage());
        }
    }

    public void resetBeeProperties(InputStream inputStream) {
        try {
            BeeProp.resetBeeProperties(inputStream);
            HoneyConfig._setHoneyConfig();
            honeyConfig.init();
            LoggerFactory.setConfigRefresh(true);
            Logger.warn("[Bee] ========= reset the bee.properties by inputStream");
        }
        catch (Exception e) {
            Logger.warn(e.getMessage());
        }
    }

    private static void _setHoneyConfig() {
        honeyConfig = new HoneyConfig();
    }

    public String getDbName() {
        String dsName;
        HoneyConfig.checkAndRefreshDbNameForSingleDs();
        if (HoneyContext.isNeedRealTimeDb() && (dsName = Router.getDsName()) != null && HoneyContext.getDsName2DbName() != null) {
            String temp_dbName = HoneyContext.getDsName2DbName().get(dsName);
            if (temp_dbName == null) {
                throw new ConfigWrongException("Did not find the dataSource name : " + dsName);
            }
            return temp_dbName;
        }
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
        Logger.info("[Bee] ========= reset the dbName in HoneyConfig is :" + dbName);
        BeeFactory.getHoneyFactory().setDbFeature(null);
    }

    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public void setDatabaseMajorVersion(int databaseMajorVersion) {
        this.databaseMajorVersion = databaseMajorVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkAndRefreshDbNameForSingleDs() {
        if (!HoneyConfig.getHoneyConfig().multiDS_enable && (HoneyConfig.getHoneyConfig().dbName == null || changeDataSource)) {
            Connection conn = null;
            try {
                conn = SessionFactory.getConnection();
                if (conn == null) return;
                String newDbName = conn.getMetaData().getDatabaseProductName();
                HoneyConfig.getHoneyConfig().setDatabaseMajorVersion(0);
                if ("Microsoft SQL Server".equalsIgnoreCase(newDbName)) {
                    int majorVersion = conn.getMetaData().getDatabaseMajorVersion();
                    HoneyConfig.getHoneyConfig().setDatabaseMajorVersion(majorVersion);
                    if (majorVersion >= 11) {
                        DbFeatureRegistry.register((String)"Microsoft SQL Server", (DbFeature)new SqlServerFeature2012());
                    }
                } else if (newDbName.contains("Microsoft Access")) {
                    Logger.debug("Transform the dbName:'" + newDbName + "' to '" + "Microsoft Access" + "'");
                    newDbName = "Microsoft Access";
                }
                if (changeDataSource) {
                    HoneyConfig.getHoneyConfig().setDbName(newDbName);
                } else {
                    HoneyConfig.getHoneyConfig().dbName = newDbName;
                }
                String logMsg = "[Bee] ========= get the dbName from the Connection is :" + HoneyConfig.getHoneyConfig().dbName;
                Logger.info(logMsg);
                alreadyPrintDbName = true;
                return;
            }
            catch (Exception e) {
                Logger.warn("Can not get the Connection when check the dbName.  \n" + e.getMessage(), e);
                return;
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception e2) {
                    Logger.error(e2.getMessage(), e2);
                }
                if (alreadyPrintDbName && changeDataSource) {
                    changeDataSource = false;
                    HoneyUtil.refreshSetParaAndResultTypeHandlerRegistry();
                }
            }
        }
        if (alreadyPrintDbName) return;
        Logger.info("[Bee] ========= get the dbName from HoneyConfig is :" + HoneyConfig.getHoneyConfig().dbName);
        alreadyPrintDbName = true;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setUrl(String url) {
        HoneyConfig.setChangeDataSource(true);
        this.url = url;
    }

    static void setChangeDataSource(boolean flag) {
        changeDataSource = true;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getUrl() {
        if (StringUtils.isNotBlank(this.password) && this.url != null && this.url.startsWith("jdbc:ucanaccess:") && !this.url.contains("jackcessOpener=")) {
            this.url = this.url + ";jackcessOpener=org.teasoft.beex.access.BeeAccessCryptOpener";
            return this.url;
        }
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getLoggerType() {
        return this.loggerType;
    }

    public void setLoggerType(String loggerType) {
        this.loggerType = loggerType;
        LoggerFactory.setConfigRefresh(true);
    }

    static {
        honeyConfig = new HoneyConfig();
        honeyConfig.init();
        HoneyConfig.printVersion();
        alreadyPrintDbName = false;
        changeDataSource = false;
    }
}

