/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import org.teasoft.bee.osql.NameTranslate;
import org.teasoft.bee.osql.annotation.ColumnHandler;
import org.teasoft.bee.osql.annotation.Entity;
import org.teasoft.bee.osql.exception.BeeErrorNameException;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.TokenUtil;
import org.teasoft.honey.osql.util.AnnoUtil;
import org.teasoft.honey.osql.util.NameCheckUtil;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.config.ShardingRegistry;
import org.teasoft.honey.util.StringUtils;

public class NameTranslateHandle {
    private static NameTranslate nameTranslate = BeeFactory.getHoneyFactory().getInitNameTranslate();
    private static ConcurrentMap<String, String> entity2tableMap;
    private static ConcurrentMap<String, String> table2entityMap;
    private static ColumnHandler columnHandler;
    private static String schemaName;

    private NameTranslateHandle() {
    }

    public static void setNameTranslate(NameTranslate nameTranslate) {
        HoneyContext.clearFieldNameCache();
        NameTranslateHandle.nameTranslate = nameTranslate;
    }

    public static NameTranslate getNameTranslate() {
        NameTranslate nameTranslate1 = HoneyContext.getCurrentNameTranslate();
        if (nameTranslate1 != null) {
            return nameTranslate1;
        }
        return nameTranslate;
    }

    public static ColumnHandler getColumnHandler() {
        return columnHandler;
    }

    public static void setColumnHandler(ColumnHandler columnHandler) {
        NameTranslateHandle.columnHandler = columnHandler;
    }

    public static String getSchemaName() {
        return schemaName;
    }

    public static void setSchemaName(String schemaName) {
        NameTranslateHandle.checkSchemaName(schemaName);
        NameTranslateHandle.schemaName = schemaName;
    }

    private static void checkSchemaName(String schemaName) {
        if (NameCheckUtil.isIllegal(schemaName)) {
            throw new BeeErrorNameException("The schemaName: '" + schemaName + "' is illegal!");
        }
    }

    public static String getSchemaNameLocal() {
        return HoneyContext.getSysCommStrLocal("_SYS_Bee_SchemaName");
    }

    public static void setSchemaNameLocal(String schemaNameLocal) {
        NameTranslateHandle.checkSchemaName(schemaNameLocal);
        HoneyContext.setSysCommStrLocal("_SYS_Bee_SchemaName", schemaNameLocal);
    }

    public static String toTableName(String entityName) {
        String tableName = NameTranslateHandle._toTableName(entityName);
        if (ShardingUtil.isSharding() && ShardingRegistry.isBroadcastTab(tableName)) {
            return tableName;
        }
        if (ShardingUtil.hadSharding()) {
            return tableName + "[$#(index)#$]";
        }
        if (tableName.indexOf(46) == -1) {
            if (StringUtils.isNotBlank(NameTranslateHandle.getSchemaNameLocal())) {
                tableName = NameTranslateHandle.getSchemaNameLocal() + "." + tableName;
            } else if (StringUtils.isNotBlank(NameTranslateHandle.getSchemaName())) {
                tableName = NameTranslateHandle.getSchemaName() + "." + tableName;
            }
        }
        return tableName;
    }

    private static String _toTableName(String entityName) {
        String tableName;
        try {
            String appointTab = HoneyContext.getAppointTab();
            if (StringUtils.isNotBlank(appointTab)) {
                return appointTab;
            }
            if (!OneTimeParameter.isTrue("_SYS_Bee_DoNotCheckAnnotation")) {
                Entity entity;
                Class<?> obj = Class.forName(entityName);
                if (AnnoUtil.isTable(obj)) {
                    String tabName = NameTranslateHandle.processAutoPara(AnnoUtil.getValue(obj));
                    if (NameCheckUtil.isIllegal(tabName)) {
                        throw new BeeIllegalParameterException("Annotation Table set wrong value:" + tabName);
                    }
                    return tabName;
                }
                if (obj.isAnnotationPresent(Entity.class) && NameCheckUtil.isIllegal(entityName = NameTranslateHandle.processAutoPara((entity = obj.getAnnotation(Entity.class)).value()))) {
                    throw new BeeIllegalParameterException("Annotation Entity set wrong value:" + entityName);
                }
            }
        }
        catch (ClassNotFoundException e) {
            if (entityName != null && !entityName.contains(".")) {
                Logger.info("In NameTranslateHandle,ClassNotFoundException : " + e.getMessage());
            }
            Logger.warn("In NameTranslateHandle,ClassNotFoundException : " + e.getMessage());
        }
        if (entityName == null) {
            entityName = "";
        }
        if ((tableName = (String)entity2tableMap.get(entityName)) != null && !"".equals(tableName.trim())) {
            return tableName;
        }
        int index = entityName.lastIndexOf(46);
        if (index > 0 && (tableName = (String)entity2tableMap.get(entityName = entityName.substring(index + 1))) != null && !"".equals(tableName.trim())) {
            return tableName;
        }
        String returnTableName = NameTranslateHandle.getNameTranslate().toTableName(entityName);
        String tabSuffix = HoneyContext.getTabSuffix();
        if (StringUtils.isNotBlank(tabSuffix)) {
            returnTableName = returnTableName + tabSuffix;
        }
        return returnTableName;
    }

    public static String toColumnName(String fieldName) {
        return NameTranslateHandle.getNameTranslate().toColumnName(fieldName);
    }

    public static String toColumnName(String fieldName, Class entityClass) {
        String defineColumn;
        if (fieldName == null) {
            return null;
        }
        boolean openDefineColumn = HoneyConfig.getHoneyConfig().openDefineColumn;
        if (openDefineColumn && entityClass != null && NameTranslateHandle.getColumnHandler() != null && (defineColumn = NameTranslateHandle.getColumnHandler().toColumnName(fieldName, entityClass)) != null) {
            return defineColumn;
        }
        return NameTranslateHandle.getNameTranslate().toColumnName(fieldName);
    }

    public static synchronized String toEntityName(String tableName) {
        String entityName;
        if (table2entityMap == null) {
            table2entityMap = HoneyContext.getTable2entityMap();
        }
        if (tableName == null) {
            tableName = "";
        }
        if ((entityName = (String)table2entityMap.get(tableName)) != null && !"".equals(entityName.trim())) {
            return entityName;
        }
        return NameTranslateHandle.getNameTranslate().toEntityName(tableName);
    }

    public static String toFieldName(String columnName) {
        return NameTranslateHandle.getNameTranslate().toFieldName(columnName);
    }

    public static String toFieldName(String columnName, Class entityClass) {
        String fieldName;
        boolean openDefineColumn = HoneyConfig.getHoneyConfig().openDefineColumn;
        if (openDefineColumn && entityClass != null && NameTranslateHandle.getColumnHandler() != null && (fieldName = NameTranslateHandle.getColumnHandler().toFieldName(columnName, entityClass)) != null) {
            return fieldName;
        }
        return NameTranslateHandle.getNameTranslate().toFieldName(columnName);
    }

    private static String processAutoPara(String autoPara) {
        int start = autoPara.indexOf("${");
        int end = autoPara.indexOf(125);
        if (start > 0 && end > 0 && start + 2 < end) {
            String key = autoPara.substring(start + 2, end);
            HashMap<String, String> map = new HashMap<String, String>();
            String value = (String)OneTimeParameter.getAttribute(key);
            if (value == null) {
                Logger.warn("Auto table: parameter  ${" + key + "} in " + autoPara + " still has not value, will be ignore it!");
                value = "";
            }
            map.put(key, value);
            return TokenUtil.processWithMap(autoPara, "${", "}", map);
        }
        return autoPara;
    }

    static {
        table2entityMap = null;
        entity2tableMap = HoneyContext.getEntity2tableMap();
        String sName = HoneyConfig.getHoneyConfig().getSchemaName();
        if (StringUtils.isNotBlank(sName)) {
            schemaName = sName;
        }
    }
}

