/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.config.ShardingRegistry;
import org.teasoft.honey.util.StringUtils;

public class SimpleRewriteSql {
    public static List<String[]> createSqlsAndInit(String sql) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        List<String> tabNameList = HoneyContext.getListLocal("_SYS_Bee_TabNameListLocal");
        List<String> tabSuffixList = HoneyContext.getListLocal("_SYS_Bee_TabSuffixListLocal");
        Map<String, String> tab2DsMap = HoneyContext.getCustomMapLocal("_SYS_Bee_ShardingTab2DsMap");
        List<PreparedValue> listValue = HoneyContext.justGetPreparedValue(sql);
        SimpleRewriteSql._createSql(list, tabSuffixList, sql, listValue, tabNameList, tab2DsMap);
        return list;
    }

    static void _createSql(List<String[]> list, List<String> tabSuffixList, String sql, List<PreparedValue> listValue, List<String> tabNameList, Map<String, String> tab2DsMap) {
        String[] sqls = new String[tabSuffixList.size()];
        String[] dsArray = new String[tabSuffixList.size()];
        for (int i = 0; i < tabSuffixList.size(); ++i) {
            String dsName;
            sqls[i] = sql.replace("[$#(index)#$]", tabSuffixList.get(i));
            HoneyContext.setPreparedValue(sqls[i], listValue);
            dsArray[i] = dsName = ShardingUtil.findDs(tab2DsMap, tabSuffixList.get(i), tabNameList.get(i));
        }
        list.add(sqls);
        list.add(dsArray);
    }

    public static List<String[]> createSqlsForFull(String sql, Class entityClass) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String tableName = SimpleRewriteSql._toTableName(entityClass);
        String baseTableName = tableName.replace("[$#(index)#$]", "");
        List<PreparedValue> listValue = HoneyContext.justGetPreparedValue(sql);
        SimpleRewriteSql._createSqlsForFull(list, sql, listValue, baseTableName);
        return list;
    }

    static void _createSqlsForFull(List<String[]> list, String sql, List<PreparedValue> listValue, String baseTableName) {
        ArrayList<String> sqlList = new ArrayList<String>();
        ArrayList<String> dsList = new ArrayList<String>();
        Map<String, Set<String>> map = ShardingRegistry.getFullNodes(baseTableName);
        boolean justSomeDs = ShardingUtil.hadShardingSomeDsFullSelect();
        List<String> dsNameList = HoneyContext.getListLocal("_SYS_Bee_DsNameListLocal");
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            String dsName = entry.getKey();
            if (justSomeDs && !SimpleRewriteSql.isContain(dsNameList, dsName)) continue;
            Set<String> tabIndexSet = entry.getValue();
            for (String tabIndex : tabIndexSet) {
                String tempSql = sql.replace("[$#(index)#$]", tabIndex);
                sqlList.add(tempSql);
                dsList.add(dsName);
                HoneyContext.setPreparedValue(tempSql, listValue);
            }
        }
        String[] sqls = StringUtils.listToArray(sqlList);
        String[] dsArray = StringUtils.listToArray(dsList);
        list.add(sqls);
        list.add(dsArray);
    }

    private static boolean isContain(List<String> dsNameList, String check) {
        for (int i = 0; i < dsNameList.size(); ++i) {
            if (!check.equalsIgnoreCase(dsNameList.get(i))) continue;
            return true;
        }
        return false;
    }

    private static String _toTableName(Class entityClass) {
        return NameTranslateHandle.toTableName(entityClass.getName());
    }
}

