/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.annotation.customizable.Json;
import org.teasoft.bee.osql.type.TypeHandler;
import org.teasoft.bee.sharding.ShardingSortStruct;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.JsonResultWrap;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.type.TypeHandlerRegistry;
import org.teasoft.honey.osql.util.AnnoUtil;
import org.teasoft.honey.sharding.ShardingUtil;

public class TransformResultSet {
    private static boolean openFieldTypeHandler = HoneyConfig.getHoneyConfig().openFieldTypeHandler;

    private TransformResultSet() {
    }

    public static JsonResultWrap toJson(ResultSet rs, Class entityClass) throws SQLException {
        StringBuffer json = new StringBuffer("");
        ResultSetMetaData rmeta = rs.getMetaData();
        int columnCount = rmeta.getColumnCount();
        boolean ignoreNull = HoneyConfig.getHoneyConfig().selectJson_ignoreNull;
        String temp = "";
        boolean dateWithMillisecond = HoneyConfig.getHoneyConfig().selectJson_dateWithMillisecond;
        boolean timeWithMillisecond = HoneyConfig.getHoneyConfig().selectJson_timeWithMillisecond;
        boolean timestampWithMillisecond = HoneyConfig.getHoneyConfig().selectJson_timestampWithMillisecond;
        boolean longToString = HoneyConfig.getHoneyConfig().selectJson_longToString;
        int rowCount = 0;
        boolean isJsonString = false;
        Field currField = null;
        String fieldName = "";
        String fieldTypeName = "";
        while (rs.next()) {
            ++rowCount;
            json.append(",{");
            for (int i = 1; i <= columnCount; ++i) {
                if (rs.getString(i) == null && ignoreNull) continue;
                isJsonString = false;
                fieldName = TransformResultSet._toFieldName(rmeta.getColumnName(i), entityClass);
                fieldTypeName = HoneyUtil.getFieldType(rmeta.getColumnTypeName(i));
                json.append("\"");
                json.append(fieldName);
                json.append("\":");
                if (rs.getString(i) != null) {
                    temp = rs.getString(i);
                    if ("JSON".equals(fieldTypeName)) {
                        isJsonString = true;
                    } else if (entityClass != null) {
                        try {
                            currField = entityClass.getDeclaredField(fieldName);
                            isJsonString = TransformResultSet.isJoson(currField);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                    if (isJsonString) {
                        json.append(temp);
                    } else if ("String".equals(fieldTypeName)) {
                        json.append("\"");
                        temp = temp.replace("\\", "\\\\");
                        temp = temp.replace("\"", "\\\"");
                        json.append(temp);
                        json.append("\"");
                    } else if ("Date".equals(fieldTypeName)) {
                        if (dateWithMillisecond) {
                            json.append(rs.getDate(i).getTime());
                        } else {
                            try {
                                Long.valueOf(temp);
                                json.append(temp);
                            }
                            catch (NumberFormatException e) {
                                json.append("\"");
                                json.append(temp.replace("\"", "\\\""));
                                json.append("\"");
                            }
                        }
                    } else if ("Time".equals(fieldTypeName)) {
                        if (timeWithMillisecond) {
                            json.append(rs.getTime(i).getTime());
                        } else {
                            try {
                                Long.valueOf(temp);
                                json.append(temp);
                            }
                            catch (NumberFormatException e) {
                                json.append("\"");
                                json.append(temp.replace("\"", "\\\""));
                                json.append("\"");
                            }
                        }
                    } else if ("Timestamp".equals(fieldTypeName)) {
                        if (timestampWithMillisecond) {
                            json.append(rs.getTimestamp(i).getTime());
                        } else {
                            try {
                                Long.valueOf(temp);
                                json.append(temp);
                            }
                            catch (NumberFormatException e) {
                                json.append("\"");
                                json.append(temp.replace("\"", "\\\""));
                                json.append("\"");
                            }
                        }
                    } else if (longToString && "Long".equals(fieldTypeName)) {
                        json.append("\"");
                        json.append(rs.getString(i));
                        json.append("\"");
                    } else {
                        json.append(rs.getString(i));
                    }
                } else {
                    json.append(rs.getString(i));
                }
                if (i == columnCount) continue;
                json.append(",");
            }
            if (json.toString().endsWith(",")) {
                json.deleteCharAt(json.length() - 1);
            }
            json.append("}");
        }
        if (json.length() > 0) {
            json.deleteCharAt(0);
        }
        json.insert(0, "[");
        json.append("]");
        JsonResultWrap wrap = new JsonResultWrap();
        wrap.setResultJson(json.toString());
        wrap.setRowCount(rowCount);
        return wrap;
    }

    private static String _toFieldName(String columnName, Class entityClass) {
        return NameTranslateHandle.toFieldName(columnName, entityClass);
    }

    public static List<String[]> toStringsList(ResultSet rs) throws SQLException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        ResultSetMetaData rmeta = rs.getMetaData();
        int columnCount = rmeta.getColumnCount();
        boolean nullToEmptyString = HoneyConfig.getHoneyConfig().returnStringList_nullToEmptyString;
        String[] str = null;
        boolean firstRow = true;
        while (rs.next()) {
            str = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                str[i] = nullToEmptyString && rs.getString(i + 1) == null ? "" : rs.getString(i + 1);
                if (!firstRow) continue;
                firstRow = false;
                TransformResultSet.regSort(rmeta);
            }
            list.add(str);
        }
        return list;
    }

    static void regSort(ResultSetMetaData rmeta) {
        if (!ShardingUtil.hadSharding()) {
            return;
        }
        ShardingSortStruct struct = HoneyContext.getCurrentShardingSort();
        if (struct == null) {
            return;
        }
        String[] orderFields = struct.getOrderFields();
        if (orderFields == null) {
            return;
        }
        if (struct.isRegFlag()) {
            return;
        }
        struct.setRegFlag(true);
        int orderFieldsLen = orderFields.length;
        String[] type = new String[orderFieldsLen];
        int[] index = new int[orderFieldsLen];
        try {
            int k = 0;
            int columnCount = rmeta.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                String fieldName = TransformResultSet._toFieldName(rmeta.getColumnName(i + 1), null);
                for (int j = 0; j < orderFieldsLen; ++j) {
                    String javaType;
                    if (!fieldName.equals(orderFields[j])) continue;
                    type[j] = javaType = HoneyUtil.getFieldType(rmeta.getColumnTypeName(i + 1).trim());
                    index[k] = i;
                    ++k;
                    break;
                }
                if (k == orderFieldsLen) break;
            }
            if (k != 0) {
                struct.setIndex(index);
                struct.setType(type);
                HoneyContext.setCurrentShardingSort(struct);
            }
        }
        catch (SQLException e) {
            Logger.debug(e.getMessage(), e);
        }
    }

    public static List<Map<String, Object>> toMapList(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData rmeta = rs.getMetaData();
        int columnCount = rmeta.getColumnCount();
        LinkedHashMap<String, Object> rowMap = null;
        while (rs.next()) {
            rowMap = new LinkedHashMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                rowMap.put(TransformResultSet._toFieldName(rmeta.getColumnName(i), null), rs.getObject(i));
            }
            list.add(rowMap);
        }
        return list;
    }

    private static boolean isJoson(Field field) {
        return AnnoUtil.isJson(field);
    }

    private static Object jsonHandlerProcess(Field field, Object obj, TypeHandler jsonHandler) {
        if (List.class.isAssignableFrom(field.getType())) {
            Object[] newObj = new Object[]{obj, field};
            obj = jsonHandler.process(field.getType(), (Object)newObj);
        } else {
            obj = jsonHandler.process(field.getType(), obj);
        }
        return obj;
    }

    private static Object _getObjectByindex(ResultSet rs, Field field, int index) throws SQLException {
        return HoneyUtil.getResultObjectByIndex(rs, field.getType().getName(), index);
    }

    public static <T> T rowToEntity(ResultSet rs, Class<T> clazz) throws SQLException, IllegalAccessException, InstantiationException {
        T targetObj = null;
        targetObj = clazz.newInstance();
        ResultSetMetaData rmeta = rs.getMetaData();
        if (rs.isBeforeFirst()) {
            rs.next();
        }
        int columnCount = rmeta.getColumnCount();
        Field field = null;
        String name = null;
        boolean firstRow = true;
        for (int i = 0; i < columnCount; ++i) {
            try {
                name = TransformResultSet._toFieldName(rmeta.getColumnName(i + 1), clazz);
                field = clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            if (firstRow) {
                firstRow = false;
                TransformResultSet.regSort(rmeta);
            }
            field.setAccessible(true);
            Object obj = null;
            boolean isRegHandlerPriority = false;
            try {
                boolean processAsJson = false;
                if (TransformResultSet.isJoson(field)) {
                    obj = rs.getString(i + 1);
                    TypeHandler<Json> jsonHandler = TypeHandlerRegistry.getHandler(Json.class);
                    if (jsonHandler != null) {
                        obj = TransformResultSet.jsonHandlerProcess(field, obj, jsonHandler);
                        processAsJson = true;
                    }
                } else if (openFieldTypeHandler) {
                    isRegHandlerPriority = TypeHandlerRegistry.isPriorityType(field.getType());
                }
                if (!processAsJson) {
                    obj = rs.getObject(i + 1);
                }
                if (isRegHandlerPriority) {
                    obj = TypeHandlerRegistry.handlerProcess(field.getType(), obj);
                }
                field.set(targetObj, obj);
                continue;
            }
            catch (IllegalArgumentException e) {
                Class<?> type;
                TypeHandler<?> handler;
                boolean alreadyProcess = false;
                obj = TransformResultSet._getObjectByindex(rs, field, i + 1);
                if (openFieldTypeHandler && (handler = TypeHandlerRegistry.getHandler(type = field.getType())) != null) {
                    try {
                        Object newObj = handler.process(type, obj);
                        field.set(targetObj, newObj);
                        alreadyProcess = true;
                    }
                    catch (Exception e2) {
                        alreadyProcess = false;
                    }
                }
                if (alreadyProcess) continue;
                field.set(targetObj, obj);
            }
        }
        return targetObj;
    }
}

