/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.interccept.annotation;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.annotation.AbstractDictI18nDefaultHandler;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.util.StringUtils;

public class DictI18nDefaultHandler
extends AbstractDictI18nDefaultHandler {
    private static Map<String, Map> dictMap = new HashMap<String, Map>();
    static String CommTableName = "_comm";
    static boolean useCommTabl = true;

    private String getLang() {
        String lang = HoneyConfig.getHoneyConfig().lang;
        if (StringUtils.isBlank(lang)) {
            lang = "CN";
        }
        return lang;
    }

    public Map getDictMap() {
        return dictMap;
    }

    public static void setDictMap(Map<String, Map> dictMap) {
        DictI18nDefaultHandler._setDictMap(dictMap);
    }

    public static void addMap(Map<String, Map> map) {
        DictI18nDefaultHandler._addDictMap(map);
    }

    private static void _setDictMap(Map<String, Map> dictMap) {
        DictI18nDefaultHandler.dictMap = dictMap;
    }

    private static void _addDictMap(Map<String, Map> dictMap) {
        DictI18nDefaultHandler.dictMap.putAll(dictMap);
    }

    public void process(Field field, List list) {
        try {
            Object obj0 = list.get(0);
            String tableName = DictI18nDefaultHandler._toTableName(obj0).toLowerCase();
            String fieldName = field.getName();
            String columnName = DictI18nDefaultHandler._toColumnName(fieldName, obj0.getClass());
            Map pairMap = new HashMap();
            Map langMap = null;
            try {
                langMap = (Map)this.getDictMap().get(this.getLang());
                if (langMap == null) {
                    Logger.warn("Can not find the Dict Map in lang: " + this.getLang());
                    return;
                }
                pairMap = (Map)langMap.get(tableName + ":" + columnName);
                if (pairMap == null && useCommTabl) {
                    pairMap = (Map)langMap.get(CommTableName + ":" + columnName);
                }
            }
            catch (Exception e) {
                String simpleName = obj0.getClass().getSimpleName().toLowerCase();
                String fname = field.getName();
                Logger.warn("In language:" + this.getLang() + ", can not find the dict map(entityName:fieldName):" + simpleName + ":" + fname, e);
                Logger.warn("In language:" + this.getLang() + ",  can not find the dict map(tableName:columnName):" + tableName + ":" + columnName, e);
            }
            if (langMap == null || pairMap == null) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                Map commPairMap = null;
                Object obj = list.get(i);
                Field f = obj.getClass().getDeclaredField(field.getName());
                f.setAccessible(true);
                Object value = f.get(obj);
                String v = (String)pairMap.get((String)value);
                if (v != null) {
                    f.set(obj, v);
                    continue;
                }
                if (useCommTabl) {
                    commPairMap = (Map)langMap.get(CommTableName + ":" + columnName);
                }
                if (commPairMap == null || (v = (String)commPairMap.get((String)value)) == null) continue;
                f.set(obj, v);
            }
        }
        catch (Exception e) {
            Logger.warn(e.getMessage(), e);
        }
    }

    private static String _toColumnName(String fieldName, Class entityClass) {
        return NameTranslateHandle.toColumnName(fieldName, entityClass);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }
}

