/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.teasoft.bee.osql.exception.ConfigWrongException;
import org.teasoft.honey.osql.core.Logger;

public class PropertiesReader {
    private Properties prop;

    public PropertiesReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesReader(String fileName) {
        InputStream in = null;
        try {
            if (!fileName.trim().startsWith("/")) {
                fileName = "/" + fileName.trim();
            }
            this.prop = new Properties();
            in = PropertiesReader.class.getResourceAsStream(fileName);
            this.prop.load(in);
        }
        catch (IOException | NullPointerException e) {
            try {
                Logger.warn("  In PropertiesReader not found the file :" + fileName + " .  exception message:" + e.getMessage());
                this.closeStream(in);
            }
            catch (Throwable throwable) {
                this.closeStream(in);
                throw throwable;
            }
        }
        this.closeStream(in);
    }

    public PropertiesReader(String filePathAndName, boolean custom) {
        FileInputStream in = null;
        try {
            this.prop = new Properties();
            in = new FileInputStream(new File(filePathAndName));
            this.prop.load(in);
        }
        catch (IOException | NullPointerException e) {
            try {
                Logger.warn("  In PropertiesReader not found the file :" + filePathAndName + "  .  " + e.getMessage());
                throw new ConfigWrongException("filePathAndName: " + filePathAndName + " config wrong!  " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.closeStream(in);
                throw throwable;
            }
        }
        this.closeStream(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesReader(InputStream inputStream) {
        InputStream in = null;
        try {
            this.prop = new Properties();
            in = inputStream;
            this.prop.load(in);
        }
        catch (IOException | NullPointerException e) {
            try {
                Logger.warn("  In PropertiesReader PropertiesReader(InputStream inputStream) : " + e.getMessage());
                this.closeStream(in);
            }
            catch (Throwable throwable) {
                this.closeStream(in);
                throw throwable;
            }
        }
        this.closeStream(in);
    }

    private void closeStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e2) {
            Logger.debug(e2.getMessage(), e2);
        }
    }

    public String getValue(String key) {
        return this.prop.getProperty(key);
    }

    public String getValueText(String key) {
        return this.prop.getProperty(key, "");
    }

    public String getValue(String key, String defaultValue) {
        return this.prop.getProperty(key, defaultValue);
    }

    public Set<String> getKeys() {
        return this.prop.stringPropertyNames();
    }
}

