/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.DsTabHandler;
import org.teasoft.bee.osql.annotation.MultiTenancy;
import org.teasoft.bee.sharding.DsTabStruct;
import org.teasoft.bee.sharding.ShardingSimpleStruct;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.sharding.DsTabDefaultHandler;
import org.teasoft.honey.util.StringUtils;

public class MultiTenancyHandlerController {
    private MultiTenancyHandlerController() {
    }

    public static DsTabStruct process(Field field, Object entity, SuidType sqlSuidType) {
        DsTabStruct dsTabStruct = null;
        try {
            MultiTenancy anno = field.getAnnotation(MultiTenancy.class);
            String appointDS = anno.appointDS();
            String appointTab = anno.appointTab();
            dsTabStruct = new DsTabStruct();
            boolean isAppoint = false;
            if (StringUtils.isNotBlank(appointDS)) {
                dsTabStruct.setDsName(appointDS);
                isAppoint = true;
            }
            if (StringUtils.isNotBlank(appointTab)) {
                dsTabStruct.setTabName(appointTab);
                isAppoint = true;
            }
            if (isAppoint) {
                return dsTabStruct;
            }
            field.setAccessible(true);
            Object tenancyValue = field.get(entity);
            ShardingSimpleStruct sharding = new ShardingSimpleStruct();
            sharding.setDsAlgorithm(anno.dsAlgorithm());
            sharding.setDsRule(anno.dsRule());
            sharding.setDsName(anno.dsName());
            sharding.setTabAlgorithm(anno.tabAlgorithm());
            sharding.setTabRule(anno.tabRule());
            sharding.setTabName(anno.tabName());
            sharding.setDsShardingValue(tenancyValue);
            sharding.setTabShardingValue(tenancyValue);
            Class c = anno.handler();
            if (c.equals(DsTabHandler.class)) {
                dsTabStruct = new DsTabDefaultHandler().process(sharding);
            } else if (!c.isInterface() && !Modifier.isAbstract(c.getModifiers())) {
                DsTabHandler obj = (DsTabHandler)c.newInstance();
                dsTabStruct = obj.process(sharding);
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
        }
        return dsTabStruct;
    }
}

