/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.DsTabHandler;
import org.teasoft.bee.osql.annotation.Sharding;
import org.teasoft.bee.sharding.DsTabStruct;
import org.teasoft.bee.sharding.ShardingSimpleStruct;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.sharding.DsTabDefaultHandler;
import org.teasoft.honey.util.StringUtils;

public class ShardingAnnoHandlerController {
    private ShardingAnnoHandlerController() {
    }

    public static DsTabStruct process(Field field, Object entity, SuidType sqlSuidType, ShardingSimpleStruct sharding0) {
        DsTabStruct dsTabStruct = null;
        try {
            Sharding anno = field.getAnnotation(Sharding.class);
            String appointDS = anno.appointDS();
            String appointTab = anno.appointTab();
            dsTabStruct = new DsTabStruct();
            boolean isAppointDs = false;
            boolean isAppointTab = false;
            if (StringUtils.isNotBlank(appointDS)) {
                dsTabStruct.setDsName(appointDS);
                isAppointDs = true;
            }
            if (StringUtils.isNotBlank(appointTab)) {
                dsTabStruct.setTabName(appointTab);
                isAppointTab = true;
            }
            if (isAppointTab) {
                return dsTabStruct;
            }
            field.setAccessible(true);
            Object shardingValue = field.get(entity);
            if (sharding0 == null) {
                sharding0 = new ShardingSimpleStruct();
            }
            sharding0.setDsAlgorithm(anno.dsAlgorithm());
            sharding0.setDsRule(anno.dsRule());
            if (!isAppointDs) {
                sharding0.setDsName(anno.dsName());
            }
            sharding0.setTabAlgorithm(anno.tabAlgorithm());
            sharding0.setTabRule(anno.tabRule());
            if (StringUtils.isNotBlank(anno.tabName())) {
                sharding0.setTabName(anno.tabName());
            }
            sharding0.setDsShardingValue(shardingValue);
            sharding0.setTabShardingValue(shardingValue);
            Class c = anno.handler();
            if (c.equals(DsTabHandler.class)) {
                dsTabStruct = new DsTabDefaultHandler().process(sharding0);
            } else if (!c.isInterface() && !Modifier.isAbstract(c.getModifiers())) {
                DsTabHandler obj = (DsTabHandler)c.newInstance();
                dsTabStruct = obj.process(sharding0);
            }
            if (isAppointDs) {
                if (dsTabStruct == null) {
                    dsTabStruct = new DsTabStruct();
                }
                dsTabStruct.setDsName(appointDS);
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
        }
        return dsTabStruct;
    }
}

