/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding;

import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.exception.ShardingErrorException;
import org.teasoft.bee.sharding.ShardingPageStruct;
import org.teasoft.bee.sharding.ShardingSortStruct;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.util.ObjectUtils;

public class ShardingReg {
    private static final String DoNotSetTabShadngValue = "Do not set the sharding value for table!";

    public static void regHadSharding() {
        ShardingUtil.setTrueInSysCommStrLocal("_SYS_Bee_HadSharding");
    }

    public static void regShardingManyTables(List<String> dsNameList, List<String> tabNameList, List<String> tabSuffixList, Map<String, String> tab2DsMap) {
        HoneyContext.setListLocal("_SYS_Bee_TabNameListLocal", tabNameList);
        HoneyContext.setListLocal("_SYS_Bee_TabSuffixListLocal", tabSuffixList);
        HoneyContext.setListLocal("_SYS_Bee_DsNameListLocal", dsNameList);
        HoneyContext.setCustomMapLocal("_SYS_Bee_ShardingTab2DsMap", tab2DsMap);
    }

    public static void regFullInModifyAllNodes(SuidType suidType) {
        if (suidType != SuidType.SELECT) {
            ShardingReg.setTrueInSysCommStrLocal("_SYS_Bee_ShardingFullSelect");
            ShardingReg.regHadSharding();
        }
    }

    public static void regFull(SuidType suidType) {
        if (suidType == SuidType.SELECT || suidType == SuidType.DELETE || suidType == SuidType.UPDATE) {
            ShardingReg.setTrueInSysCommStrLocal("_SYS_Bee_ShardingFullSelect");
            ShardingReg.regHadSharding();
        } else if (SuidType.INSERT == suidType) {
            ShardingReg.triggerDoNotSetTabShadngValueException();
        }
    }

    public static void regSomeDsFull(SuidType suidType) {
        ShardingReg.regFull(suidType);
        ShardingReg.setTrueInSysCommStrLocal("_SYS_Bee_ShardingSomeDsFullSelect");
    }

    public static void regShardingJustDs(List<String> dsNameList) {
        HoneyContext.setListLocal("_SYS_Bee_DsNameListLocal", dsNameList);
    }

    private static void triggerDoNotSetTabShadngValueException() {
        ShardingReg.clearContext();
        throw new ShardingErrorException(DoNotSetTabShadngValue);
    }

    public static void regBatchInsert(List<String> tabNameListForBatch, List<String> dsNameListForBatch) {
        HoneyContext.setListLocal("_SYS_Bee_TabNameListForBatchLocal", tabNameListForBatch);
        HoneyContext.setListLocal("_SYS_Bee_DsNameListForBatchLocal", dsNameListForBatch);
    }

    public static void regShadingPage(String beforeSql, String pagingSql, Integer start, Integer size) {
        if (size == null || start == null && size == null) {
            return;
        }
        if (ShardingUtil.hadSharding()) {
            ShardingPageStruct struct = new ShardingPageStruct();
            struct.setBeforeSql(beforeSql);
            struct.setPagingSql(pagingSql);
            if (start != null && start != -1) {
                struct.setStart(start);
            }
            struct.setSize(size);
            HoneyContext.setCurrentShardingPage(struct);
        }
    }

    public static void regShardingSort(String orderSql, String[] orderFields, OrderType[] orderTypes) {
        if (!ShardingUtil.hadSharding()) {
            return;
        }
        ShardingSortStruct struct = new ShardingSortStruct(orderSql, orderFields, orderTypes);
        HoneyContext.setCurrentShardingSort(struct);
    }

    public static void regShardingSort(ShardingSortStruct struct) {
        if (!ShardingUtil.hadSharding()) {
            return;
        }
        HoneyContext.setCurrentShardingSort(struct);
    }

    public static void regShardingSort(Map<String, String> orderByMap) {
        if (!ShardingUtil.hadSharding()) {
            return;
        }
        if (ObjectUtils.isEmpty(orderByMap)) {
            return;
        }
        ShardingReg.regShardingSort(ShardingUtil.parseOrderByMap(orderByMap));
    }

    public static void regMoreTableQuery() {
        ShardingReg.setTrueInSysCommStrLocal("_SYS_Bee_MoreTableQuery");
    }

    public static void regShardingBatchInsertDoing() {
        ShardingReg.setTrueInSysCommStrLocal("_SYS_Bee_ShardingBatchInsertDoing");
    }

    public static void clearContext() {
        if (!ShardingUtil.isSharding()) {
            return;
        }
        HoneyContext.removeConditionLocal();
        HoneyContext.removeSysCommStrLocal("_SYS_Bee_HadSharding");
        HoneyContext.removeSysCommStrLocal("_SYS_Bee_ShardingFullSelect");
        HoneyContext.removeSysCommStrLocal("_SYS_Bee_ShardingSomeDsFullSelect");
        HoneyContext.removeSysCommStrLocal("_SYS_Bee_HintDs");
        HoneyContext.removeSysCommStrLocal("_SYS_Bee_HintTab");
        HoneyContext.removeSysCommStrLocal("_SYS_Bee_FunType");
        HoneyContext.removeSysCommStrLocal("_SYS_Bee_MoreTableQuery");
        HoneyContext.removeListLocal("_SYS_Bee_TabNameListLocal");
        HoneyContext.removeListLocal("_SYS_Bee_TabSuffixListLocal");
        HoneyContext.removeListLocal("_SYS_Bee_DsNameListLocal");
        HoneyContext.removeListLocal("_SYS_Bee_TabNameListForBatchLocal");
        HoneyContext.removeListLocal("_SYS_Bee_DsNameListForBatchLocal");
        HoneyContext.removeCustomMapLocal("_SYS_Bee_ShardingTab2DsMap");
        HoneyContext.removeCurrentShardingPage();
        HoneyContext.removeCurrentShardingSort();
        HoneyContext.removeCurrentGroupFunStruct();
        HoneyContext.removeCurrentGroupFunStruct();
    }

    public static void setTrueInSysCommStrLocal(String key) {
        HoneyContext.setSysCommStrLocal(key, "tRue");
    }
}

