/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding;

import java.lang.reflect.Modifier;
import org.teasoft.bee.osql.annotation.DsTabHandler;
import org.teasoft.bee.sharding.DsTabStruct;
import org.teasoft.bee.sharding.ShardingBean;
import org.teasoft.bee.sharding.ShardingSimpleStruct;
import org.teasoft.bee.sharding.algorithm.Calculate;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.algorithm.CalculateFactory;
import org.teasoft.honey.sharding.config.ShardingRegistry;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.StringUtils;

public class ShardingSumHandler
implements DsTabHandler {
    private static final String dsRuleConst = "${dsRule}";
    private static final String tabRuleConst = "${tabRule}";

    public DsTabStruct process(ShardingSimpleStruct sharding) {
        ShardingBean bean = (ShardingBean)sharding;
        String dsShardingValue = ObjectUtils.string(bean.getDsShardingValue());
        String tabShardingValue = ObjectUtils.string(bean.getTabShardingValue());
        if (dsShardingValue == null && tabShardingValue == null) {
            return null;
        }
        DsTabStruct dsTabStruct = new DsTabStruct();
        int dsAlgorithm = bean.getDsAlgorithm();
        String dsRule = bean.getDsRule();
        String dsName = bean.getDsName();
        int tabAlgorithm = bean.getTabAlgorithm();
        String tabRule = bean.getTabRule();
        String tabName = bean.getTabName();
        if (StringUtils.isBlank(tabRule)) {
            tabRule = "tabField%" + ShardingRegistry.getTabSize(tabName);
        }
        if (StringUtils.isNotBlank(dsRule) && StringUtils.isNotBlank(dsName) && dsShardingValue != null) {
            Class c1 = bean.getDsAlgorithmClass();
            Calculate calculate1 = this.createObj(c1);
            if (calculate1 == null) {
                calculate1 = CalculateFactory.getCalculate(dsAlgorithm);
                if (dsAlgorithm == 0 && !this.isNumber(dsShardingValue)) {
                    dsShardingValue = ShardingUtil.hashInt(dsShardingValue) + "";
                }
            }
            String suffix = calculate1.process(dsRule, dsShardingValue);
            dsName = dsName.contains(dsRuleConst) ? dsName.replace(dsRuleConst, suffix) : dsName + suffix;
            dsTabStruct.setDsName(dsName);
        } else if (StringUtils.isNotBlank(dsName) && dsShardingValue != null) {
            dsTabStruct.setDsName(dsName);
        }
        String tabSuffix = "";
        boolean hasTabRule = false;
        if (StringUtils.isNotBlank(tabRule) && tabShardingValue != null) {
            Class c2 = bean.getTabAlgorithmClass();
            Calculate calculate2 = this.createObj(c2);
            if (calculate2 == null) {
                calculate2 = CalculateFactory.getCalculate(tabAlgorithm);
                if (tabAlgorithm == 0 && !this.isNumber(tabShardingValue)) {
                    tabShardingValue = ShardingUtil.hashInt(tabShardingValue) + "";
                }
            }
            tabSuffix = calculate2.process(tabRule, tabShardingValue);
            hasTabRule = true;
        }
        if (hasTabRule && StringUtils.isNotBlank(tabName) && tabShardingValue != null) {
            tabName = tabName.contains(tabRuleConst) ? tabName.replace(tabRuleConst, tabSuffix) : tabName + tabSuffix;
            dsTabStruct.setTabName(tabName);
        } else if (StringUtils.isNotBlank(tabName) && tabShardingValue != null) {
            dsTabStruct.setTabName(tabName);
        } else if (hasTabRule) {
            // empty if block
        }
        dsTabStruct.setTabSuffix(tabSuffix);
        return dsTabStruct;
    }

    private Calculate createObj(Class c) {
        Calculate calculate = null;
        if (!(c.equals(Calculate.class) || c.isInterface() || Modifier.isAbstract(c.getModifiers()))) {
            try {
                calculate = (Calculate)c.newInstance();
            }
            catch (Exception e) {
                Logger.debug(e.getMessage(), e);
            }
        }
        return calculate;
    }

    private boolean isNumber(String value) {
        try {
            if (value.contains(".")) {
                Double.parseDouble(value);
            } else {
                Long.parseLong(value);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

