/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.teasoft.bee.osql.BeeException;
import org.teasoft.bee.osql.Registry;
import org.teasoft.bee.sharding.ShardingBean;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.sharding.config.ShardingConfigMeta;
import org.teasoft.honey.sharding.config.ShardingConfigParse;

public class ShardingRegistry
implements Registry {
    private static final Map<Class<?>, ShardingBean> shardingMap = new ConcurrentHashMap();
    private static final Map<String, ShardingBean> shardingTableKeyMap = new ConcurrentHashMap<String, ShardingBean>();
    private static Map<String, Map<String, Set<String>>> fullNodes = new HashMap<String, Map<String, Set<String>>>();
    private static Map<String, String> tabToDsMap = new LinkedHashMap<String, String>();
    private static Map<String, Integer> tabSizeMap = new HashMap<String, Integer>();
    private static final Byte ONE = 1;
    private static Map<String, Byte> broadcastTabMap = new HashMap<String, Byte>();
    private static final Random RAND = new Random();

    public static ShardingBean getShardingBean(Class<?> entity) {
        return shardingMap.get(entity);
    }

    public static ShardingBean getShardingBean(String baseTableName) {
        return shardingTableKeyMap.get(baseTableName.toLowerCase());
    }

    public static String getDsShardingField(Class<?> entity) {
        ShardingBean bean = shardingMap.get(entity);
        if (bean != null) {
            return bean.getDsField();
        }
        return null;
    }

    public static String getTabShardingField(Class<?> entity) {
        ShardingBean bean = shardingMap.get(entity);
        if (bean != null) {
            return bean.getTabField();
        }
        return null;
    }

    public static String getDsByTab(String tabName) {
        return tabToDsMap.get(tabName);
    }

    public static Integer getTabSize(String tabBaseName) {
        return tabSizeMap.get(tabBaseName);
    }

    public static Map<String, Set<String>> getFullNodes(String baseTableName) {
        return fullNodes.get(baseTableName.toLowerCase());
    }

    public static String getRandDs(String baseTableName) {
        Map<String, Set<String>> map = ShardingRegistry.getFullNodes(baseTableName);
        if (map == null || map.size() < 1) {
            return null;
        }
        int size = map.size();
        int rand = RAND.nextInt(size);
        Set<String> set = map.keySet();
        int i = 0;
        for (String ds : set) {
            if (i == rand) {
                return ds;
            }
            ++i;
        }
        return null;
    }

    public static boolean isBroadcastTab(String tabName) {
        return ONE.equals(broadcastTabMap.get(tabName.toLowerCase()));
    }

    static void register(Class<?> entity, List<ShardingBean> shardingBeanList) {
        for (ShardingBean shardingBean : shardingBeanList) {
            ShardingRegistry.register(entity, shardingBean);
        }
    }

    static void register(Class<?> entity, ShardingBean shardingBean) {
        if (entity == null || shardingBean == null) {
            return;
        }
        shardingMap.put(entity, shardingBean);
        ShardingRegistry.parseFullNodesStringAndregister(shardingBean.getFullNodes(), shardingBean.getTabAssignType(), entity);
    }

    static void register(String baseTableName, ShardingBean shardingBean) {
        if (baseTableName == null || shardingBean == null) {
            return;
        }
        shardingTableKeyMap.put(baseTableName.toLowerCase(), shardingBean);
        ShardingRegistry.parseFullNodesStringAndregister(shardingBean.getFullNodes(), shardingBean.getTabAssignType(), null);
    }

    static void addTabToDsMap(Map<String, String> someTabToDsMap) {
        tabToDsMap.putAll(someTabToDsMap);
    }

    static void addFullNodes(Map<String, Map<String, Set<String>>> someNodes) {
        fullNodes.putAll(someNodes);
    }

    static void parseFullNodesStringAndregister(String fullNodes) {
        ShardingRegistry.parseFullNodesStringAndregister(fullNodes, 0, null);
    }

    private static void parseFullNodesStringAndregister(String fullNodes, int tabAssignType, Class<?> entity) {
        ShardingConfigParse t = new ShardingConfigParse();
        ShardingConfigMeta shardingConfigMeta = t.parseForSharding(fullNodes);
        if (shardingConfigMeta != null) {
            ShardingRegistry.addFullNodes(shardingConfigMeta.getFullNodes());
            ShardingRegistry.addTabToDsMap(shardingConfigMeta.getTabToDsMap());
            tabSizeMap.put(shardingConfigMeta.getTabBaseName(), shardingConfigMeta.getTabSize());
        } else {
            String msg = "Can not parse the fullNodes:" + fullNodes;
            if (entity != null) {
                msg = msg + "! Its entity name:" + entity.getName();
            }
            Logger.warn(msg, (Throwable)new BeeException());
        }
    }

    static void addBroadcastTabList(List<String> broadTabList) {
        for (String tab : broadTabList) {
            broadcastTabMap.put(tab.toLowerCase(), ONE);
        }
    }

    static void addBroadcastTabList(String broadTab) {
        broadcastTabMap.put(broadTab.toLowerCase(), ONE);
    }
}

