/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.osql.core.SimpleRewriteSql;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.engine.ResultMergeEngine;
import org.teasoft.honey.sharding.engine.ShardingAbstractBeeSQLExecutorEngine;
import org.teasoft.honey.sharding.engine.ShardingFunResultEngine;

public class ShardingSelectFunEngine {
    public <T> String asynProcess(String sql, BeeSql beeSql, Class entityClass) {
        String[] sqls = null;
        String[] dsArray = null;
        List<String[]> list = ShardingUtil.hadShardingFullSelect() ? SimpleRewriteSql.createSqlsForFull(sql, entityClass) : SimpleRewriteSql.createSqlsAndInit(sql);
        sqls = list.get(0);
        dsArray = list.get(1);
        ExecutorService executor = Executors.newCachedThreadPool();
        ExecutorCompletionService<String> completionService = new ExecutorCompletionService<String>(executor);
        ArrayList<ShardingBeeSQLFunExecutorEngine> tasks = new ArrayList<ShardingBeeSQLFunExecutorEngine>();
        for (int i = 0; sqls != null && i < sqls.length; ++i) {
            tasks.add(new ShardingBeeSQLFunExecutorEngine(sqls[i], i + 1, beeSql, dsArray[i]));
        }
        if (sqls != null) {
            ShardingLogReg.log(sqls.length);
        }
        int size = tasks.size();
        for (int i = 0; tasks != null && i < size; ++i) {
            completionService.submit((Callable)tasks.get(i));
        }
        List<String> rsList = ResultMergeEngine.mergeFunResult(completionService, size);
        executor.shutdown();
        return ShardingFunResultEngine.funResultEngine(rsList);
    }

    private class ShardingBeeSQLFunExecutorEngine
    extends ShardingAbstractBeeSQLExecutorEngine<String> {
        public ShardingBeeSQLFunExecutorEngine(String sql, int index, BeeSql beeSql, String ds) {
            super(sql, index, beeSql, ds);
        }

        @Override
        public String shardingWork() {
            ShardingLogReg.regShardingSqlLog("select fun SQL", this.index, this.sql);
            String rsStr = "";
            String typeTag = "";
            typeTag = "select fun";
            rsStr = this.beeSql.selectFun(this.sql);
            ShardingLogReg.regShardingSqlLog("    | <--  " + typeTag, this.index, rsStr);
            return rsStr;
        }
    }
}

