/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.batch;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.teasoft.bee.osql.SuidRich;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.JdkSerializer;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.sharding.ShardingReg;
import org.teasoft.honey.sharding.config.ShardingRegistry;
import org.teasoft.honey.sharding.engine.ResultMergeEngine;
import org.teasoft.honey.sharding.engine.batch.ShardingBatchInsertTemplate;
import org.teasoft.honey.util.StringUtils;

public class ShardingBatchInsertEngine<T> {
    public int batchInsert(T[] entity, int batchSize, String excludeFields, List<String> tabNameListForBatch, SuidRich suidRich) {
        ShardingReg.regShardingBatchInsertDoing();
        Logger.debug("" + (tabNameListForBatch.size() == entity.length));
        ArrayList<Object[]> newEntityArrayList = new ArrayList<Object[]>();
        ArrayList<String> taskDs = new ArrayList<String>();
        ArrayList<String> taskTab = new ArrayList<String>();
        Map<String, List<Integer>> tabMap = this.groupElement(tabNameListForBatch);
        List<String> dsNameListForBatch = HoneyContext.getListLocal("_SYS_Bee_DsNameListForBatchLocal");
        for (Map.Entry<String, List<Integer>> entry : tabMap.entrySet()) {
            String tabName = entry.getKey();
            List<Integer> indexList = entry.getValue();
            Object[] newEntity = new Object[indexList.size()];
            for (int i = 0; i < indexList.size(); ++i) {
                newEntity[i] = entity[indexList.get(i)];
            }
            newEntityArrayList.add(newEntity);
            String dsName = dsNameListForBatch.get(indexList.get(0));
            if (StringUtils.isBlank(dsName)) {
                dsName = ShardingRegistry.getDsByTab(tabName);
            }
            taskDs.add(dsName);
            taskTab.add(tabName);
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        ExecutorCompletionService<Integer> completionService = new ExecutorCompletionService<Integer>(executor);
        ArrayList<ShardingBeeSQLBatchInsertExecutorEngine> tasks = new ArrayList<ShardingBeeSQLBatchInsertExecutorEngine>();
        for (int i = 0; i < newEntityArrayList.size(); ++i) {
            tasks.add(new ShardingBeeSQLBatchInsertExecutorEngine(newEntityArrayList, batchSize, excludeFields, taskDs, taskTab, suidRich, i));
        }
        ShardingLogReg.log(newEntityArrayList.size());
        int size = tasks.size();
        for (int i = 0; tasks != null && i < size; ++i) {
            completionService.submit((Callable)tasks.get(i));
        }
        int r = ResultMergeEngine.mergeInteger(completionService, size);
        executor.shutdown();
        return r;
    }

    private Map<String, List<Integer>> groupElement(List<String> tabNameListForBatch) {
        LinkedHashMap<String, List<Integer>> tabMap = new LinkedHashMap<String, List<Integer>>();
        for (int i = 0; i < tabNameListForBatch.size(); ++i) {
            ArrayList<Integer> dsList = (ArrayList<Integer>)tabMap.get(tabNameListForBatch.get(i));
            if (dsList == null) {
                dsList = new ArrayList<Integer>();
            }
            dsList.add(i);
            tabMap.put(tabNameListForBatch.get(i), dsList);
        }
        return tabMap;
    }

    private class ShardingBeeSQLBatchInsertExecutorEngine
    extends ShardingBatchInsertTemplate<Integer>
    implements Callable<Integer> {
        private int batchSize;
        private String excludeFields;
        private SuidRich suidRich;
        private List<Object[]> newEntityArrayList = new ArrayList<Object[]>();

        public ShardingBeeSQLBatchInsertExecutorEngine(List<Object[]> newEntityArrayList, int batchSize, String excludeFields, List<String> taskDs, List<String> taskTab, SuidRich suidRich, int index) {
            this.batchSize = batchSize;
            this.excludeFields = excludeFields;
            this.suidRich = suidRich;
            this.newEntityArrayList = newEntityArrayList;
            this.taskDs = taskDs;
            this.taskTab = taskTab;
            this.index = index;
        }

        @Override
        public Integer shardingWork() {
            int b = this.copy(this.suidRich).insert(this.newEntityArrayList.get(this.index), this.batchSize, this.excludeFields);
            return b;
        }

        @Override
        public Integer call() throws Exception {
            return (Integer)this.doSharding();
        }

        private SuidRich copy(SuidRich suidRich) {
            try {
                JdkSerializer jdks = new JdkSerializer();
                return (SuidRich)jdks.unserialize(jdks.serialize(suidRich));
            }
            catch (Exception e) {
                Logger.debug(e.getMessage(), e);
                return suidRich;
            }
        }
    }
}

