/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.batch;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import org.teasoft.bee.osql.SuidRich;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.sharding.config.ShardingRegistry;
import org.teasoft.honey.util.StringUtils;

public class ShardingForkJoinBatchInsertEngine<T> {
    public int batchInsert(T[] entity, int batchSize, String excludeFields, List<String> tabNameListForBatch, SuidRich suidRich) {
        ArrayList<Object[]> newEntityArrayList = new ArrayList<Object[]>();
        ArrayList<String> taskDs = new ArrayList<String>();
        ArrayList<String> taskTab = new ArrayList<String>();
        Map<String, List<Integer>> tabMap = this.groupElement(tabNameListForBatch);
        List<String> dsNameListForBatch = HoneyContext.getListLocal("_SYS_Bee_DsNameListForBatchLocal");
        for (Map.Entry<String, List<Integer>> entry : tabMap.entrySet()) {
            String tabName = entry.getKey();
            List<Integer> indexList = entry.getValue();
            Object[] newEntity = new Object[indexList.size()];
            for (int i = 0; i < indexList.size(); ++i) {
                newEntity[i] = entity[indexList.get(i)];
            }
            newEntityArrayList.add(newEntity);
            String dsName = dsNameListForBatch.get(indexList.get(0));
            if (StringUtils.isBlank(dsName)) {
                dsName = ShardingRegistry.getDsByTab(tabName);
            }
            taskDs.add(dsName);
            taskTab.add(tabName);
        }
        ShardingLogReg.log(taskTab.size());
        return this.doTask(new ShardingRecursiveBatchInsert(newEntityArrayList, batchSize, excludeFields, taskDs, taskTab, suidRich));
    }

    private int doTask(ShardingRecursiveBatchInsert work) {
        ForkJoinPool pool = new ForkJoinPool();
        pool.invoke(work);
        return (Integer)work.join();
    }

    private Map<String, List<Integer>> groupElement(List<String> tabNameListForBatch) {
        LinkedHashMap<String, List<Integer>> tabMap = new LinkedHashMap<String, List<Integer>>();
        for (int i = 0; i < tabNameListForBatch.size(); ++i) {
            ArrayList<Integer> dsList = (ArrayList<Integer>)tabMap.get(tabNameListForBatch.get(i));
            if (dsList == null) {
                dsList = new ArrayList<Integer>();
            }
            dsList.add(i);
            tabMap.put(tabNameListForBatch.get(i), dsList);
        }
        return tabMap;
    }

    private class ShardingRecursiveBatchInsert
    extends RecursiveTask<Integer> {
        private static final long serialVersionUID = 1L;
        private int start = 0;
        private int end;
        private int batchSize;
        private String excludeFields;
        private SuidRich suidRich;
        private List<Object[]> newEntityArrayList = new ArrayList<Object[]>();
        private List<String> taskDs = new ArrayList<String>();
        private List<String> taskTab = new ArrayList<String>();

        public ShardingRecursiveBatchInsert(List<Object[]> newEntityArrayList, int batchSize, String excludeFields, List<String> taskDs, List<String> taskTab, SuidRich suidRich) {
            this.end = newEntityArrayList.size() - 1;
            this.batchSize = batchSize;
            this.excludeFields = excludeFields;
            this.suidRich = suidRich;
            this.newEntityArrayList = newEntityArrayList;
            this.taskDs = taskDs;
            this.taskTab = taskTab;
        }

        public ShardingRecursiveBatchInsert(List<Object[]> newEntityArrayList, int batchSize, String excludeFields, List<String> taskDs, List<String> taskTab, SuidRich suidRich, int start, int end) {
            this(newEntityArrayList, batchSize, excludeFields, taskDs, taskTab, suidRich);
            this.start = start;
            this.end = end;
        }

        @Override
        protected Integer compute() {
            if (this.end == this.start) {
                return this.doOneTask(this.newEntityArrayList.get(this.start), this.batchSize, this.excludeFields, this.start);
            }
            ShardingRecursiveBatchInsert task1 = new ShardingRecursiveBatchInsert(this.newEntityArrayList, this.batchSize, this.excludeFields, this.taskDs, this.taskTab, this.suidRich, this.start, this.start);
            ShardingRecursiveBatchInsert task2 = new ShardingRecursiveBatchInsert(this.newEntityArrayList, this.batchSize, this.excludeFields, this.taskDs, this.taskTab, this.suidRich, this.start + 1, this.end);
            ShardingRecursiveBatchInsert.invokeAll(task1, task2);
            return (Integer)task1.join() + (Integer)task2.join();
        }

        private int doOneTask(Object[] entity, int batchSize, String excludeFields, int index) {
            HoneyContext.setSqlIndexLocal(index);
            HoneyContext.setAppointTab(this.taskTab.get(index));
            HoneyContext.setAppointDS(this.taskDs.get(index));
            int b = this.suidRich.insert(entity, batchSize, excludeFields);
            HoneyContext.removeAppointDS();
            HoneyContext.removeAppointTab();
            HoneyContext.removeSqlIndexLocal();
            return b;
        }
    }
}

