/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.decorate;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.teasoft.bee.sharding.ShardingSortStruct;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.sharding.engine.decorate.CompareUtil;
import org.teasoft.honey.util.ObjectUtils;

public class CompareResult
implements Comparable<CompareResult> {
    private Object[] orderValues;
    private final ResultSet resultSet;
    private ShardingSortStruct struct;
    private boolean has = false;

    public CompareResult(ResultSet resultSet, ShardingSortStruct struct) {
        this.resultSet = resultSet;
        this.struct = struct;
        this.initOrderValues();
    }

    public boolean hasNext() {
        return this.has;
    }

    private void initOrderValues() {
        try {
            if (this.resultSet.next()) {
                this.has = true;
                if (this.struct != null && this.struct.getOrderFields() != null) {
                    this.orderValues = new Object[this.struct.getOrderFields().length];
                    for (int k = 0; k < this.struct.getOrderFields().length; ++k) {
                        this.orderValues[k] = this.resultSet.getObject(this.struct.getOrderFields()[k]);
                    }
                }
            }
        }
        catch (SQLException e) {
            Logger.debug(e.getMessage(), e);
        }
    }

    @Override
    public int compareTo(CompareResult other) {
        if (this.struct == null) {
            return 0;
        }
        if (!this.hasNext()) {
            return -1;
        }
        if (!other.hasNext()) {
            return -1;
        }
        for (int i = 0; i < this.orderValues.length; ++i) {
            int result = CompareUtil.compareTo(ObjectUtils.string(this.orderValues[i]), ObjectUtils.string(other.orderValues[i]), this.struct, i);
            if (0 == result) continue;
            return result;
        }
        return 0;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public Object[] getOrderValues() {
        return this.orderValues;
    }

    public void setOrderValues(Object[] orderValues) {
        this.orderValues = orderValues;
    }

    public ShardingSortStruct getStruct() {
        return this.struct;
    }
}

