/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.mongodb;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.teasoft.bee.mongodb.MongodbBeeSql;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.engine.mongodb.MongodbShardingRouter;
import org.teasoft.honey.sharding.engine.mongodb.ShardingAbstractMongoBeeSQLExecutorEngine;

public class MongodbShardingDdlEngine {
    public <T> boolean asynProcess(Class<T> entityClass, MongodbBeeSql mongodbBeeSql, boolean isDropExistTable) {
        List<String[]> list = ShardingUtil.hadShardingFullSelect() ? MongodbShardingRouter._findDsTabForFull(entityClass) : MongodbShardingRouter._findDsTab();
        String[] dsArray = list.get(0);
        String[] tabArray = list.get(1);
        ExecutorService executor = Executors.newCachedThreadPool();
        ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
        ArrayList<ShardingBeeSQLExecutorEngine<T>> tasks = new ArrayList<ShardingBeeSQLExecutorEngine<T>>();
        for (int i = 0; dsArray != null && i < dsArray.length; ++i) {
            tasks.add(new ShardingBeeSQLExecutorEngine<T>(tabArray[i], i + 1, mongodbBeeSql, dsArray[i], entityClass, isDropExistTable));
        }
        if (dsArray != null) {
            ShardingLogReg.log(dsArray.length);
        }
        int size = tasks.size();
        for (int i = 0; tasks != null && i < size; ++i) {
            completionService.submit((Callable)tasks.get(i));
        }
        boolean f = false;
        for (int i = 0; i < size; ++i) {
            try {
                f = f || (Boolean)completionService.take().get() != false;
                continue;
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), e);
            }
        }
        return f;
    }

    private class ShardingBeeSQLExecutorEngine<T>
    extends ShardingAbstractMongoBeeSQLExecutorEngine<Boolean> {
        private Class<T> entityClass;
        private boolean isDropExistTable;

        public ShardingBeeSQLExecutorEngine(String tab, int index, MongodbBeeSql mongodbBeeSql, String ds, Class<T> entityClass, boolean isDropExistTable) {
            super(tab, index, mongodbBeeSql, ds);
            this.entityClass = entityClass;
            this.isDropExistTable = isDropExistTable;
        }

        @Override
        public Boolean shardingWork() {
            ShardingLogReg.regShardingSqlLog("DDL SQL", this.index, this.tab);
            return this.mongodbBeeSql.createTable(this.entityClass, this.isDropExistTable);
        }
    }
}

