/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.mongodb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.teasoft.bee.mongodb.MongoSqlStruct;
import org.teasoft.bee.mongodb.MongodbBeeSql;
import org.teasoft.bee.spi.JsonTransform;
import org.teasoft.honey.osql.core.JsonResultWrap;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.engine.ResultMergeEngine;
import org.teasoft.honey.sharding.engine.decorate.ResultPagingDecorator;
import org.teasoft.honey.sharding.engine.decorate.SortListDecorator;
import org.teasoft.honey.sharding.engine.mongodb.MongodbShardingRouter;
import org.teasoft.honey.sharding.engine.mongodb.ShardingAbstractMongoBeeSQLExecutorEngine;
import org.teasoft.honey.spi.SpiInstanceFactory;
import org.teasoft.honey.util.ObjectUtils;

public class MongodbShardingSelectJsonEngine {
    public JsonResultWrap asynProcess(Class entityClass, MongodbBeeSql mongodbBeeSql, MongoSqlStruct struct) {
        int rowCount;
        List<String[]> list = ShardingUtil.hadShardingFullSelect() ? MongodbShardingRouter._findDsTabForFull(entityClass) : MongodbShardingRouter._findDsTab();
        String[] dsArray = list.get(0);
        String[] tabArray = list.get(1);
        ExecutorService executor = Executors.newCachedThreadPool();
        ExecutorCompletionService<String> completionService = new ExecutorCompletionService<String>(executor);
        ArrayList<ShardingBeeSQLJsonExecutorEngine> tasks = new ArrayList<ShardingBeeSQLJsonExecutorEngine>();
        for (int i = 0; dsArray != null && i < dsArray.length; ++i) {
            tasks.add(new ShardingBeeSQLJsonExecutorEngine(tabArray[i], i + 1, mongodbBeeSql, dsArray[i], entityClass, struct));
        }
        if (dsArray != null) {
            ShardingLogReg.log(dsArray.length);
        }
        int size = tasks.size();
        for (int i = 0; tasks != null && i < size; ++i) {
            completionService.submit((Callable)tasks.get(i));
        }
        List<String> rsList = ResultMergeEngine.mergeJsonResult(completionService, size);
        executor.shutdown();
        String json = "";
        if (rsList.size() == 1) {
            json = rsList.get(0);
            rowCount = 1;
        } else if (rsList.size() == 0) {
            json = "[]";
            rowCount = 0;
        } else {
            JsonTransform jsonTransform = SpiInstanceFactory.getJsonTransform();
            ArrayList entityList = new ArrayList();
            for (int i = 0; i < rsList.size(); ++i) {
                if (!ObjectUtils.isNotEmpty(rsList.get(i)) || "[]".equals(rsList.get(i))) continue;
                entityList.addAll((Collection)jsonTransform.toEntity(rsList.get(i), List.class, entityClass));
            }
            SortListDecorator.sort(entityList);
            ResultPagingDecorator.pagingList(entityList);
            json = jsonTransform.toJson(entityList);
            rowCount = entityList.size();
        }
        JsonResultWrap wrap = new JsonResultWrap();
        wrap.setResultJson(json.toString());
        wrap.setRowCount(rowCount);
        return wrap;
    }

    private class ShardingBeeSQLJsonExecutorEngine
    extends ShardingAbstractMongoBeeSQLExecutorEngine<String> {
        private Class entityClass;
        private MongoSqlStruct struct;

        public ShardingBeeSQLJsonExecutorEngine(String tab, int index, MongodbBeeSql mongodbBeeSql, String ds, Class entityClass, MongoSqlStruct struct) {
            super(tab, index, mongodbBeeSql, ds);
            this.entityClass = entityClass;
            this.struct = struct.copy();
            this.struct.setTableName(tab);
        }

        @Override
        public String shardingWork() {
            ShardingLogReg.regShardingSqlLog("selectJson SQL", this.index, this.tab);
            return this.mongodbBeeSql.selectJson(this.struct, this.entityClass);
        }
    }
}

