/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util.currency;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.teasoft.honey.util.currency.CurrencyArithmetic;

public class CurrencyExpressionArith {
    private CurrencyExpressionArith() {
    }

    static String arith(List<String> list) {
        return CurrencyExpressionArith.arith(list, -1);
    }

    static String arith(List<String> list, int scale) {
        return CurrencyExpressionArith.arith(list, scale, null);
    }

    protected static String arith(List<String> list, int scale, RoundingMode divideRoundingMode) {
        Stack<String> v = new Stack<String>();
        int len = list.size();
        String t = "";
        for (int i = 0; i < len; ++i) {
            t = list.get(i);
            if (!CurrencyExpressionArith.isArithOperate(t)) {
                v.push(t);
                continue;
            }
            String b = (String)v.pop();
            String a = (String)v.pop();
            if (scale != -1 && divideRoundingMode != null) {
                v.push(CurrencyArithmetic.calculate(a, t, b, scale, divideRoundingMode));
                continue;
            }
            if (scale != -1) {
                v.push(CurrencyArithmetic.calculate(a, t, b, scale));
                continue;
            }
            v.push(CurrencyArithmetic.calculate(a, t, b));
        }
        return (String)v.pop();
    }

    static boolean isArithOperate(String op) {
        return "+".equals(op) || "-".equals(op) || "*".equals(op) || "/".equals(op) || "%".equals(op);
    }

    static boolean isOperate(char op) {
        return op == '+' || op == '-' || op == '*' || op == '/' || op == '%' || op == '(' || op == ')';
    }

    private static boolean isArithOperate(char op) {
        return op == '+' || op == '-' || op == '*' || op == '/' || op == '%';
    }

    static String inToPost(String exp) {
        return CurrencyExpressionArith.inToPost(exp, true);
    }

    static String inToPost(String exp, boolean isNumberCalculate) {
        List<String> list = CurrencyExpressionArith.inToPostList(exp, isNumberCalculate);
        StringBuffer sbu = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            sbu.append(list.get(i));
            sbu.append("  ");
        }
        return sbu.toString();
    }

    private static boolean isEqualBrackets(String s) {
        char[] ch = s.toCharArray();
        int left = 0;
        int right = 0;
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] == '(') {
                ++left;
                continue;
            }
            if (ch[i] != ')') continue;
            ++right;
        }
        return left == right;
    }

    static List<String> inToPostList(String s) {
        return CurrencyExpressionArith.inToPostList(s, true);
    }

    static List<String> inToPostList(String s, boolean isNumberCalculate) {
        Stack<Character> op = new Stack<Character>();
        if (s == null) {
            return null;
        }
        s = s.replace(" ", "");
        s = s.replace("(-", "(0-");
        s = s.replace("(+", "(0+");
        if ((s = s.replace("\u00f7", "/")).startsWith("-")) {
            s = "0" + s;
        } else if (s.startsWith("+")) {
            s = "0" + s;
        }
        if (!CurrencyExpressionArith.isEqualBrackets(s)) {
            throw new RuntimeException("the number of '(' and ')' is not equal !");
        }
        char[] arr = s.toCharArray();
        int len = arr.length;
        ArrayList<String> list = new ArrayList<String>();
        String temp = "";
        boolean isArithOp = false;
        for (int i = 0; i < len; ++i) {
            char ch = arr[i];
            if (ch == ' ') continue;
            if (!CurrencyExpressionArith.isOperate(ch)) {
                if (isNumberCalculate && (ch < '0' || ch > '9')) {
                    throw new RuntimeException("there is some other char(not number) : " + ch);
                }
                temp = temp + ch + "";
                if (i == len - 1 || CurrencyExpressionArith.isOperate(arr[i + 1])) {
                    list.add(temp);
                    temp = "";
                }
                isArithOp = false;
                continue;
            }
            if (ch == '(') {
                op.push(Character.valueOf(ch));
            }
            if (ch == '+' || ch == '-') {
                if (isArithOp) {
                    throw new RuntimeException("There are two consecutive operators: " + arr[i - 1] + ch);
                }
                isArithOp = true;
                while (!op.empty() && ((Character)op.peek()).charValue() != '(') {
                    list.add(op.pop() + "");
                }
                op.push(Character.valueOf(ch));
                continue;
            }
            if (ch == '*' || ch == '/' || ch == '%') {
                if (isArithOp) {
                    throw new RuntimeException("There are two consecutive operators: " + arr[i - 1] + ch);
                }
                isArithOp = true;
                while (!(op.empty() || ((Character)op.peek()).charValue() != '*' && ((Character)op.peek()).charValue() != '/' && ((Character)op.peek()).charValue() != '%')) {
                    list.add(op.pop() + "");
                }
                op.push(Character.valueOf(ch));
                continue;
            }
            if (ch != ')') continue;
            while (!op.empty() && ((Character)op.peek()).charValue() != '(') {
                list.add(op.pop() + "");
            }
            op.pop();
        }
        while (!op.empty()) {
            list.add(op.pop() + "");
        }
        return list;
    }

    public static String preCheckExpression(String exp) {
        String s = "";
        boolean notEmpty = false;
        if (!CurrencyExpressionArith.isEqualBrackets(exp)) {
            s = s + "the number of '(' and ')' is not equal !";
            notEmpty = true;
        }
        String str = CurrencyExpressionArith.illegal(exp);
        if (!"".equals(CurrencyExpressionArith.illegal(exp))) {
            if (notEmpty) {
                s = s + "\n";
            }
            s = s + str;
        }
        return s;
    }

    private static String illegal(String exp) {
        char[] ch = exp.toCharArray();
        boolean isArithOp = false;
        String illegalChar = "";
        String consecutiveArithStr = "";
        int lastIndex = 0;
        boolean moreThanOne = false;
        int len = ch.length;
        for (int i = 0; i < ch.length; ++i) {
            if (!CurrencyExpressionArith.isOperate(ch[i])) {
                isArithOp = false;
                if (moreThanOne) {
                    consecutiveArithStr = consecutiveArithStr + "  ";
                }
                moreThanOne = false;
                if (ch[i] >= '0' && ch[i] <= '9') continue;
                illegalChar = illegalChar + ch[i];
                if (i != len - 1 && !CurrencyExpressionArith.isOperate(ch[i + 1])) continue;
                illegalChar = illegalChar + ",";
                continue;
            }
            if (!CurrencyExpressionArith.isArithOperate(ch[i])) continue;
            if (isArithOp) {
                if (!moreThanOne) {
                    consecutiveArithStr = consecutiveArithStr + ch[i - 1] + "" + ch[i] + "";
                    moreThanOne = true;
                } else if (i - 1 == lastIndex) {
                    consecutiveArithStr = consecutiveArithStr + ch[i] + "";
                }
            }
            isArithOp = true;
            lastIndex = i;
        }
        boolean f1 = false;
        boolean f2 = false;
        if (!"".equals(illegalChar)) {
            illegalChar = "there are some other String(not number) : " + illegalChar;
            f1 = true;
        }
        if (!"".equals(consecutiveArithStr)) {
            consecutiveArithStr = "There are two consecutive operators:" + consecutiveArithStr;
            f2 = true;
        }
        if (f1 && f2) {
            return illegalChar + "/n" + consecutiveArithStr;
        }
        if (f2) {
            return consecutiveArithStr;
        }
        return illegalChar;
    }
}

