/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.autogen;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.util.FileUtil;
import org.teasoft.honey.osql.util.StringUtil;

public class GenFiles {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private GenFiles() {
    }

    public static void genFile(String templatePath, Map<String, String> map, String targetFilePath) {
        GenFiles.genFile(templatePath, map, targetFilePath, "#{", "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void genFile(String templatePath, Map<String, String> map, String targetFilePath, String startToken, String endToken) {
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        boolean firstLine = true;
        try {
            br = FileUtil.readFile(templatePath);
            String temp = null;
            while ((temp = br.readLine()) != null) {
                temp = StringUtil.replaceWithMap(temp, map, startToken, endToken);
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append(LINE_SEPARATOR);
                }
                sb.append(temp);
            }
            br.close();
        }
        catch (IOException e) {
            Logger.error(e.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {
                    Logger.error(ioe.getMessage());
                }
            }
        }
        FileUtil.genFile(targetFilePath, sb.toString());
    }
}

