/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.api.CallableSql;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.JsonResultWrap;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.TransformResultSet;

public class CallableSqlLib
implements CallableSql {
    private static final String VALUES = "  values: ";
    private static final String CALLABLE_SQL = "Callable SQL: ";
    private static final ThreadLocal<Map<String, Connection>> connLocal = new ThreadLocal();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> select(String callSql, T returnType, Object[] preValues) {
        Connection conn = null;
        ResultSet rs = null;
        CallableStatement cstmt = null;
        ArrayList<Object> rsList = null;
        Object targetObj = null;
        try {
            conn = this.getConn();
            callSql = this.getCallSql(callSql);
            cstmt = conn.prepareCall(callSql);
            StringBuffer values2333332 = this.initPreparedValues(cstmt, preValues);
            Logger.logSQL(CALLABLE_SQL, callSql + VALUES + values2333332);
            rs = cstmt.executeQuery();
            rsList = new ArrayList<Object>();
            Field[] field = returnType.getClass().getDeclaredFields();
            int columnCount = field.length;
            while (rs.next()) {
                targetObj = returnType.getClass().newInstance();
                for (int i = 0; i < columnCount; ++i) {
                    if (HoneyUtil.isSkipField(field[i])) continue;
                    field[i].setAccessible(true);
                    try {
                        field[i].set(targetObj, rs.getObject(CallableSqlLib._toColumnName(field[i].getName())));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        field[i].set(targetObj, this._getObject(rs, field[i]));
                    }
                }
                rsList.add(targetObj);
            }
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.checkClose(cstmt, conn);
                throw throwable;
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception values2333332) {
            // empty catch block
        }
        this.checkClose(cstmt, conn);
        return rsList;
    }

    public int modify(String callSql, Object[] preValues) {
        int result = 0;
        Connection conn = null;
        CallableStatement cstmt = null;
        try {
            conn = this.getConn();
            callSql = this.getCallSql(callSql);
            cstmt = conn.prepareCall(callSql);
            StringBuffer values = this.initPreparedValues(cstmt, preValues);
            Logger.logSQL(CALLABLE_SQL, callSql + VALUES + values);
            result = cstmt.executeUpdate();
            this.checkClose(cstmt, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(cstmt, conn);
                throw throwable;
            }
        }
        return result;
    }

    public CallableStatement getCallableStatement(String callSql) {
        Connection conn = null;
        CallableStatement cstmt = null;
        try {
            conn = this.getConn();
            callSql = this.getCallSql(callSql);
            cstmt = conn.prepareCall(callSql);
            Logger.logSQL("Callable SQL,getCallableStatement: ", callSql);
            String key = this.getIdString(cstmt);
            this.setConnLocal(key, conn);
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
        return cstmt;
    }

    public int modify(CallableStatement cstmt) {
        int result = 0;
        try {
            String key = this.getIdString(cstmt);
            Connection conn = this.getConnLocal(key);
            result = cstmt.executeUpdate();
            this.checkClose(cstmt, conn);
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
        return result;
    }

    public List<String[]> select(String callSql, Object[] preValues) {
        List<String[]> list = null;
        Connection conn = null;
        ResultSet rs = null;
        CallableStatement cstmt = null;
        try {
            conn = this.getConn();
            callSql = this.getCallSql(callSql);
            cstmt = conn.prepareCall(callSql);
            StringBuffer values = this.initPreparedValues(cstmt, preValues);
            Logger.logSQL(CALLABLE_SQL, callSql + VALUES + values);
            rs = cstmt.executeQuery();
            list = TransformResultSet.toStringsList(rs);
            this.checkClose(cstmt, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(cstmt, conn);
                throw throwable;
            }
        }
        return list;
    }

    public String selectJson(String callSql, Object[] preValues) {
        String json = "";
        Connection conn = null;
        ResultSet rs = null;
        CallableStatement cstmt = null;
        try {
            conn = this.getConn();
            callSql = this.getCallSql(callSql);
            cstmt = conn.prepareCall(callSql);
            StringBuffer values = this.initPreparedValues(cstmt, preValues);
            Logger.logSQL(CALLABLE_SQL, callSql + VALUES + values);
            rs = cstmt.executeQuery();
            JsonResultWrap wrap = TransformResultSet.toJson(rs, null);
            json = wrap.getResultJson();
            int rowCount = wrap.getRowCount();
            this.logSelectRows(rowCount);
            this.checkClose(cstmt, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(cstmt, conn);
                throw throwable;
            }
        }
        return json;
    }

    private void logSelectRows(int size) {
        Logger.logSQL(" | <--  select rows: ", size + "");
    }

    private String getCallSql(String callSql) {
        return "{call " + callSql + "}";
    }

    private void setConnLocal(String key, Connection conn) {
        if (conn == null) {
            return;
        }
        Map<String, Connection> map = connLocal.get();
        if (null == map) {
            map = new HashMap<String, Connection>();
        }
        map.put(key, conn);
        connLocal.set(map);
    }

    private Connection getConnLocal(String key) {
        Map<String, Connection> map = connLocal.get();
        if (null == map) {
            return null;
        }
        Connection s = map.get(key);
        map.remove(key);
        connLocal.remove();
        return s;
    }

    private String getIdString(CallableStatement cstmt) {
        return cstmt.hashCode() + "";
    }

    private StringBuffer initPreparedValues(CallableStatement cstmt, Object[] preValues) throws SQLException {
        if (preValues == null) {
            return new StringBuffer("preValues is null!");
        }
        StringBuffer valueBuffer = new StringBuffer();
        int len = preValues.length;
        for (int i = 0; i < len; ++i) {
            int k = -1;
            if (preValues[i] != null) {
                k = HoneyUtil.getJavaTypeIndex(preValues[i].getClass().getName());
            }
            HoneyUtil.setPreparedValues(cstmt, k, i, preValues[i]);
            valueBuffer.append(",");
            valueBuffer.append(preValues[i]);
        }
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        return valueBuffer;
    }

    private Connection getConn() throws SQLException {
        return HoneyContext.getConn();
    }

    protected void checkClose(Statement stmt, Connection conn) {
        HoneyContext.checkClose(stmt, conn);
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private Object _getObject(ResultSet rs, Field field) throws SQLException {
        return HoneyUtil.getResultObject(rs, field.getType().getName(), CallableSqlLib._toColumnName(field.getName()));
    }
}

