/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.MoreObjToSQL;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.api.MoreTable;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.honey.osql.core.AbstractCommOperate;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OneTimeParameter;

public class MoreObjSQL
extends AbstractCommOperate
implements MoreTable {
    private BeeSql beeSql;
    private MoreObjToSQL moreObjToSQL;
    private static final String SELECT_SQL = "select SQL: ";

    public <T> List<T> select(T entity) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity);
        String sql = this.getMoreObjToSQL().toSelectSQL(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().moreTableSelect(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(T entity, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need >0 .");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need >=0 .");
        }
        this.doBeforePasreEntity(entity);
        String sql = this.getMoreObjToSQL().toSelectSQL(entity, start, size);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().moreTableSelect(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.regCondition(condition);
        this.doBeforePasreEntity(entity);
        String sql = this.getMoreObjToSQL().toSelectSQL(entity, condition);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().moreTableSelect(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public MoreObjSQL setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    private void doBeforePasreEntity(Object entity) {
        super.doBeforePasreEntity(entity, SuidType.SELECT);
        OneTimeParameter.setAttribute("_SYS_Bee_InterceptorChainForMoreTable", this.getInterceptorChain());
    }

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public MoreObjToSQL getMoreObjToSQL() {
        if (this.moreObjToSQL == null) {
            return BeeFactory.getHoneyFactory().getMoreObjToSQL();
        }
        return this.moreObjToSQL;
    }

    public void setMoreObjToSQL(MoreObjToSQL moreObjToSQL) {
        this.moreObjToSQL = moreObjToSQL;
    }
}

