/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.IncludeType;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.ObjSQLIllegalSQLStringException;
import org.teasoft.bee.osql.ObjToSQLRich;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.BeeIllegalEntityException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ConditionHelper;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.FunAndOrderTypeMap;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.ObjectToSQL;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SqlStrFilter;
import org.teasoft.honey.osql.core.SqlValueWrap;
import org.teasoft.honey.osql.core._ObjectToSQLHelper;
import org.teasoft.honey.osql.dialect.sqlserver.SqlServerPagingStruct;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.osql.util.AnnoUtil;
import org.teasoft.honey.sharding.ShardingReg;
import org.teasoft.honey.util.StringUtils;

public class ObjectToSQLRich
extends ObjectToSQL
implements ObjToSQLRich {
    private static final String ASC = K.asc;
    private static final String INDEX1 = "_SYS[index";
    private static final String INDEX2 = "]_End ";
    private static final String INDEX3 = "]";

    private DbFeature getDbFeature() {
        return BeeFactory.getHoneyFactory().getDbFeature();
    }

    private void regPagePlaceholder() {
        HoneyUtil.regPagePlaceholder();
    }

    public <T> String toSelectSQL(T entity, int start, int size) {
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = this._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        this.regPagePlaceholder();
        this.adjustSqlServerPagingPkIfNeed(sql, entity.getClass());
        String beforeSql = sql;
        sql = start == -1 ? this.getDbFeature().toPageSql(sql, size) : this.getDbFeature().toPageSql(sql, start, size);
        ShardingReg.regShadingPage(beforeSql, sql, start, size);
        HoneyUtil.setPageNum(wrap.getList());
        if (this.isNeedRealTimeDb()) {
            ObjectToSQLRich.setContext(sql, wrap.getList(), tableName);
        } else {
            ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        }
        if (start == -1) {
            Logger.logSQL("select SQL(entity,size): ", sql);
        } else {
            Logger.logSQL("select(entity,start,size) SQL: ", sql);
        }
        return sql;
    }

    public <T> String toSelectSQL(T entity, int start, int size, String ... selectFields) {
        String tableName = "";
        if (this.isNeedRealTimeDb()) {
            tableName = this._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
        }
        SqlValueWrap wrap = this.toSelectSQL_0(entity, selectFields);
        String sql = wrap.getSql();
        this.regPagePlaceholder();
        this.adjustSqlServerPagingPkIfNeed(sql, entity.getClass());
        String beforeSql = sql;
        sql = this.getDbFeature().toPageSql(sql, start, size);
        ShardingReg.regShadingPage(beforeSql, sql, start, size);
        HoneyUtil.setPageNum(wrap.getList());
        if (this.isNeedRealTimeDb()) {
            ObjectToSQLRich.setContext(sql, wrap.getList(), tableName);
        } else {
            ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        }
        Logger.logSQL("select(entity,selectFields,start,size) SQL: ", sql);
        return sql;
    }

    private void adjustSqlServerPagingPkIfNeed(String sql, Class entityClass) {
        if (!HoneyUtil.isSqlServer()) {
            return;
        }
        String pkName = HoneyUtil.getPkFieldNameByClass(entityClass);
        if ("".equals(pkName)) {
            return;
        }
        pkName = pkName.split(",")[0];
        pkName = ObjectToSQLRich._toColumnName(pkName, entityClass);
        SqlServerPagingStruct struct = new SqlServerPagingStruct();
        struct.setJustChangeOrderColumn(true);
        struct.setOrderColumn(pkName);
        HoneyContext.setSqlServerPagingStruct(sql, struct);
    }

    public <T> String toSelectSQL(T entity, String ... fields) {
        String newSelectFields = HoneyUtil.checkAndProcessSelectField(entity, fields);
        String sql = _ObjectToSQLHelper._toSelectSQL(entity, newSelectFields);
        Logger.logSQL("select SQL(selectFields) : ", sql);
        return sql;
    }

    public <T> String toSelectOrderBySQL(T entity, String orderFieldList) {
        String[] orderFields = orderFieldList.split(",");
        StringUtils.trim(orderFields);
        int lenA = orderFields.length;
        String orderBy = "";
        for (int i = 0; i < lenA; ++i) {
            orderBy = orderBy + ObjectToSQLRich._toColumnName(orderFields[i], entity.getClass()) + " " + ASC;
            if (i >= lenA - 1) continue;
            orderBy = orderBy + ",";
        }
        ShardingReg.regShardingSort(orderBy, orderFields, null);
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        sql = sql + " " + K.orderBy + " " + orderBy;
        ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        return sql;
    }

    public <T> String toSelectOrderBySQL(T entity, String orderFieldList, OrderType[] orderTypes) {
        String[] orderFields = orderFieldList.split(",");
        StringUtils.trim(orderFields);
        int lenA = orderFields.length;
        if (lenA != orderTypes.length) {
            throw new ObjSQLException("ObjSQLException :The length of orderField is not equal orderTypes'.");
        }
        String orderBy = "";
        for (int i = 0; i < lenA; ++i) {
            orderBy = orderBy + ObjectToSQLRich._toColumnName(orderFields[i], entity.getClass()) + " " + orderTypes[i].getName();
            if (i >= lenA - 1) continue;
            orderBy = orderBy + ",";
        }
        ShardingReg.regShardingSort(orderBy, orderFields, orderTypes);
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        sql = sql + " " + K.orderBy + " " + orderBy;
        ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        return sql;
    }

    private String[] adjustVariableString(String ... fieldList) {
        if (fieldList == null) {
            return new String[]{""};
        }
        String[] fields = fieldList.length == 1 ? fieldList[0].split(",") : fieldList;
        StringUtils.trim(fields);
        return fields;
    }

    public <T> String toUpdateSQL(T entity, String ... updateFieldList) {
        if (updateFieldList == null) {
            return null;
        }
        String sql = "";
        String[] updateFields = this.adjustVariableString(updateFieldList);
        if (updateFields.length == 0 || "".equals(updateFieldList[0].trim())) {
            throw new ObjSQLException("ObjSQLException:updateFieldList at least include one field.");
        }
        sql = _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, -1);
        return sql;
    }

    public <T> String toUpdateSQL(T entity, IncludeType includeType, String ... updateFieldList) {
        if (updateFieldList == null) {
            return null;
        }
        String sql = "";
        String[] updateFields = this.adjustVariableString(updateFieldList);
        if (updateFields.length == 0 || "".equals(updateFieldList[0].trim())) {
            throw new ObjSQLException("ObjSQLException:updateFieldList at least include one field.");
        }
        sql = _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, includeType.getValue());
        return sql;
    }

    public <T> String toSelectFunSQL(T entity, FunctionType functionType, String fieldForFun, Condition condition) {
        return this._toSelectFunSQL(entity, functionType.getName(), fieldForFun, condition);
    }

    private <T> String _toSelectFunSQL(T entity, String funType, String fieldForFun, Condition condition) {
        ObjectToSQLRich.checkPackage(entity);
        if (fieldForFun == null || funType == null) {
            return null;
        }
        boolean isContainField = false;
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = null;
        try {
            String tableName = this._toTableName(entity);
            funType = FunAndOrderTypeMap.transfer(funType);
            String selectAndFun = "count".equalsIgnoreCase(funType) && "*".equals(fieldForFun) ? K.select + " " + K.count + "(*) " + K.from + " " : K.select + " " + funType + "(" + ObjectToSQLRich._toColumnName(fieldForFun, entity.getClass()) + ") " + K.from + " ";
            sqlBuffer.append(selectAndFun);
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            Field[] fields = entity.getClass().getDeclaredFields();
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (fields[i].getName().equals(fieldForFun) || "count".equalsIgnoreCase(funType) && "*".equals(fieldForFun)) {
                    isContainField = true;
                }
                if (HoneyUtil.isContinue(-1, fields[i].get(entity), fields[i])) continue;
                if (fields[i].getName().equals(fieldForFun)) {
                    isContainField = true;
                }
                if (firstWhere) {
                    sqlBuffer.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" ").append(K.and).append(" ");
                }
                sqlBuffer.append(ObjectToSQLRich._toColumnName(fields[i].getName(), entity.getClass()));
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                if (AnnoUtil.isJson(fields[i])) {
                    preparedValue.setField(fields[i]);
                }
                list.add(preparedValue);
            }
            if (condition != null) {
                condition.setSuidType(SuidType.SELECT);
                OneTimeParameter.setTrueForKey("_SYS_Bee_Select_Fun");
                OneTimeParameter.setAttribute("_SYS_Bee_COLUMN_EC", entity.getClass());
                ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere);
            }
            sql = sqlBuffer.toString();
            ObjectToSQLRich.setContext(sql, list, tableName);
            if (SqlStrFilter.checkFunSql(sql, funType)) {
                throw new ObjSQLIllegalSQLStringException("ObjSQLIllegalSQLStringException:sql statement with function is illegal. " + sql);
            }
            Logger.logSQL("select fun SQL : ", sql);
            if (!isContainField) {
                throw new ObjSQLException("ObjSQLException:Miss The Field! The entity(" + tableName + ") don't contain the field:" + fieldForFun);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public <T> String toSelectSQL(T entity, IncludeType includeType) {
        return _ObjectToSQLHelper._toSelectSQL(entity, includeType.getValue());
    }

    public <T> String toDeleteSQL(T entity, IncludeType includeType) {
        return _ObjectToSQLHelper._toDeleteSQL(entity, includeType.getValue());
    }

    public <T> String toInsertSQL(T entity, IncludeType includeType) {
        String sql = null;
        try {
            _ObjectToSQLHelper.setInitIdByAuto(entity);
            sql = _ObjectToSQLHelper._toInsertSQL0(entity, includeType.getValue(), "");
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public <T> String toUpdateSQL(T entity, IncludeType includeType) {
        String sql = "";
        sql = _ObjectToSQLHelper._toUpdateSQL(entity, includeType.getValue());
        return sql;
    }

    public <T> String[] toInsertSQL(T[] entity, int batchSize, String excludeFieldList) {
        if (HoneyUtil.isMysql()) {
            return this.toInsertSQLForMysql(entity, batchSize, excludeFieldList);
        }
        String[] sql = null;
        try {
            int len = entity.length;
            sql = new String[len];
            String t_sql = "";
            sql[0] = t_sql = _ObjectToSQLHelper._toInsertSQL0(entity[0], 2, excludeFieldList);
            for (int i = 0; i < len; ++i) {
                String sql_i = INDEX1 + i + INDEX2 + sql[0];
                if (i == 0) {
                    HoneyContext.setPreparedValue(sql_i, HoneyContext.getAndClearPreparedValue(sql[0]));
                    continue;
                }
                _ObjectToSQLHelper._toInsertSQL_for_ValueList(sql_i, entity[i], excludeFieldList);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    private <T> String[] toInsertSQLForMysql(T[] entity, int batchSize, String excludeFieldList) {
        String[] sql = null;
        try {
            int len = entity.length;
            sql = new String[len];
            String t_sql = "";
            OneTimeParameter.setTrueForKey("_SYS_Bee_Return_PlaceholderValue");
            sql[0] = t_sql = _ObjectToSQLHelper._toInsertSQL0(entity[0], 2, excludeFieldList);
            ArrayList<PreparedValue> preparedValueList = new ArrayList<PreparedValue>();
            for (int i = 0; i < len; ++i) {
                List<PreparedValue> oneRecoreList;
                String sql_i = INDEX1 + i + INDEX2 + sql[0];
                if (i == 0) {
                    oneRecoreList = HoneyContext.getAndClearPreparedValue(sql[0]);
                    HoneyContext.setPreparedValue(sql_i, oneRecoreList);
                } else {
                    oneRecoreList = _ObjectToSQLHelper._toInsertSQL_for_ValueList(sql_i, entity[i], excludeFieldList);
                }
                preparedValueList.addAll(oneRecoreList);
                if ((i + 1) % batchSize == 0) {
                    HoneyContext.setPreparedValue(t_sql + "  [Batch:" + i / batchSize + INDEX3, preparedValueList);
                    preparedValueList = new ArrayList();
                    continue;
                }
                if (i != len - 1) continue;
                HoneyContext.setPreparedValue(t_sql + "  [Batch:" + i / batchSize + INDEX3, preparedValueList);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public String toDeleteByIdSQL(Class c, Integer id) {
        if (id == null) {
            return null;
        }
        ObjectToSQLRich.checkPackageByClass(c);
        SqlValueWrap sqlBuffer = this.toDeleteByIdSQL0(c);
        String pkName = this.getPkName(c);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Integer", pkName, c);
    }

    public String toDeleteByIdSQL(Class c, Long id) {
        if (id == null) {
            return null;
        }
        ObjectToSQLRich.checkPackageByClass(c);
        SqlValueWrap sqlBuffer = this.toDeleteByIdSQL0(c);
        String pkName = this.getPkName(c);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Long", pkName, c);
    }

    public String toDeleteByIdSQL(Class c, String ids) {
        if (ids == null || "".equals(ids.trim())) {
            return null;
        }
        ObjectToSQLRich.checkPackageByClass(c);
        SqlValueWrap sqlBuffer = this.toDeleteByIdSQL0(c);
        String pkName = this.getPkName(c);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, ids, this.getIdTypeByClass(c, pkName), pkName, c);
    }

    private SqlValueWrap toDeleteByIdSQL0(Class c) {
        StringBuffer sqlBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        String tableName = this._toTableNameByClass(c);
        sqlBuffer.append(K.delete).append(" ").append(K.from).append(" ").append(tableName).append(" ").append(K.where).append(" ");
        wrap.setValueBuffer(sqlBuffer);
        wrap.setTableNames(tableName);
        return wrap;
    }

    private <T> String getPkName(T entity) {
        return this.getPkName(entity.getClass());
    }

    private String getPkName(Class c) {
        try {
            c.getDeclaredField("id");
            return "id";
        }
        catch (NoSuchFieldException e) {
            String pkName = HoneyUtil.getPkFieldNameByClass(c);
            if ("".equals(pkName)) {
                throw new ObjSQLException("No primary key in " + c.getName());
            }
            if (pkName.contains(",")) {
                throw new ObjSQLException("method of selectById just need one primary key, but more than one primary key in " + c.getName());
            }
            return pkName;
        }
    }

    public <T> String toSelectByIdSQL(Class<T> entityClazz, Integer id) {
        SqlValueWrap sqlBuffer = this.toSelectByIdSQL0(entityClazz);
        String pkName = this.getPkName(entityClazz);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Integer", pkName, entityClazz);
    }

    public <T> String toSelectByIdSQL(Class<T> entityClazz, Long id) {
        SqlValueWrap sqlBuffer = this.toSelectByIdSQL0(entityClazz);
        String pkName = this.getPkName(entityClazz);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Long", pkName, entityClazz);
    }

    public <T> String toSelectByIdSQL(Class<T> entityClazz, String ids) {
        if (ids == null || "".equals(ids.trim())) {
            return null;
        }
        SqlValueWrap sqlBuffer = this.toSelectByIdSQL0(entityClazz);
        String pkName = this.getPkName(entityClazz);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, ids, this.getIdType(entityClazz, pkName), pkName, entityClazz);
    }

    private <T> String getIdType(Class<T> entityClazz, String pkName) {
        Field field = null;
        String type = null;
        try {
            field = entityClazz.getDeclaredField(pkName);
            type = field.getType().getSimpleName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    private String getIdTypeByClass(Class c, String pkName) {
        Field field = null;
        String type = null;
        try {
            field = c.getDeclaredField(pkName);
            type = field.getType().getSimpleName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    private <T> String _toUpdateBySQL(T entity, int includeType, String ... whereFieldList) {
        if (whereFieldList == null) {
            return null;
        }
        if (whereFieldList.length == 0 || "".equals(whereFieldList[0].trim())) {
            throw new ObjSQLException("ObjSQLException:whereFieldList at least include one field.");
        }
        String sql = "";
        String[] whereFields = this.adjustVariableString(whereFieldList);
        sql = _ObjectToSQLHelper._toUpdateBySQL(entity, whereFields, includeType);
        return sql;
    }

    public <T> String toUpdateBySQL(T entity, String ... whereFieldList) {
        return this._toUpdateBySQL(entity, -1, whereFieldList);
    }

    public <T> String toUpdateBySQL(T entity, IncludeType includeType, String ... whereFieldList) {
        return this._toUpdateBySQL(entity, includeType.getValue(), whereFieldList);
    }

    public <T> String toUpdateBySQL(T entity, Condition condition, String ... whereFieldList) {
        if (whereFieldList.length == 0 || "".equals(whereFieldList[0].trim())) {
            throw new ObjSQLException("ObjSQLException:whereFieldList at least include one field.");
        }
        String[] whereFields = this.adjustVariableString(whereFieldList);
        if (condition == null || condition.getIncludeType() == null) {
            return _ObjectToSQLHelper._toUpdateBySQL(entity, whereFields, -1, condition);
        }
        return _ObjectToSQLHelper._toUpdateBySQL(entity, whereFields, condition.getIncludeType().getValue(), condition);
    }

    public <T> String toUpdateSQL(T entity, Condition condition, String ... updateFieldList) {
        String[] updateFields = this.adjustVariableString(updateFieldList);
        if (condition == null || condition.getIncludeType() == null) {
            return _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, -1, condition);
        }
        return _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, condition.getIncludeType().getValue(), condition);
    }

    private String _toSelectAndDeleteByIdSQL(SqlValueWrap wrap, Number id, String numType, String pkName, Class entityClass) {
        if (id == null) {
            return null;
        }
        StringBuffer sqlBuffer = wrap.getValueBuffer();
        sqlBuffer.append(ObjectToSQLRich._id(pkName, entityClass) + "=").append("?");
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = new PreparedValue();
        preparedValue.setType(numType);
        preparedValue.setValue(id);
        list.add(preparedValue);
        ObjectToSQLRich.setContext(sqlBuffer.toString(), list, wrap.getTableNames());
        return sqlBuffer.toString();
    }

    private String _toSelectAndDeleteByIdSQL(SqlValueWrap wrap, String ids, String idType, String pkName, Class entityClass) {
        String id0;
        StringBuffer sqlBuffer = wrap.getValueBuffer();
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        String[] idArray = ids.split(",");
        StringUtils.trim(idArray);
        String t_ids = id0 = ObjectToSQLRich._id(pkName, entityClass) + "=?";
        preparedValue = new PreparedValue();
        if (idType != null) {
            preparedValue.setType(idType);
            if ("Long".equals(idType) || "long".equals(idType)) {
                preparedValue.setValue(Long.parseLong(idArray[0]));
            } else if ("Integer".equals(idType) || "int".equals(idType)) {
                preparedValue.setValue(Integer.parseInt(idArray[0]));
            } else if ("Short".equals(idType) || "short".equals(idType)) {
                preparedValue.setValue(Short.parseShort(idArray[0]));
            } else {
                preparedValue.setValue(idArray[0]);
            }
        } else {
            preparedValue.setValue(idArray[0]);
        }
        list.add(preparedValue);
        for (int i = 1; i < idArray.length; ++i) {
            preparedValue = new PreparedValue();
            t_ids = t_ids + " " + K.or + " " + id0;
            if (idType != null) {
                preparedValue.setType(idType);
                if ("Long".equals(idType) || "long".equals(idType)) {
                    preparedValue.setValue(Long.parseLong(idArray[i]));
                } else if ("Integer".equals(idType) || "int".equals(idType)) {
                    preparedValue.setValue(Integer.parseInt(idArray[i]));
                } else if ("Short".equals(idType) || "short".equals(idType)) {
                    preparedValue.setValue(Short.parseShort(idArray[0]));
                } else {
                    preparedValue.setValue(idArray[i]);
                }
            } else {
                preparedValue.setValue(idArray[i]);
            }
            list.add(preparedValue);
        }
        sqlBuffer.append(t_ids);
        ObjectToSQLRich.setContext(sqlBuffer.toString(), list, wrap.getTableNames());
        return sqlBuffer.toString();
    }

    private <T> SqlValueWrap toSelectByIdSQL0(Class<T> entityClazz) {
        StringBuffer sqlBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        String tableName = this._toTableNameByClass(entityClazz);
        String packageAndClassName = entityClazz.getName();
        String columnNames = HoneyContext.getBeanField(packageAndClassName);
        if (columnNames == null) {
            Field[] fields = entityClazz.getDeclaredFields();
            columnNames = HoneyUtil.getBeanField(fields, entityClazz);
            HoneyContext.addBeanField(packageAndClassName, columnNames);
        }
        sqlBuffer.append(K.select).append(" ").append(columnNames).append(" ").append(K.from).append(" ");
        sqlBuffer.append(tableName).append(" ").append(K.where).append(" ");
        wrap.setValueBuffer(sqlBuffer);
        wrap.setTableNames(tableName);
        return wrap;
    }

    private <T> SqlValueWrap toSelectSQL_0(T entity) {
        return this.toSelectSQL_0(entity, null);
    }

    private <T> SqlValueWrap toSelectSQL_0(T entity, String ... selectField) {
        StringBuffer sqlBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        try {
            String tableName = "";
            if (this.isNeedRealTimeDb()) {
                tableName = (String)OneTimeParameter.getAttribute("_SYS_Bee_TableName");
                if (tableName == null) {
                    tableName = this._toTableName(entity);
                }
            } else {
                tableName = this._toTableName(entity);
            }
            Field[] fields = entity.getClass().getDeclaredFields();
            String fieldNames = "";
            if (selectField != null && !"".equals(selectField[0].trim())) {
                fieldNames = HoneyUtil.checkAndProcessSelectField(entity, selectField);
            } else {
                String packageAndClassName = entity.getClass().getName();
                fieldNames = HoneyContext.getBeanField(packageAndClassName);
                if (fieldNames == null) {
                    fieldNames = HoneyUtil.getBeanField(fields, entity.getClass());
                    HoneyContext.addBeanField(packageAndClassName, fieldNames);
                }
            }
            sqlBuffer.append(K.select).append(" ").append(fieldNames).append(" ").append(K.from).append(" ");
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(-1, fields[i].get(entity), fields[i])) continue;
                if (firstWhere) {
                    sqlBuffer.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" ").append(K.and).append(" ");
                }
                sqlBuffer.append(ObjectToSQLRich._toColumnName(fields[i].getName(), entity.getClass()));
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                if (AnnoUtil.isJson(fields[i])) {
                    preparedValue.setField(fields[i]);
                }
                list.add(preparedValue);
            }
            wrap.setTableNames(tableName);
            wrap.setSql(sqlBuffer.toString());
            wrap.setList(list);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return wrap;
    }

    private static void setContext(String sql, List<PreparedValue> list, String tableName) {
        HoneyContext.setContext(sql, list, tableName);
    }

    private static <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    public static void checkPackageByClass(Class c) {
        if (c == null) {
            return;
        }
        String classFullName = c.getName();
        if (classFullName.startsWith("java.") || classFullName.startsWith("javax.")) {
            throw new BeeIllegalEntityException("BeeIllegalEntityException: Illegal Entity, " + c.getName());
        }
    }

    private String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private String _toTableNameByClass(Class c) {
        return NameTranslateHandle.toTableName(c.getName());
    }

    private static String _toColumnName(String fieldName, Class entityClass) {
        return NameTranslateHandle.toColumnName(fieldName, entityClass);
    }

    private static String _id(String pkName, Class entityClass) {
        return NameTranslateHandle.toColumnName(pkName, entityClass);
    }

    private boolean isNeedRealTimeDb() {
        return HoneyContext.isNeedRealTimeDb();
    }
}

