/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.Set;
import org.teasoft.bee.osql.Properties;
import org.teasoft.bee.osql.annotation.SysValue;
import org.teasoft.honey.osql.core.BeeProp;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.util.GroupMap;
import org.teasoft.honey.util.ObjectCreatorFactory;
import org.teasoft.honey.util.StringUtils;

public class SysValueProcessor {
    private SysValueProcessor() {
    }

    public static <T> void process(T obj) {
        SysValueProcessor.process(obj, BeeProp.getBeeProp());
    }

    public static <T> void process(T obj, Properties prop) {
        Field[] f = obj.getClass().getDeclaredFields();
        String key = "";
        for (int i = 0; i < f.length; ++i) {
            SysValue sysValue;
            String value;
            if (!f[i].isAnnotationPresent(SysValue.class) || (value = (sysValue = f[i].getAnnotation(SysValue.class)).value()) == null || "".equals(value.trim())) continue;
            if ((value = value.trim()).startsWith("${") && value.endsWith("}")) {
                key = value.substring(2, value.length() - 1);
                String proValue = prop.getProp(key);
                if (proValue == null || StringUtils.isBlank(proValue) && !String.class.equals(f[i].getType())) continue;
                value = proValue;
            }
            try {
                Class<?> c = f[i].getType();
                f[i].setAccessible(true);
                f[i].set(obj, ObjectCreatorFactory.create(value, c));
                continue;
            }
            catch (IllegalAccessException e) {
                throw ExceptionHelper.convert(e);
            }
        }
        Set keySet = prop.getKeys();
        GroupMap gm = null;
        boolean has = false;
        for (String k : keySet) {
            if (!k.startsWith("bee.db.dbs[")) continue;
            if (!has) {
                has = true;
                gm = new GroupMap();
            }
            int end = k.indexOf(93, 11);
            String tag = k.substring(11, end);
            gm.add(tag, k.substring(end + 2), prop.getProp(k));
        }
        if (has) {
            try {
                Field dbsF = obj.getClass().getDeclaredField("dbs");
                dbsF.setAccessible(true);
                dbsF.set(obj, gm.toList());
                HoneyContext.setConfigRefresh(true);
                HoneyContext.setDsMapConfigRefresh(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

