/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.spi.JsonTransform;
import org.teasoft.honey.osql.core.JsonResultWrap;
import org.teasoft.honey.osql.core.OrderByPagingRewriteSql;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.engine.ResultMergeEngine;
import org.teasoft.honey.sharding.engine.ShardingAbstractBeeSQLExecutorEngine;
import org.teasoft.honey.sharding.engine.ThreadPoolUtil;
import org.teasoft.honey.sharding.engine.decorate.ResultPagingDecorator;
import org.teasoft.honey.sharding.engine.decorate.ShardingGroupByDecorator;
import org.teasoft.honey.sharding.engine.decorate.SortListDecorator;
import org.teasoft.honey.spi.SpiInstanceFactory;
import org.teasoft.honey.util.ObjectUtils;

public class ShardingSelectJsonEngine {
    public JsonResultWrap asynProcess(String sql, BeeSql beeSql, int opType, Class entityClass) {
        int rowCount;
        String[] sqls = null;
        String[] dsArray = null;
        List<String[]> list = ShardingUtil.hadShardingFullSelect() ? OrderByPagingRewriteSql.createSqlsForFullSelect(sql, entityClass) : OrderByPagingRewriteSql.createSqlsAndInit(sql);
        sqls = list.get(0);
        dsArray = list.get(1);
        if (sqls == null || sqls.length == 0) {
            return null;
        }
        ExecutorService executor = ThreadPoolUtil.getThreadPool(sqls.length);
        ExecutorCompletionService<String> completionService = new ExecutorCompletionService<String>(executor);
        ArrayList<ShardingBeeSQLJsonExecutorEngine> tasks = new ArrayList<ShardingBeeSQLJsonExecutorEngine>();
        for (int i = 0; sqls != null && i < sqls.length; ++i) {
            tasks.add(new ShardingBeeSQLJsonExecutorEngine(sqls[i], i + 1, beeSql, dsArray[i]));
        }
        if (sqls != null) {
            ShardingLogReg.log(sqls.length);
        }
        int size = tasks.size();
        for (int i = 0; tasks != null && i < size; ++i) {
            completionService.submit((Callable)tasks.get(i));
        }
        List<String> rsList = ResultMergeEngine.mergeJsonResult(completionService, size);
        executor.shutdown();
        String json = "";
        if (rsList.size() == 1) {
            json = rsList.get(0);
            rowCount = 1;
        } else if (rsList.size() == 0) {
            json = "[]";
            rowCount = 0;
        } else {
            JsonTransform jsonTransform = SpiInstanceFactory.getJsonTransform();
            ArrayList entityList = new ArrayList();
            for (int i = 0; i < rsList.size(); ++i) {
                if (!ObjectUtils.isNotEmpty(rsList.get(i)) || "[]".equals(rsList.get(i))) continue;
                entityList.addAll((Collection)jsonTransform.toEntity(rsList.get(i), List.class, entityClass));
            }
            ShardingGroupByDecorator.groupAndAggregateEntity(rsList);
            SortListDecorator.sort(entityList);
            ResultPagingDecorator.pagingList(entityList);
            json = jsonTransform.toJson(entityList);
            rowCount = entityList.size();
        }
        JsonResultWrap wrap = new JsonResultWrap();
        wrap.setResultJson(json);
        wrap.setRowCount(rowCount);
        return wrap;
    }

    private class ShardingBeeSQLJsonExecutorEngine
    extends ShardingAbstractBeeSQLExecutorEngine<String> {
        public ShardingBeeSQLJsonExecutorEngine(String sql, int index, BeeSql beeSql, String ds) {
            super(sql, index, beeSql, ds);
        }

        @Override
        public String shardingWork() {
            ShardingLogReg.regShardingSqlLog("selectJson SQL", this.index, this.sql);
            return this.beeSql.selectJson(this.sql);
        }
    }
}

