/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.mongodb;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.teasoft.bee.mongodb.MongoSqlStruct;
import org.teasoft.bee.mongodb.MongodbBeeSql;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.engine.ResultMergeEngine;
import org.teasoft.honey.sharding.engine.ThreadPoolUtil;
import org.teasoft.honey.sharding.engine.decorate.ResultPagingDecorator;
import org.teasoft.honey.sharding.engine.decorate.SortListDecorator;
import org.teasoft.honey.sharding.engine.mongodb.MongodbShardingRouter;
import org.teasoft.honey.sharding.engine.mongodb.ShardingAbstractMongoBeeSQLExecutorEngine;

public class MongodbShardingSelectEngine {
    private boolean showShardingSQL = this.getShowShardingSQL();

    private boolean getShowShardingSQL() {
        return HoneyConfig.getHoneyConfig().showSQL && HoneyConfig.getHoneyConfig().showShardingSQL;
    }

    public <T> List<T> asynProcess(Class<T> entityClass, MongodbBeeSql mongodbBeeSql, MongoSqlStruct struct) {
        int size;
        List<String[]> list = ShardingUtil.hadShardingFullSelect() ? MongodbShardingRouter._findDsTabForFull(entityClass) : MongodbShardingRouter._findDsTab();
        String[] dsArray = list.get(0);
        String[] tabArray = list.get(1);
        ArrayList<ShardingBeeSQLExecutorEngine<T>> tasks = new ArrayList<ShardingBeeSQLExecutorEngine<T>>();
        for (int i = 0; dsArray != null && i < dsArray.length; ++i) {
            tasks.add(new ShardingBeeSQLExecutorEngine<T>(tabArray[i], i + 1, mongodbBeeSql, dsArray[i], entityClass, struct));
        }
        if (dsArray != null) {
            ShardingLogReg.log(dsArray.length);
        }
        if ((size = tasks.size()) == 0) {
            return null;
        }
        ExecutorService executor = ThreadPoolUtil.getThreadPool(size);
        ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
        for (int i = 0; tasks != null && i < size; ++i) {
            completionService.submit((Callable)tasks.get(i));
        }
        List rsList = ResultMergeEngine.merge(completionService, size);
        executor.shutdown();
        SortListDecorator.sort(rsList);
        if (this.showShardingSQL) {
            Logger.debug("before ResultPagingDecorator, rows: " + rsList.size());
        }
        ResultPagingDecorator.pagingList(rsList);
        if (this.showShardingSQL) {
            Logger.debug("after  ResultPagingDecorator, rows: " + rsList.size());
        }
        return rsList;
    }

    private class ShardingBeeSQLExecutorEngine<T>
    extends ShardingAbstractMongoBeeSQLExecutorEngine<List<T>> {
        private Class<T> entityClass;
        private MongoSqlStruct struct;

        public ShardingBeeSQLExecutorEngine(String tab, int index, MongodbBeeSql mongodbBeeSql, String ds, Class<T> entityClass, MongoSqlStruct struct) {
            super(tab, index, mongodbBeeSql, ds);
            this.entityClass = entityClass;
            this.struct = struct.copy();
            this.struct.setTableName(tab);
        }

        @Override
        public List<T> shardingWork() {
            ShardingLogReg.regShardingSqlLog("select SQL", this.index, this.tab);
            return this.mongodbBeeSql.select(this.struct, this.entityClass);
        }
    }
}

