/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine.mongodb;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.teasoft.bee.mongodb.MongoSqlStruct;
import org.teasoft.bee.mongodb.MongodbBeeSql;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.engine.ResultMergeEngine;
import org.teasoft.honey.sharding.engine.ShardingFunResultEngine;
import org.teasoft.honey.sharding.engine.ThreadPoolUtil;
import org.teasoft.honey.sharding.engine.mongodb.MongodbShardingRouter;
import org.teasoft.honey.sharding.engine.mongodb.ShardingAbstractMongoBeeSQLExecutorEngine;

public class MongodbShardingSelectFunEngine {
    public <T> String asynProcess(Class<T> entityClass, MongodbBeeSql mongodbBeeSql, MongoSqlStruct struct) {
        int size;
        List<String[]> list = ShardingUtil.hadShardingFullSelect() ? MongodbShardingRouter._findDsTabForFull(entityClass) : MongodbShardingRouter._findDsTab();
        String[] dsArray = list.get(0);
        String[] tabArray = list.get(1);
        ArrayList<ShardingBeeSQLFunExecutorEngine> tasks = new ArrayList<ShardingBeeSQLFunExecutorEngine>();
        for (int i = 0; dsArray != null && i < dsArray.length; ++i) {
            tasks.add(new ShardingBeeSQLFunExecutorEngine(tabArray[i], i + 1, mongodbBeeSql, dsArray[i], entityClass, struct));
        }
        if (dsArray != null) {
            ShardingLogReg.log(dsArray.length);
        }
        if ((size = tasks.size()) == 0) {
            return null;
        }
        ExecutorService executor = ThreadPoolUtil.getThreadPool(size);
        ExecutorCompletionService<String> completionService = new ExecutorCompletionService<String>(executor);
        for (int i = 0; tasks != null && i < size; ++i) {
            completionService.submit((Callable)tasks.get(i));
        }
        List<String> rsList = ResultMergeEngine.mergeFunResult(completionService, size);
        executor.shutdown();
        return ShardingFunResultEngine.funResultEngine(rsList);
    }

    private class ShardingBeeSQLFunExecutorEngine
    extends ShardingAbstractMongoBeeSQLExecutorEngine<String> {
        private Class entityClass;
        private MongoSqlStruct struct;

        public ShardingBeeSQLFunExecutorEngine(String tab, int index, MongodbBeeSql mongodbBeeSql, String ds, Class entityClass, MongoSqlStruct struct) {
            super(tab, index, mongodbBeeSql, ds);
            this.entityClass = entityClass;
            this.struct = struct.copy();
            this.struct.setTableName(tab);
        }

        @Override
        public String shardingWork() {
            ShardingLogReg.regShardingSqlLog("select fun SQL", this.index, this.tab);
            String rsStr = "";
            String typeTag = "";
            typeTag = "select fun";
            String funType = HoneyContext.getSysCommStrLocal("_SYS_Bee_FunType");
            rsStr = FunctionType.COUNT.getName().equalsIgnoreCase(funType) ? this.mongodbBeeSql.count(this.struct, this.entityClass) : this.mongodbBeeSql.selectWithFun(this.struct, this.entityClass);
            ShardingLogReg.regShardingSqlLog("    | <--  " + typeTag, this.index, rsStr);
            return rsStr;
        }
    }
}

