/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.util.DateUtil;

public class IntSerialId {
    private AtomicInteger sequenceNumber = null;
    private static final long sequence = 1L;
    private long startTime;
    private static final long shift = 9L;
    private long startSecond = this.getStartSecond();
    private int initNum;
    private static long defaultStart = 1640966400L;

    public IntSerialId() {
        this.startTime = this._curSecond();
        long ll = (this.startTime - this.startSecond) / 60L;
        this.initNum = (int)(ll << 9 | 1L);
        this.sequenceNumber = new AtomicInteger(this.initNum);
    }

    private long _curSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    public synchronized int get() {
        int id = this.sequenceNumber.getAndIncrement();
        this.testSpeedLimit(id);
        return id;
    }

    public synchronized int[] getRangeId(int sizeOfIds) {
        int[] r;
        int a = this.sequenceNumber.getAndIncrement();
        r = new int[]{a, r[0] + sizeOfIds - 1};
        this.setSequenceNumber(a + sizeOfIds);
        this.testSpeedLimit(r[1]);
        return r;
    }

    private void setSequenceNumber(int newNum) {
        this.sequenceNumber.set(newNum);
    }

    private synchronized void testSpeedLimit(long currentLong) {
        long spentTime = (this._curSecond() - this.startTime) / 60L + 1L + 2L;
        if (spentTime > 0L && spentTime << 9 > currentLong - (long)this.initNum) {
            return;
        }
        try {
            this.wait(10L);
            this.testSpeedLimit(currentLong);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    private long getStartSecond() {
        int startYear = HoneyConfig.getHoneyConfig().genid_startYear;
        if (startYear < 1970) {
            return defaultStart;
        }
        long newTime = DateUtil.toTimestamp(startYear + "-01-01 00:00:00").getTime();
        return newTime / 1000L;
    }
}

