/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util;

import java.util.Map;
import java.util.TreeMap;
import org.teasoft.bee.osql.LowerKey;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.util.EntityUtil;
import org.teasoft.honey.util.StringUtils;

public class SqlKeyCheck {
    private static final String ONE = "1";
    private static Map<String, String> keyMap = new TreeMap<String, String>();
    private static final String keyStr = "table,column,key,Explain,comment,group,By,order,Null,is,for,inner,left,right,join";

    private SqlKeyCheck() {
    }

    private static void initKeyMap(String keyStr) {
        String[] keys = keyStr.split(",");
        for (int i = 0; i < keys.length; ++i) {
            keyMap.put(keys[i].toLowerCase(), ONE);
        }
    }

    private static void initKeyMap2(String keyStr) {
        String[] keys = keyStr.split(",");
        for (int i = 0; i < keys.length; ++i) {
            if (StringUtils.isContainUpperCase(keys[i])) continue;
            keyMap.put(keys[i].toLowerCase(), ONE);
        }
    }

    public static boolean isKeyWord(String word) {
        return keyMap.containsKey(word.toLowerCase());
    }

    static {
        SqlKeyCheck.initKeyMap(keyStr);
        if (HoneyUtil.isOracle()) {
            String oracleKey = "user,level,role";
            SqlKeyCheck.initKeyMap(oracleKey);
        }
        String fs = EntityUtil.getFieldNames(new LowerKey());
        SqlKeyCheck.initKeyMap2(fs);
    }
}

