/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.util.currency;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class CurrencyArithmetic {
    private static RoundingMode DEFAULT_ROUND_MODE = RoundingMode.HALF_UP;
    private static int SCALE = 2;

    private CurrencyArithmetic() {
    }

    public static String add(String a, String b) {
        BigDecimal one = new BigDecimal(a);
        BigDecimal two = new BigDecimal(b);
        BigDecimal r = one.add(two);
        return r.toPlainString();
    }

    public static String subtract(String a, String b) {
        BigDecimal one = new BigDecimal(a);
        BigDecimal two = new BigDecimal(b);
        BigDecimal r = one.subtract(two);
        return r.toPlainString();
    }

    public static String multiply(String a, String b) {
        BigDecimal one = new BigDecimal(a);
        BigDecimal two = new BigDecimal(b);
        BigDecimal r = one.multiply(two);
        return r.toPlainString();
    }

    public static String divide(String a, String b) {
        return CurrencyArithmetic.divide(a, b, SCALE, DEFAULT_ROUND_MODE);
    }

    public static String divide(String a, String b, int scale, RoundingMode roundingMode) {
        BigDecimal one = new BigDecimal(a);
        BigDecimal two = new BigDecimal(b);
        BigDecimal r = one.divide(two, scale, roundingMode);
        return r.toPlainString();
    }

    public static String calculate(String a, String op, String b) {
        return CurrencyArithmetic.calculate(a, op, b, SCALE);
    }

    public static String calculate(String a, String op, String b, int scale) {
        return CurrencyArithmetic.calculate(a, op, b, scale, DEFAULT_ROUND_MODE);
    }

    public static String remainder(String a, String b) {
        BigDecimal one = new BigDecimal(a);
        BigDecimal two = new BigDecimal(b);
        BigDecimal r = one.remainder(two);
        return r.toPlainString();
    }

    public static String calculate(String a, String op, String b, int scale, RoundingMode roundingMode) {
        if ("+".equals(op)) {
            return CurrencyArithmetic.add(a, b);
        }
        if ("-".equals(op)) {
            return CurrencyArithmetic.subtract(a, b);
        }
        if ("*".equals(op)) {
            return CurrencyArithmetic.multiply(a, b);
        }
        if ("/".equals(op)) {
            return CurrencyArithmetic.divide(a, b, scale, DEFAULT_ROUND_MODE);
        }
        if ("%".equals(op)) {
            return CurrencyArithmetic.remainder(a, b);
        }
        return null;
    }
}

