/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.teasoft.bee.logging.Log;

public class Jdk14LoggingImpl
implements Log {
    private Logger log;
    private String loggerName;

    public Jdk14LoggingImpl(String loggerName) {
        this.loggerName = loggerName;
        this.log = Logger.getLogger(loggerName);
    }

    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    public void error(String msg, Throwable e) {
        this.log.logp(Level.SEVERE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), msg, e);
    }

    public void error(String msg) {
        this.log.logp(Level.SEVERE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), msg);
    }

    public void debug(String msg) {
        this.log.logp(Level.FINE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), msg);
    }

    public void debug(String msg, Throwable e) {
        this.log.logp(Level.FINE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), msg, e);
    }

    public void warn(String msg) {
        this.log.logp(Level.WARNING, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), msg);
    }

    public void warn(String msg, Throwable e) {
        this.log.logp(Level.WARNING, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), msg, e);
    }

    public void info(String msg) {
        this.log.logp(Level.INFO, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), msg);
    }

    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.log.isLoggable(Level.WARNING);
    }

    public boolean isTraceEnabled() {
        return this.log.isLoggable(Level.FINER);
    }

    public void trace(String msg) {
        this.log.logp(Level.FINER, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), msg);
    }

    public boolean isErrorEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }
}

