/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.autogen;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.teasoft.bee.osql.exception.BeeErrorNameException;
import org.teasoft.honey.osql.autogen.Java2DbType;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.osql.util.AnnoUtil;
import org.teasoft.honey.osql.util.NameCheckUtil;
import org.teasoft.honey.util.EntityUtil;
import org.teasoft.honey.util.SqlKeyCheck;
import org.teasoft.honey.util.StringUtils;

public class DdlToSql {
    private static final String BE_REPLACE_WITH_TYPE = "It will be replace with type: ";
    private static final String NOT_RELATIVE_COLUMN = " has not the relative database column type!";
    private static final String THE_JAVA_TYPE = "The java type:";
    private static final String CREATE_TABLE = "CREATE TABLE ";
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Map<String, String> pkStatement = new HashMap<String, String>();
    private static Map<String, String> pkStringStatement = new HashMap<String, String>();
    private static String java_lang_String = "java.lang.String";

    public static <T> String toCreateTableSQL(T entity) {
        return DdlToSql.toCreateTableSQL(entity.getClass(), null);
    }

    public static <T> String toCreateTableSQL(Class<T> entityClass) {
        String tableName = DdlToSql._toTableNameByClass(entityClass);
        return DdlToSql.toCreateTableSQL(entityClass, tableName);
    }

    public static <T> String toCreateTableSQL(Class<T> entityClass, String tableName) {
        if (HoneyUtil.isSQLite()) {
            return DdlToSql.toCreateTableSQLForSQLite(entityClass, tableName);
        }
        if (HoneyUtil.isMysql()) {
            return DdlToSql.toCreateTableSQLForMySQL(entityClass, tableName);
        }
        if ("H2".equalsIgnoreCase(HoneyContext.getDbDialect())) {
            return DdlToSql.toCreateTableSQLForH2(entityClass, tableName);
        }
        if ("PostgreSQL".equalsIgnoreCase(HoneyContext.getDbDialect())) {
            return DdlToSql.toCreateTableSQLForPostgreSQL(entityClass, tableName);
        }
        if (HoneyUtil.isSqlServer()) {
            return DdlToSql.toCreateTableSQLForSQLSERVER(entityClass, tableName);
        }
        return DdlToSql._toCreateTableSQL(entityClass, tableName);
    }

    private static <T> String _toCreateTableSQL(Class<T> entityClass, String tableName) {
        if (tableName == null) {
            tableName = DdlToSql._toTableNameByClass(entityClass);
        }
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(CREATE_TABLE + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entityClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (DdlToSql.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(DdlToSql._toColumnName(fields[i].getName(), entityClass)).append("  ");
            String type = DdlToSql.getType(fields[i]);
            if (HoneyUtil.isCassandra()) {
                if (EntityUtil.isList(fields[i]) || EntityUtil.isSet(fields[i])) {
                    Class<?> clazz = EntityUtil.getGenericType(fields[i]);
                    String type0 = DdlToSql.getType(clazz);
                    type = type + "<" + type0 + ">";
                } else if (EntityUtil.isMap(fields[i])) {
                    Class<?>[] classes = EntityUtil.getGenericTypeArray(fields[i]);
                    String type1 = DdlToSql.getType(classes[0]);
                    String type2 = DdlToSql.getType(classes[1]);
                    type = type + "<" + type1 + "," + type2 + ">";
                }
            }
            sqlBuffer.append(type);
            if (DdlToSql.isPrimaryKey(fields[i])) {
                sqlBuffer.append(" PRIMARY KEY");
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    private static Map<String, String> getJava2DbType() {
        return Java2DbType.getJava2DbType(HoneyContext.getDbDialect());
    }

    private static String getType(Field field) {
        String type = DdlToSql.getJava2DbType().get(field.getType().getName());
        if (type == null) {
            Logger.warn(THE_JAVA_TYPE + type + NOT_RELATIVE_COLUMN);
            type = DdlToSql.getJava2DbType().get(java_lang_String);
            Logger.warn(BE_REPLACE_WITH_TYPE + type);
        }
        return type;
    }

    private static String getType(Class<?> c) {
        String name = "";
        if (c == null) {
            Logger.warn("The Class is null,it will be replace with " + java_lang_String);
            name = java_lang_String;
        } else {
            name = c.getName();
        }
        String type = DdlToSql.getJava2DbType().get(name);
        if (type == null) {
            if (EntityUtil.isCustomBean(name) && c != null) {
                type = NameUtil.firstLetterToLowerCase(c.getSimpleName());
            } else {
                Logger.warn(THE_JAVA_TYPE + name + NOT_RELATIVE_COLUMN);
                type = DdlToSql.getJava2DbType().get(java_lang_String);
                Logger.warn(BE_REPLACE_WITH_TYPE + type);
            }
        }
        return type;
    }

    private static <T> String toCreateTableSQLForSQLite(Class<T> entityClass, String tableName) {
        return DdlToSql.toCreateTableSQLComm(entityClass, tableName, "SQLite");
    }

    private static <T> String toCreateTableSQLForMySQL(Class<T> entityClass, String tableName) {
        if (tableName == null) {
            tableName = DdlToSql._toTableNameByClass(entityClass);
        }
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(CREATE_TABLE + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entityClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (DdlToSql.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(DdlToSql._toColumnName(fields[i].getName(), entityClass)).append("  ");
            if (DdlToSql.isPrimaryKey(fields[i])) {
                String type;
                String pkSt = "bigint(20) PRIMARY KEY NOT NULL AUTO_INCREMENT";
                if (String.class.equals(fields[i].getType()) && (type = DdlToSql.getJava2DbType().get(fields[i].getType().getName())) != null) {
                    pkSt = "varchar(255) PRIMARY KEY NOT NULL";
                }
                sqlBuffer.append(pkSt);
            } else {
                String type = DdlToSql.getJava2DbType().get(fields[i].getType().getName());
                if (type == null) {
                    Logger.warn(THE_JAVA_TYPE + type + NOT_RELATIVE_COLUMN);
                    type = DdlToSql.getJava2DbType().get(java_lang_String);
                    Logger.warn(BE_REPLACE_WITH_TYPE + type);
                }
                sqlBuffer.append(type);
                if ("timestamp".equalsIgnoreCase(type) || "datetime".equalsIgnoreCase(type)) {
                    sqlBuffer.append(" DEFAULT CURRENT_TIMESTAMP");
                } else {
                    sqlBuffer.append(" DEFAULT NULL");
                }
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    private static <T> String toCreateTableSQLForH2(Class<T> entityClass, String tableName) {
        return DdlToSql.toCreateTableSQLComm(entityClass, tableName, "H2");
    }

    private static <T> String toCreateTableSQLComm(Class<T> entityClass, String tableName, String databaseName) {
        if (tableName == null) {
            tableName = DdlToSql._toTableNameByClass(entityClass);
        }
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(CREATE_TABLE + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entityClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (DdlToSql.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(DdlToSql._toColumnName(fields[i].getName(), entityClass)).append("  ");
            if (DdlToSql.isPrimaryKey(fields[i])) {
                if (!String.class.equals(fields[i].getType())) {
                    sqlBuffer.append(DdlToSql.getPrimaryKeyStatement(databaseName));
                } else {
                    sqlBuffer.append(DdlToSql.getStringPrimaryKeyStatement(databaseName));
                }
            } else {
                String type = DdlToSql.getJava2DbType().get(fields[i].getType().getName());
                if (type == null) {
                    Logger.warn(THE_JAVA_TYPE + type + NOT_RELATIVE_COLUMN);
                    type = DdlToSql.getJava2DbType().get(java_lang_String);
                    Logger.warn(BE_REPLACE_WITH_TYPE + type);
                }
                sqlBuffer.append(type);
                if ("timestamp".equalsIgnoreCase(type) || "datetime".equalsIgnoreCase(type)) {
                    sqlBuffer.append(" DEFAULT CURRENT_TIMESTAMP");
                } else {
                    sqlBuffer.append(" DEFAULT NULL");
                }
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    private static <T> String toCreateTableSQLForPostgreSQL(Class<T> entityClass, String tableName) {
        return DdlToSql.toCreateTableSQLComm(entityClass, tableName, "PostgreSQL");
    }

    private static <T> String toCreateTableSQLForSQLSERVER(Class<T> entityClass, String tableName) {
        if (tableName == null) {
            tableName = DdlToSql._toTableNameByClass(entityClass);
        }
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(CREATE_TABLE + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entityClass.getDeclaredFields();
        boolean hasCurrentTime = false;
        for (int i = 0; i < fields.length; ++i) {
            if (DdlToSql.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(DdlToSql._toColumnName(fields[i].getName(), entityClass)).append("  ");
            if (DdlToSql.isPrimaryKey(fields[i])) {
                String type;
                String pkSt = "bigint PRIMARY KEY NOT NULL";
                if (String.class.equals(fields[i].getType()) && (type = DdlToSql.getJava2DbType().get(fields[i].getType().getName())) != null) {
                    pkSt = pkSt.replace("bigint", type);
                }
                sqlBuffer.append(pkSt);
            } else {
                String type = DdlToSql.getJava2DbType().get(fields[i].getType().getName());
                if (type == null) {
                    Logger.warn(THE_JAVA_TYPE + type + NOT_RELATIVE_COLUMN);
                    type = DdlToSql.getJava2DbType().get(java_lang_String);
                    Logger.warn(BE_REPLACE_WITH_TYPE + type);
                }
                if ("timestamp".equalsIgnoreCase(type)) {
                    if (!hasCurrentTime) {
                        sqlBuffer.append(type);
                        sqlBuffer.append(" ");
                        hasCurrentTime = true;
                    } else {
                        sqlBuffer.append("datetime DEFAULT NULL");
                    }
                } else {
                    sqlBuffer.append(type);
                    sqlBuffer.append(" DEFAULT NULL");
                }
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    private static String _toColumnName(String fieldName, Class entityClass) {
        String name = NameTranslateHandle.toColumnName(fieldName, entityClass);
        if (SqlKeyCheck.isKeyWord(name)) {
            Logger.warn("The '" + name + "' is Sql Keyword. Do not recommend!");
        }
        return name;
    }

    private static boolean isSkipField(Field field) {
        return HoneyUtil.isSkipField(field);
    }

    private static boolean isPrimaryKey(Field field) {
        if ("id".equalsIgnoreCase(field.getName())) {
            return true;
        }
        return AnnoUtil.isPrimaryKey(field);
    }

    public static String getPrimaryKeyStatement(String databaseName) {
        if (databaseName != null) {
            databaseName = databaseName.toLowerCase();
        }
        return pkStatement.get(databaseName);
    }

    public static String getStringPrimaryKeyStatement(String databaseName) {
        if (databaseName != null) {
            databaseName = databaseName.toLowerCase();
        }
        return pkStringStatement.get(databaseName);
    }

    private static void initStringPkStatement() {
        pkStringStatement.put("H2".toLowerCase(), "varchar(255) PRIMARY KEY NOT NULL");
        pkStringStatement.put("SQLite".toLowerCase(), " VARCHAR2(255) PRIMARY KEY NOT NULL");
        pkStringStatement.put("PostgreSQL".toLowerCase(), "varchar(255) PRIMARY KEY NOT NULL");
        pkStringStatement.put("", "varchar(255) PRIMARY KEY NOT NULL");
        pkStringStatement.put(null, "varchar(255) PRIMARY KEY NOT NULL");
    }

    private static void initPkStatement() {
        pkStatement.put("H2".toLowerCase(), "bigint PRIMARY KEY NOT NULL");
        pkStatement.put("SQLite".toLowerCase(), " INTEGER PRIMARY KEY NOT NULL");
        pkStatement.put("PostgreSQL".toLowerCase(), "bigserial NOT NULL");
        pkStatement.put("", "bigint PRIMARY KEY NOT NULL");
        pkStatement.put(null, "bigint PRIMARY KEY NOT NULL");
    }

    private static String _toTableNameByClass(Class c) {
        return NameTranslateHandle.toTableName(c.getName());
    }

    public static <T> String toDropTableSql(Class<T> entityClass) {
        String tableName = DdlToSql._toTableNameByClass(entityClass);
        String sql0 = "";
        sql0 = HoneyUtil.isOracle() || HoneyUtil.isSqlServer() ? "DROP TABLE " + tableName : " DROP TABLE IF EXISTS " + tableName;
        return sql0;
    }

    public static <T> String toDropTableSimpleSql(Class<T> entityClass) {
        String tableName = DdlToSql._toTableNameByClass(entityClass);
        String sql0 = "";
        sql0 = "DROP TABLE " + tableName;
        return sql0;
    }

    private static String transferField(String fields, Class c) {
        String[] str = fields.split(",");
        String columns = "";
        for (int i = 0; i < str.length; ++i) {
            if (i != 0) {
                columns = columns + ",";
            }
            columns = columns + DdlToSql._toColumnName(str[i].trim(), c);
        }
        return columns;
    }

    private static void checkField(String fields) {
        NameCheckUtil.checkName(fields);
    }

    public static <T> String toPrimaryKeySql(Class<T> entityClass, String fields, String keyName) {
        String PREFIX = "pk_";
        String typeTip = "normal";
        if (StringUtils.isBlank(fields)) {
            throw new BeeErrorNameException("Create " + typeTip + " index, the fields can not be empty!");
        }
        DdlToSql.checkField(fields);
        String tableName = DdlToSql._toTableNameByClass(entityClass);
        String columns = DdlToSql.transferField(fields, entityClass);
        if (StringUtils.isBlank(keyName)) {
            keyName = PREFIX + tableName + "_" + columns.replace(",", "_");
        } else {
            DdlToSql.checkField(keyName);
        }
        String indexSql = "ALTER TABLE " + tableName + " ADD CONSTRAINT " + keyName + " PRIMARY KEY (" + columns + ")";
        return indexSql;
    }

    public static <T> String toIndexSql(Class<T> entityClass, String fields, String indexName, String PREFIX, String IndexTypeTip, String IndexType) {
        if (StringUtils.isBlank(fields)) {
            throw new BeeErrorNameException("Create " + IndexTypeTip + " index, the fields can not be empty!");
        }
        DdlToSql.checkField(fields);
        String tableName = DdlToSql._toTableNameByClass(entityClass);
        String columns = DdlToSql.transferField(fields, entityClass);
        if (StringUtils.isBlank(indexName)) {
            indexName = PREFIX + tableName + "_" + columns.replace(",", "_");
        } else {
            DdlToSql.checkField(indexName);
        }
        String indexSql = "CREATE " + IndexType + "INDEX " + indexName + " ON " + tableName + "(" + columns + ")";
        return indexSql;
    }

    public static <T> String toDropIndexSql(Class<T> entityClass, String indexName) {
        String tableName = DdlToSql._toTableNameByClass(entityClass);
        if (indexName != null) {
            String dropSql = "";
            dropSql = HoneyUtil.isSqlServer() ? "DROP INDEX table_name.index_name" : (HoneyUtil.isOracle() || HoneyUtil.isSQLite() || "DB2".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName()) ? "DROP INDEX index_name" : (HoneyUtil.isMysql() || "Microsoft Access".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName()) ? "DROP INDEX index_name ON table_name" : "DROP INDEX index_name"));
            return dropSql.replace("table_name", tableName).replace("index_name", indexName);
        }
        return "drop index all on " + tableName;
    }

    static {
        DdlToSql.initPkStatement();
        DdlToSql.initStringPkStatement();
    }
}

