/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.sql.BatchUpdateException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.List;
import org.teasoft.bee.osql.Cache;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.type.TypeHandler;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.util.AnnoUtil;
import org.teasoft.honey.sharding.ShardingUtil;

public abstract class AbstractBase {
    private int cacheWorkResultSetSize;
    private boolean showSQL;
    private boolean showShardingSQL;
    protected static boolean openFieldTypeHandler = HoneyConfig.getHoneyConfig().openFieldTypeHandler;
    private Cache cache;
    protected static final String INDEX1 = "_SYS[index";
    protected static final String INDEX2 = "]_End ";

    public AbstractBase() {
        this.cacheWorkResultSetSize = HoneyConfig.getHoneyConfig().cache_workResultSetSize;
        this.showSQL = this.getShowSQL();
        this.showShardingSQL = this.getShowShardingSQL();
    }

    public Cache getCache() {
        if (this.cache == null) {
            this.cache = BeeFactory.getHoneyFactory().getCache();
        }
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    protected static String _toColumnName(String fieldName, Class entityClass) {
        return NameTranslateHandle.toColumnName(fieldName, entityClass);
    }

    protected void addInCache(String sql, Object rs, int resultSetSize) {
        if (HoneyContext.getSqlIndexLocal() != null) {
            return;
        }
        if (resultSetSize > this.cacheWorkResultSetSize) {
            HoneyContext.deleteCacheInfo(sql);
            return;
        }
        this.getCache().add(sql, rs);
    }

    protected boolean updateInfoInCache(String sql, String returnType, SuidType suidType, Class entityClass) {
        if (HoneyContext.getSqlIndexLocal() != null) {
            return false;
        }
        return HoneyContext.updateInfoInCache(sql, returnType, suidType, entityClass);
    }

    protected void clearInCache(String sql, String returnType, SuidType suidType, int affectRow) {
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            struct.setReturnType(returnType);
            struct.setSuidType(suidType.getType());
            HoneyContext.setCacheInfo(sql, struct);
        }
        this.clearContext(sql);
        if (affectRow > 0) {
            this.getCache().clear(sql);
        }
    }

    protected void clearContext(String sql) {
        HoneyContext.clearPreparedValue(sql);
    }

    protected void initRoute(SuidType suidType, Class clazz, String sql) {
        boolean enableMultiDs = HoneyConfig.getHoneyConfig().multiDS_enable;
        if (!enableMultiDs && !HoneyContext.useStructForLevel2()) {
            return;
        }
        if (HoneyContext.isNeedRealTimeDb() && HoneyContext.isAlreadySetRoute()) {
            return;
        }
        HoneyContext.initRoute(suidType, clazz, sql);
    }

    protected boolean isConfuseDuplicateFieldDB() {
        return HoneyUtil.isConfuseDuplicateFieldDB();
    }

    protected void logSelectRows(int size) {
        if (ShardingUtil.isSharding() && !this.showShardingSQL) {
            return;
        }
        Logger.logSQL(" | <--  select rows: ", size + "" + this.shardingIndex());
    }

    protected void logAffectRow(int num) {
        if (ShardingUtil.isSharding() && !this.showShardingSQL) {
            return;
        }
        Logger.logSQL(" | <--  Affected rows: ", num + "" + this.shardingIndex());
    }

    protected void logDsTab() {
        if (!this.showShardingSQL) {
            return;
        }
        List<String> dsNameListLocal = HoneyContext.getListLocal("_SYS_Bee_DsNameListLocal");
        List<String> tabNameList = HoneyContext.getListLocal("_SYS_Bee_TabNameListLocal");
        Logger.logSQL("========= Involved DataSource: " + dsNameListLocal + "  ,Involved Table: " + tabNameList);
    }

    protected static void logSQL(String hardStr) {
        Logger.logSQL(hardStr);
    }

    protected void clearContext(String sql_0, int batchSize, int len) {
        for (int i = 0; i < len; ++i) {
            String sql_i = INDEX1 + i + INDEX2 + sql_0;
            this.clearContext(sql_i);
        }
    }

    protected boolean isJoson(Field field) {
        return AnnoUtil.isJson(field);
    }

    protected Object jsonHandlerProcess(Field field, Object obj, TypeHandler jsonHandler) {
        if (List.class.isAssignableFrom(field.getType())) {
            Object[] newObj = new Object[]{obj, field};
            obj = jsonHandler.process(field.getType(), (Object)newObj);
        } else {
            obj = jsonHandler.process(field.getType(), obj);
        }
        return obj;
    }

    protected Object createObject(Class c) throws IllegalAccessException, InstantiationException {
        return c.newInstance();
    }

    protected String shardingIndex() {
        Integer subThreadIndex = HoneyContext.getSqlIndexLocal();
        String index = "";
        if (subThreadIndex != null) {
            index = " (sharding " + subThreadIndex + ")";
        }
        return index;
    }

    protected boolean getShowSQL() {
        return HoneyConfig.getHoneyConfig().showSQL;
    }

    protected boolean getShowShardingSQL() {
        return this.showSQL && HoneyConfig.getHoneyConfig().showShardingSQL;
    }

    protected boolean isConstraint(Exception e) {
        boolean f;
        if (e == null) {
            return false;
        }
        String className = e.getClass().getSimpleName();
        String fullClassName = e.getClass().getName();
        boolean bl = f = "MySQLIntegrityConstraintViolationException".equals(className) || e instanceof SQLIntegrityConstraintViolationException || e instanceof BatchUpdateException || "org.h2.jdbc.JdbcBatchUpdateException".equals(fullClassName);
        if (f) {
            return true;
        }
        if (e.getMessage() == null) {
            return false;
        }
        return e.getMessage().startsWith("Duplicate entry ") || e.getMessage().contains("ORA-00001:") || e.getMessage().contains("duplicate key") || e.getMessage().contains("DUPLICATE KEY") || e.getMessage().contains("primary key violation") || e.getMessage().contains("SQLITE_CONSTRAINT_PRIMARYKEY") || e.getMessage().contains("PRIMARY KEY constraint") || e.getMessage().contains("Duplicate entry") || e.getMessage().contains("Duplicate Entry") || e.getMessage().contains("Duplicate key") || e.getMessage().contains("Duplicate Key");
    }
}

