/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.io.Serializable;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.teasoft.bee.spi.JsonTransform;
import org.teasoft.bee.spi.PreLoad;
import org.teasoft.bee.spi.SqlFormat;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.spi.SpiInstanceRegister;

public class BeeInitPreLoadService {
    static boolean notStart = true;

    static void initLoad() {
        if (notStart) {
            notStart = false;
            Logger.info("[Bee] ========= BeeInitPreLoadService initLoad...");
            BeeInitPreLoadService.loadServiceInstance(PreLoad.class);
            BeeInitPreLoadService.loadServiceInstanceAndReg(JsonTransform.class);
            BeeInitPreLoadService.loadServiceInstanceAndReg(SqlFormat.class);
        }
    }

    private static <T> void loadServiceInstance(Class<T> clazz) {
        ServiceLoader<T> loads = ServiceLoader.load(clazz);
        Iterator<T> loadIterator = loads.iterator();
        while (loadIterator.hasNext()) {
            try {
                loadIterator.next();
            }
            catch (ServiceConfigurationError e) {
                Logger.error(e.getMessage(), e);
            }
        }
    }

    private static <T extends Serializable> void loadServiceInstanceAndReg(Class<T> clazz) {
        ServiceLoader<T> loads = ServiceLoader.load(clazz);
        Iterator<T> loadIterator = loads.iterator();
        while (loadIterator.hasNext()) {
            try {
                Serializable obj = (Serializable)loadIterator.next();
                SpiInstanceRegister.register(clazz, obj);
            }
            catch (ServiceConfigurationError e) {
                Logger.error(e.getMessage(), e);
            }
        }
    }

    public static void init() {
        Logger.info("[Bee] ========= BeeInitPreLoadService init...");
    }

    static boolean isNotStart() {
        return notStart;
    }

    static void setNotStart(boolean notStart) {
        BeeInitPreLoadService.notStart = notStart;
    }

    static {
        BeeInitPreLoadService.initLoad();
    }
}

