/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.teasoft.bee.osql.BeeExtCache;
import org.teasoft.honey.distribution.ds.RouteStruct;
import org.teasoft.honey.osql.core.CacheKey;
import org.teasoft.honey.osql.core.CacheUtil;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.Logger;

public class DefaultBeeExtCache
implements BeeExtCache {
    private static final long serialVersionUID = 1596710362358L;
    private static String logCache2Msg = "==========get from Level 2 Cache.";
    private static boolean isShowSql = false;
    private static ConcurrentMap<String, Set<String>> map_tableSqlKey;

    private static boolean getUseLevelTwo() {
        return HoneyConfig.getHoneyConfig().cache_useLevelTwo;
    }

    private static boolean getLevelOneTolevelTwo() {
        return HoneyConfig.getHoneyConfig().cache_levelOneTolevelTwo;
    }

    public Object get(String sql) {
        boolean isModified;
        Object obj = CacheUtil.get(sql);
        if (DefaultBeeExtCache.getUseLevelTwo() && obj == null && !(isModified = this.getModified(sql))) {
            boolean canGetInLevelTow = false;
            if (DefaultBeeExtCache.getLevelOneTolevelTwo()) {
                canGetInLevelTow = true;
            } else {
                RouteStruct routeStruct = HoneyContext.getCurrentRoute();
                boolean f2 = HoneyContext.isConfigLevelTwoCache(routeStruct.getEntityClass());
                if (f2) {
                    canGetInLevelTow = true;
                }
            }
            if (canGetInLevelTow) {
                String key = CacheKey.genKey(sql);
                try {
                    obj = this.getInExtCache(key);
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), e);
                }
                if (isShowSql && obj != null) {
                    Logger.logSQL(logCache2Msg, "");
                }
            }
        }
        return obj;
    }

    private boolean getModified(String sql) {
        boolean isModified = false;
        List<String> tableNameList = CacheKey.genTableNameList(sql);
        for (int j = 0; tableNameList != null && j < tableNameList.size(); ++j) {
            isModified = HoneyContext.getModifiedFlagForCache2(tableNameList.get(j)) || isModified;
        }
        return isModified;
    }

    public void add(String sql, Object result) {
        boolean f = CacheUtil.add(sql, result);
        if (DefaultBeeExtCache.getUseLevelTwo()) {
            boolean isModified = this.getModified(sql);
            if (!isModified) {
                boolean canAddInLevelTow = false;
                if (f && DefaultBeeExtCache.getLevelOneTolevelTwo()) {
                    canAddInLevelTow = true;
                } else {
                    RouteStruct routeStruct = HoneyContext.getCurrentRoute();
                    boolean f2 = HoneyContext.isConfigLevelTwoCache(routeStruct.getEntityClass());
                    if (f2) {
                        canAddInLevelTow = true;
                    }
                }
                if (canAddInLevelTow) {
                    String key = CacheKey.genKey(sql);
                    try {
                        this.addInExtCache(key, result);
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage(), e);
                    }
                    List<String> tableNameList = CacheKey.genTableNameList(sql);
                    for (int j = 0; tableNameList != null && j < tableNameList.size(); ++j) {
                        this._regTabCache(tableNameList.get(j), key);
                    }
                }
            }
            if (f) {
                HoneyContext.deleteCacheInfo(sql);
            }
        }
    }

    private void _regTabCache(String tableName, String sqlKey) {
        LinkedHashSet<String> set = (LinkedHashSet<String>)map_tableSqlKey.get(tableName);
        if (set != null) {
            set.add(sqlKey);
        } else {
            set = new LinkedHashSet<String>();
            set.add(sqlKey);
            map_tableSqlKey.put(tableName, set);
        }
    }

    private void _clearOneTabCache(String tableName) {
        Set set = (Set)map_tableSqlKey.get(tableName);
        if (set != null) {
            for (String sqlKey : set) {
                try {
                    this.clearInExtCache(sqlKey);
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), e);
                }
            }
            set = null;
            map_tableSqlKey.remove(tableName);
        }
    }

    public void clear(String sql) {
        if (DefaultBeeExtCache.getUseLevelTwo()) {
            int j;
            List<String> tableNameList = CacheKey.genTableNameList(sql);
            for (j = 0; tableNameList != null && j < tableNameList.size(); ++j) {
                HoneyContext.addModifiedFlagForCache2(tableNameList.get(j), Boolean.TRUE);
                this._clearOneTabCache(tableNameList.get(j));
            }
            for (j = 0; tableNameList != null && j < tableNameList.size(); ++j) {
                HoneyContext.addModifiedFlagForCache2(tableNameList.get(j), Boolean.FALSE);
            }
        }
        CacheUtil.clear(sql);
    }

    public Object getInExtCache(String key) {
        return null;
    }

    public void addInExtCache(String key, Object result) {
    }

    public void clearInExtCache(String key) {
    }

    static {
        isShowSql = HoneyConfig.getHoneyConfig().showSQL;
        map_tableSqlKey = new ConcurrentHashMap<String, Set<String>>();
    }
}

