/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.HashMap;
import java.util.Map;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.util.PropertiesReader;

public class JdbcToJavaType {
    private static final String STRING = "String";
    private static Map<String, Map<String, String>> dbJdbc2JavaTypeMap = new HashMap<String, Map<String, String>>();
    private static PropertiesReader jdbcTypeCustomProp = new PropertiesReader("jdbcTypeToFieldType.properties");
    private static PropertiesReader jdbcTypeCustomProp_specificalDB = null;

    private JdbcToJavaType() {
    }

    public static Map<String, String> getJdbcToJavaType(String dbName) {
        String t_dbName = dbName == null ? dbName : dbName.toLowerCase();
        Map<String, String> map = dbJdbc2JavaTypeMap.get(t_dbName);
        if (map == null) {
            JdbcToJavaType.initTypeMapConfig(dbName);
            map = dbJdbc2JavaTypeMap.get(t_dbName);
            if (map == null) {
                map = JdbcToJavaType.getCommon();
                dbJdbc2JavaTypeMap.put(t_dbName, map);
            }
        }
        return map;
    }

    public static void setJdbcToJavaType(String databaseName, Map<String, String> oneDb_Jdbc2JavaTypeMap) {
        dbJdbc2JavaTypeMap.put(databaseName, oneDb_Jdbc2JavaTypeMap);
    }

    public static void appendJdbcToJavaType(String databaseName, Map<String, String> oneDb_Java2DbTypeMap) {
        Map<String, String> map = dbJdbc2JavaTypeMap.get(databaseName.toLowerCase());
        if (map == null) {
            JdbcToJavaType.setJdbcToJavaType(databaseName.toLowerCase(), oneDb_Java2DbTypeMap);
        } else {
            map.putAll(oneDb_Java2DbTypeMap);
        }
    }

    public static void initTypeMapConfig(String dbName) {
        if (dbName == null) {
            Logger.warn("The dbName is null");
            return;
        }
        String proFileName = "jdbcTypeToFieldType-{DbName}.properties";
        JdbcToJavaType.initJdbcTypeMap(dbName);
        JdbcToJavaType.appendJdbcTypeCustomProp(dbName);
        jdbcTypeCustomProp_specificalDB = new PropertiesReader(proFileName.replace("{DbName}", dbName));
        if (jdbcTypeCustomProp_specificalDB != null) {
            JdbcToJavaType.appendJdbcTypeCustomProp_specificalDB(dbName);
        }
    }

    private static void appendJdbcTypeCustomProp(String dbName) {
        Map<String, String> map = dbJdbc2JavaTypeMap.get(dbName.toLowerCase());
        if (map == null) {
            map = new HashMap<String, String>();
        }
        for (String s : jdbcTypeCustomProp.getKeys()) {
            map.put(s, jdbcTypeCustomProp.getValue(s));
        }
        JdbcToJavaType.setJdbcToJavaType(dbName, map);
    }

    private static void appendJdbcTypeCustomProp_specificalDB(String dbName) {
        Map<String, String> map = dbJdbc2JavaTypeMap.get(dbName.toLowerCase());
        if (map == null) {
            map = new HashMap<String, String>();
        }
        for (String s : jdbcTypeCustomProp_specificalDB.getKeys()) {
            map.put(s, jdbcTypeCustomProp_specificalDB.getValue(s));
        }
        JdbcToJavaType.setJdbcToJavaType(dbName, map);
    }

    public static void initJdbcTypeMap(String dbName) {
        if ("Oracle".equalsIgnoreCase(dbName)) {
            JdbcToJavaType.setJdbcToJavaType("Oracle".toLowerCase(), JdbcToJavaType.forOracle());
        } else if ("SQLite".equalsIgnoreCase(dbName)) {
            JdbcToJavaType.setJdbcToJavaType("SQLite".toLowerCase(), JdbcToJavaType.forSQLite());
        } else if ("MySQL".equalsIgnoreCase(dbName)) {
            JdbcToJavaType.setJdbcToJavaType("MySQL".toLowerCase(), JdbcToJavaType.forMySQL());
        } else if ("MariaDB".equalsIgnoreCase(dbName)) {
            JdbcToJavaType.setJdbcToJavaType("MariaDB".toLowerCase(), JdbcToJavaType.forMySQL());
        } else if ("H2".equalsIgnoreCase(dbName)) {
            JdbcToJavaType.setJdbcToJavaType("H2".toLowerCase(), JdbcToJavaType.forH2());
        } else if ("PostgreSQL".equalsIgnoreCase(dbName)) {
            JdbcToJavaType.setJdbcToJavaType("PostgreSQL".toLowerCase(), JdbcToJavaType.forPostgreSQL());
        } else if ("Microsoft SQL Server".equalsIgnoreCase(dbName)) {
            JdbcToJavaType.setJdbcToJavaType("Microsoft SQL Server".toLowerCase(), JdbcToJavaType.forSQLSERVER());
        } else if ("Cassandra".equalsIgnoreCase(dbName)) {
            JdbcToJavaType.setJdbcToJavaType("Cassandra".toLowerCase(), JdbcToJavaType.forCassandra());
        } else if ("MongoDB".equalsIgnoreCase(dbName)) {
            JdbcToJavaType.setJdbcToJavaType("MongoDB".toLowerCase(), JdbcToJavaType.forMongoDB());
        } else {
            JdbcToJavaType.setJdbcToJavaType(dbName.toLowerCase(), JdbcToJavaType.getCommon());
        }
    }

    private static Map<String, String> getCommon() {
        HashMap<String, String> jdbc2JavaType = new HashMap<String, String>();
        jdbc2JavaType.put("CHAR", STRING);
        jdbc2JavaType.put("VARCHAR", STRING);
        jdbc2JavaType.put("LONGVARCHAR", STRING);
        jdbc2JavaType.put("CHARACTER", STRING);
        jdbc2JavaType.put("NVARCHAR", STRING);
        jdbc2JavaType.put("NCHAR", STRING);
        jdbc2JavaType.put("NUMERIC", "BigDecimal");
        jdbc2JavaType.put("DECIMAL", "BigDecimal");
        jdbc2JavaType.put("BIT", "Boolean");
        jdbc2JavaType.put("BOOLEAN", "Boolean");
        jdbc2JavaType.put("TINYINT", "Byte");
        jdbc2JavaType.put("SMALLINT", "Short");
        jdbc2JavaType.put("INT", "Integer");
        jdbc2JavaType.put("INTEGER", "Integer");
        jdbc2JavaType.put("BIGINT", "Long");
        jdbc2JavaType.put("REAL", "Float");
        jdbc2JavaType.put("FLOAT", "Float");
        jdbc2JavaType.put("DOUBLE", "Double");
        jdbc2JavaType.put("BINARY", "byte[]");
        jdbc2JavaType.put("VARBINARY", "byte[]");
        jdbc2JavaType.put("LONGVARBINARY", "byte[]");
        jdbc2JavaType.put("image", "byte[]");
        jdbc2JavaType.put("DATE", "Date");
        jdbc2JavaType.put("TIME", "Time");
        jdbc2JavaType.put("TIMESTAMP", "Timestamp");
        jdbc2JavaType.put("CLOB", "Clob");
        jdbc2JavaType.put("BLOB", "Blob");
        jdbc2JavaType.put("ARRAY", "Array");
        jdbc2JavaType.put("NCLOB", "java.sql.NClob");
        jdbc2JavaType.put("ROWID", "java.sql.RowId");
        jdbc2JavaType.put("SQLXML", "java.sql.SQLXML");
        jdbc2JavaType.put("TIMESTAMP_WITH_TIMEZONE", "Timestamp");
        jdbc2JavaType.put("TIMESTAMP WITH TIME ZONE", "Timestamp");
        jdbc2JavaType.put("TIMESTAMP WITH LOCAL TIME ZONE", "Timestamp");
        jdbc2JavaType.put("JSON", STRING);
        jdbc2JavaType.put("TEXT", STRING);
        jdbc2JavaType.put("LONGTEXT", STRING);
        jdbc2JavaType.put("TINYTEXT", STRING);
        jdbc2JavaType.put("MEDIUMTEXT", STRING);
        return jdbc2JavaType;
    }

    private static Map<String, String> forOracle() {
        Map<String, String> jdbc2JavaTypeMap = JdbcToJavaType.getCommon();
        jdbc2JavaTypeMap.put("LONG", STRING);
        jdbc2JavaTypeMap.put("VARCHAR2", STRING);
        jdbc2JavaTypeMap.put("NVARCHAR2", STRING);
        jdbc2JavaTypeMap.put("NUMBER", "BigDecimal");
        jdbc2JavaTypeMap.put("RAW", "byte[]");
        jdbc2JavaTypeMap.put("INTERVALYM", STRING);
        jdbc2JavaTypeMap.put("INTERVALDS", STRING);
        jdbc2JavaTypeMap.put("INTERVAL YEAR TO MONTH", STRING);
        jdbc2JavaTypeMap.put("INTERVAL DAY TO SECOND", STRING);
        jdbc2JavaTypeMap.put("DATE", "Timestamp");
        jdbc2JavaTypeMap.put("BINARY_DOUBLE", "oracle.sql.BINARY_DOUBLE");
        jdbc2JavaTypeMap.put("BINARY_FLOAT", "oracle.sql.BINARY_FLOAT");
        return jdbc2JavaTypeMap;
    }

    private static Map<String, String> forMySQL() {
        Map<String, String> jdbc2JavaTypeMap = JdbcToJavaType.getCommon();
        jdbc2JavaTypeMap.put("MEDIUMINT", "Integer");
        jdbc2JavaTypeMap.put("DATETIME", "Timestamp");
        jdbc2JavaTypeMap.put("TINYBLOB", "Blob");
        jdbc2JavaTypeMap.put("MEDIUMBLOB", "Blob");
        jdbc2JavaTypeMap.put("LONGBLOB", "Blob");
        jdbc2JavaTypeMap.put("YEAR", "Integer");
        jdbc2JavaTypeMap.put("TINYINT", "Byte");
        jdbc2JavaTypeMap.put("SMALLINT", "Short");
        jdbc2JavaTypeMap.put("TINYINT UNSIGNED", "Short");
        jdbc2JavaTypeMap.put("SMALLINT UNSIGNED", "Integer");
        jdbc2JavaTypeMap.put("INT UNSIGNED", "Long");
        jdbc2JavaTypeMap.put("BIGINT UNSIGNED", "BigInteger");
        return jdbc2JavaTypeMap;
    }

    private static Map<String, String> forSQLSERVER() {
        Map<String, String> jdbc2JavaTypeMap = JdbcToJavaType.getCommon();
        jdbc2JavaTypeMap.put("TINYINT", "Short");
        jdbc2JavaTypeMap.put("DATETIMEOFFSET", "microsoft.sql.DateTimeOffset");
        jdbc2JavaTypeMap.put("microsoft.sql.Types.DATETIMEOFFSET", "microsoft.sql.DateTimeOffset");
        jdbc2JavaTypeMap.put("datetime", "Timestamp");
        jdbc2JavaTypeMap.put("money", "BigDecimal");
        jdbc2JavaTypeMap.put("smallmoney", "BigDecimal");
        jdbc2JavaTypeMap.put("ntext", STRING);
        jdbc2JavaTypeMap.put("text", STRING);
        jdbc2JavaTypeMap.put("xml", STRING);
        jdbc2JavaTypeMap.put("smalldatetime", "Timestamp");
        jdbc2JavaTypeMap.put("uniqueidentifier", STRING);
        jdbc2JavaTypeMap.put("hierarchyid", "byte[]");
        jdbc2JavaTypeMap.put("image", "byte[]");
        return jdbc2JavaTypeMap;
    }

    private static Map<String, String> _forH2AndSQLiteCommPart() {
        Map<String, String> jdbc2JavaTypeMap = JdbcToJavaType.getCommon();
        jdbc2JavaTypeMap.put("MEDIUMINT", "Integer");
        jdbc2JavaTypeMap.put("INT4", "Integer");
        jdbc2JavaTypeMap.put("INT2", "Short");
        jdbc2JavaTypeMap.put("INT8", "Long");
        jdbc2JavaTypeMap.put("NUMBER", "BigDecimal");
        jdbc2JavaTypeMap.put("NUMERIC", "BigDecimal");
        jdbc2JavaTypeMap.put("BOOLEAN", "Boolean");
        jdbc2JavaTypeMap.put("BOOL", "Boolean");
        jdbc2JavaTypeMap.put("BIT", "Boolean");
        jdbc2JavaTypeMap.put("FLOAT8", "Double");
        jdbc2JavaTypeMap.put("FLOAT4 ", "Float");
        jdbc2JavaTypeMap.put("CHARACTER", STRING);
        jdbc2JavaTypeMap.put("VARCHAR2", STRING);
        jdbc2JavaTypeMap.put("NVARCHAR2", STRING);
        jdbc2JavaTypeMap.put("VARCHAR_IGNORECASE", STRING);
        return jdbc2JavaTypeMap;
    }

    private static Map<String, String> forH2() {
        Map<String, String> jdbc2JavaTypeMap = JdbcToJavaType.getCommon();
        jdbc2JavaTypeMap.putAll(JdbcToJavaType._forH2AndSQLiteCommPart());
        jdbc2JavaTypeMap.put("SIGNED", "Integer");
        jdbc2JavaTypeMap.put("DEC", "BigDecimal");
        jdbc2JavaTypeMap.put("YEAR", "Byte");
        jdbc2JavaTypeMap.put("BINARY VARYING", "byte[]");
        jdbc2JavaTypeMap.put("WITHOUT TIME ZONE", "Time");
        jdbc2JavaTypeMap.put("BINARY LARGE OBJECT", "Blob");
        jdbc2JavaTypeMap.put("CHARACTER LARGE OBJECT", "Clob");
        jdbc2JavaTypeMap.put("CHARACTER VARYING", STRING);
        jdbc2JavaTypeMap.put("VARCHAR_CASESENSITIVE", STRING);
        jdbc2JavaTypeMap.put("VARCHAR_IGNORECASE", STRING);
        jdbc2JavaTypeMap.put("IDENTITY", "Long");
        jdbc2JavaTypeMap.put("UUID", "java.util.UUID");
        jdbc2JavaTypeMap.put("TIME", "Object");
        jdbc2JavaTypeMap.put("ENUM", "Integer");
        jdbc2JavaTypeMap.put("ARRAY", "Object[]");
        jdbc2JavaTypeMap.put("GEOMETRY", STRING);
        jdbc2JavaTypeMap.put("POINT", STRING);
        jdbc2JavaTypeMap.put("LINESTRING", STRING);
        jdbc2JavaTypeMap.put("POLYGON", STRING);
        jdbc2JavaTypeMap.put("MULTIPOINT", STRING);
        jdbc2JavaTypeMap.put("MULTILINESTRING", STRING);
        jdbc2JavaTypeMap.put("MULTIPOLYGON", STRING);
        jdbc2JavaTypeMap.put("GEOMETRYCOLLECTION", STRING);
        return jdbc2JavaTypeMap;
    }

    private static Map<String, String> forSQLite() {
        Map<String, String> jdbc2JavaTypeMap = JdbcToJavaType.getCommon();
        jdbc2JavaTypeMap.putAll(JdbcToJavaType._forH2AndSQLiteCommPart());
        jdbc2JavaTypeMap.put("VARYING CHARACTER", STRING);
        jdbc2JavaTypeMap.put("NATIVE CHARACTER", STRING);
        jdbc2JavaTypeMap.put("TEXT", STRING);
        jdbc2JavaTypeMap.put("DOUBLE PRECISION", "Double");
        jdbc2JavaTypeMap.put("DATETIME", STRING);
        jdbc2JavaTypeMap.put("INTEGER", "Long");
        jdbc2JavaTypeMap.put("UNSIGNED BIG INT", "Long");
        jdbc2JavaTypeMap.put("VARYING", STRING);
        jdbc2JavaTypeMap.put("DATE", STRING);
        jdbc2JavaTypeMap.put("TIMESTAMP", STRING);
        return jdbc2JavaTypeMap;
    }

    private static Map<String, String> forPostgreSQL() {
        Map<String, String> jdbc2JavaTypeMap = JdbcToJavaType.getCommon();
        jdbc2JavaTypeMap.put("bigint", "Long");
        jdbc2JavaTypeMap.put("int8", "Long");
        jdbc2JavaTypeMap.put("bigserial", "Long");
        jdbc2JavaTypeMap.put("serial8", "Long");
        jdbc2JavaTypeMap.put("integer", "Integer");
        jdbc2JavaTypeMap.put("int", "Integer");
        jdbc2JavaTypeMap.put("int4", "Integer");
        jdbc2JavaTypeMap.put("serial", "Integer");
        jdbc2JavaTypeMap.put("serial4", "Integer");
        jdbc2JavaTypeMap.put("smallint", "Short");
        jdbc2JavaTypeMap.put("int2", "Short");
        jdbc2JavaTypeMap.put("smallserial", "Short");
        jdbc2JavaTypeMap.put("serial2", "Short");
        jdbc2JavaTypeMap.put("money", "BigDecimal");
        jdbc2JavaTypeMap.put("numeric", "BigDecimal");
        jdbc2JavaTypeMap.put("decimal", "BigDecimal");
        jdbc2JavaTypeMap.put("bit", STRING);
        jdbc2JavaTypeMap.put("bit varying", STRING);
        jdbc2JavaTypeMap.put("varbit", STRING);
        jdbc2JavaTypeMap.put("character", STRING);
        jdbc2JavaTypeMap.put("char", STRING);
        jdbc2JavaTypeMap.put("character varying", STRING);
        jdbc2JavaTypeMap.put("varchar", STRING);
        jdbc2JavaTypeMap.put("text", STRING);
        jdbc2JavaTypeMap.put("bpchar", STRING);
        jdbc2JavaTypeMap.put("boolean", "Boolean");
        jdbc2JavaTypeMap.put("bool", "Boolean");
        jdbc2JavaTypeMap.put("double precision", "Double");
        jdbc2JavaTypeMap.put("float8", "Double");
        jdbc2JavaTypeMap.put("real", "Float");
        jdbc2JavaTypeMap.put("float4", "Float");
        jdbc2JavaTypeMap.put("json", STRING);
        jdbc2JavaTypeMap.put("bytea", "byte[]");
        jdbc2JavaTypeMap.put("date", "Date");
        jdbc2JavaTypeMap.put("time", "Time");
        jdbc2JavaTypeMap.put("timestamp", "Timestamp");
        jdbc2JavaTypeMap.put("time without time zone", "Time");
        jdbc2JavaTypeMap.put("timetz", "Time");
        jdbc2JavaTypeMap.put("timestamp without time zone", "Timestamp");
        jdbc2JavaTypeMap.put("timestamptz", "Timestamp");
        jdbc2JavaTypeMap.put("uuid", "java.util.UUID");
        jdbc2JavaTypeMap.put("UUID", "java.util.UUID");
        jdbc2JavaTypeMap.put("xml", STRING);
        jdbc2JavaTypeMap.put("cidr", STRING);
        jdbc2JavaTypeMap.put("inet", STRING);
        jdbc2JavaTypeMap.put("macaddr", STRING);
        jdbc2JavaTypeMap.put("macaddr8", STRING);
        return jdbc2JavaTypeMap;
    }

    private static Map<String, String> forCassandra() {
        Map<String, String> jdbc2JavaTypeMap = JdbcToJavaType.getCommon();
        jdbc2JavaTypeMap.put("ascii", STRING);
        jdbc2JavaTypeMap.put("inet", STRING);
        jdbc2JavaTypeMap.put("timeuuid", "java.util.UUID");
        jdbc2JavaTypeMap.put("uuid", "java.util.UUID");
        jdbc2JavaTypeMap.put("boolean", "Boolean");
        jdbc2JavaTypeMap.put("varint", "Integer");
        jdbc2JavaTypeMap.put("duration", STRING);
        jdbc2JavaTypeMap.put("counter", "Long");
        jdbc2JavaTypeMap.put("list", "List");
        jdbc2JavaTypeMap.put("set", "Set");
        jdbc2JavaTypeMap.put("map", "Map");
        return jdbc2JavaTypeMap;
    }

    private static Map<String, String> forMongoDB() {
        Map<String, String> jdbc2JavaTypeMap = JdbcToJavaType.getCommon();
        jdbc2JavaTypeMap.put("org.bson.types.ObjectId", STRING);
        jdbc2JavaTypeMap.put("java.lang.String", STRING);
        jdbc2JavaTypeMap.put("java.util.ArrayList", "List");
        jdbc2JavaTypeMap.put("java.lang.Integer", "Integer");
        jdbc2JavaTypeMap.put("java.lang.Long", "Long");
        jdbc2JavaTypeMap.put("java.lang.Double", "Double");
        jdbc2JavaTypeMap.put("java.lang.Boolean", "Boolean");
        jdbc2JavaTypeMap.put("java.util.Date", "java.util.Date");
        jdbc2JavaTypeMap.put("org.bson.types.decimal128", "BigDecimal");
        jdbc2JavaTypeMap.put("org.bson.Document", "org.bson.Document");
        return jdbc2JavaTypeMap;
    }

    static {
        String dbName = HoneyConfig.getHoneyConfig().getDbName();
        JdbcToJavaType.initTypeMapConfig(dbName);
    }
}

