/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;

public class JndiDataSource {
    private DataSource dataSource;
    private String jndiName;

    public JndiDataSource() {
        this.initJndiDs();
    }

    public String getJndiName() {
        if (this.jndiName == null) {
            this.jndiName = "java:comp/env/" + HoneyConfig.getHoneyConfig().jndiName;
        }
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    private void initJndiDs() {
        try {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.getJndiName());
            Logger.info("[Bee] ==========get the DataSource with Jndi Type!");
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

